// ######################## R E A D M E #############################################
// ##                                                                              ##
// ##  tc2tex - written by Lorenz Milla, Germany - April 2012 - Version 1.0        ##
// ##                                                                              ##
// ##  draws a rectangle (or square), dissected into squares                       ##
// ##                                                                              ##
// ##  requires one argument: the name of the input text file.                     ##
// ##  usage example: tc2tex input.txt                                             ##
// ##                                                                              ##
// ##  Windows users can drag and drop the input text file onto tc2tex.exe         ##
// ##                                                                              ##
// ##  reads in the tablecode from the first line of the input file, for example:  ##
// ##  21 112 112 50 35 27 8 19 15 17 11 6 24 29 25 9 2 7 18 16 42 4 37 33         ##
// ##                                                                              ##
// ##  reads only the FIRST line from the text file, and only in this format.      ##
// ##                                                                              ##
// ##  creates a LaTeX-file "squares.tex".                                         ##
// ##                                                                              ##
// ##################################################################################


#include <stdio.h>
#include <malloc.h>


const float fontsizefactor = 0.5;     //scaling constant for font size (can be changed)
const float picturewidth = 150.0;     //width of the whole picture in mm (can be changed)


double skal(int n, int b) {           //individual font size for each number in picture
  double br,horiz,vert;
  br=picturewidth/b*n*2.8353;         // width of small square in pt (1mm = 2.8353 pt)
  vert=br/10.0;                       //each number is about 10pt high
  horiz=0;
  do horiz=horiz+1; while(n /= 10);   //now horiz is the length of n
  horiz=br/(5.0*horiz);               //each number is about 5pt wide
  if (vert<=horiz) {return fontsizefactor*vert; } else {return fontsizefactor*horiz; }
}


int main(int argc, char *argv[]) {
  int n,w,h;
  FILE *datei;
  int *f;
  int *code;
  int i,j,k;

  datei = fopen(argv[1],"r");

  fscanf(datei,"%d",&n);            // n = order of dissection
  fscanf(datei,"%d",&w);            // w = width of rectangle
  fscanf(datei,"%d",&h);            // h = height of rectangle

  f=(int*)malloc(w*sizeof(int));    // f[i] will tell how full the i-th column of the rectangle already is
  code=(int*)malloc(n*sizeof(int)); // code[0..n-1] will contain the sidelengths of the squares

  for(i=0;i<n;i++) { fscanf(datei,"%d",&code[i]); }
  fclose(datei);                    

  datei=fopen("squares.tex", "w");
  for(i=0;i<w;i++) { f[i]=0;}

  fprintf(datei,"\\documentclass[a4paper]{article}\n");
  fprintf(datei,"  \\usepackage[left=2cm,right=2cm,top=2cm,bottom=2cm]{geometry}\n");
  fprintf(datei,"  \\usepackage{pstricks-add}\n");
  fprintf(datei,"\\begin{document}\n");
  fprintf(datei,"  \\thispagestyle{empty}\n");
  fprintf(datei,"  \\psset{unit=%fmm}\n",picturewidth/w);  
  fprintf(datei,"  \\begin{pspicture}(0,0)(%d,%d)\n\n",w,h);

  for(k=0;k<n;k++) {
    i=0;
    for(j=1;j<w;j++) {
      if(f[j]<f[i]) { i=j; }
    }
    fprintf(datei,"    \\rput(%f,%f){\\psscalebox{%f}{%d}}\n",i+0.5*code[k],h-f[i]-0.5*code[k],skal(code[k],w),code[k]);
    fprintf(datei,"    \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",i,h-f[i],i,h-f[i]-code[k]);
    fprintf(datei,"    \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",i,h-f[i]-code[k],i+code[k],h-f[i]-code[k]);
    fprintf(datei,"    \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",i+code[k],h-f[i]-code[k],i+code[k],h-f[i]);
    fprintf(datei,"    \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n\n",i+code[k],h-f[i],i,h-f[i]);
    for(j=0;j<code[k];j++) {f[i+j]+=code[k];}
  }
  fprintf(datei,"  \\end{pspicture}\n");
  fprintf(datei,"\\end{document}\n");
  fclose(datei);
  
  printf("\n - - - - - Created squares.tex successfully. - - - - - -\n");
  return 0;
}
