// ##############################################################################################################################
// tc2ctex - compound tablecode to latex (works also with simple squared squares).
// written by Lorenz Milla, Dossenheim, Germany, May 2013.

// handles an input file with one tablecode per line, where every tablecode has two additional strings in the end:
// tablecode format: n w h e_1 e_2 ... e_n NAME DISCOV
// You must also add one extra line in the end containing only -42 to tell the program to stop.

// if the two strings in the input contain characters that latex doesn't understand,
// you have to replace them with their latex code: instead of [A&M] you write [A\&M] and instead of [S_J] you write [S\_J].

// example input file with tablecode lines, every one with one additional ID, and a new line with -42 in the end:
// ---------------------------------------
// 30 240 240 140 100 40 60 63 51 46 20 80 21 25 12 23 16 37 19 8 11 33 4 5 3 29 2 9 26 7 18 1 17 240a(1/4) [A\&M]
// 30 560 560 285 153 122 31 91 132 52 24 28 19 72 20 4 1 18 16 17 36 35 150 135 275 15 55 65 125 40 85 10 75 560a(33/48) [JDS]
// 30 612 612 200 228 184 44 140 135 65 37 139 96 102 43 193 103 32 71 245 174 48 50 95 22 19 7 5 45 12 3 28 25 612a(1/16) [JBW]
// -42
// ---------------------------------------

// requires one argument: the inputfilename.

// outputs one latex file per line from inputfilename.

// latex-files have to be compiled latex => PS => PDF !

// feel free to modify!
// ##############################################################################################################################


#include <stdio.h>
#include <malloc.h>


const int MO = 50; //maximum order of the squared squares to process



const float fontsizefactor = 0.618;     //scaling constant for font size (can be changed)
const float picturewidth = 78.0;     //width of the whole picture in mm (can be changed)


double skal(int n, int b) {           //individual font size for each number in picture
  double br,horiz,vert;
  br=picturewidth/b*n*2.8353;         // width of small square in pt (1mm = 2.8353 pt)
  vert=br/10.0;                       //each number is about 10pt high
  horiz=0;
  do horiz=horiz+1; while(n /= 10);   //now horiz is the length of n
  horiz=br/(5.0*horiz);               //each number is about 5pt wide
  if (vert<=horiz) {return fontsizefactor*vert; } else {return fontsizefactor*horiz; }
}





int main(int argc, char *argv[]) {
  int err,ok,fehlt,tmp;
  FILE *infile;
  FILE *datei;
  int *f;
  int i,j,k,ind;
  char unterschrift[1000];
  char id[45],discov[10],datname[45],buffer[20];
int l[MO],t[MO],r[MO],b[MO],tc[1][MO];
int numsub;
int L[100],T[100],R[100],B[100]; //maximum 100 subrectangles/subsquares ok!
int n,w,h;

  infile = fopen(argv[1],"r");
 // sprintf(outfilename,"%s-canon.txt",argv[1]);
 // outfile=fopen(outfilename, "w");

  fscanf(infile,"%d",&n);            // n = order of dissection
  ind=0;
  while(n!=-42) {
    ind++;
    //read in tablecode with identifier in the end (natural number)

    fscanf(infile,"%d",&w);            // w = width of rectangle
    fscanf(infile,"%d",&h);            // h = height of rectangle

    for(i=0;i<n;i++) {
      fscanf(infile,"%d",&tc[0][i]);
    }

    fscanf(infile,"%s",&id[0]); // id of squaring
    fscanf(infile,"%s",&discov[0]); // discoverer of squaring

    sprintf(unterschrift,"\\textbf{%d : %s %s} \\\\ \n          (",n,id,discov);

    // create ltrb code

    f=(int*)malloc(w*sizeof(int)); // f[i] gives filling of i-th column
    for(i=0;i<w;i++) { f[i]=0;}
    for(k=0;k<n;k++) {
     i = 0;
     for(j=1;j<w;j++) {
      if(f[j] < f[i]) { i = j; }
     }
     l[k] = i ;
     b[k] = f[i] + tc[0][k];
     t[k] = f[i];
     r[k] = i + tc[0][k];
     for(j=0;j<tc[0][k];j++) { f[i+j] += tc[0][k]; }
    }
    free(f);    
//    for(k=0;k<n;k++) {printf("%d: %d %d %d %d\n",tc[0][k],l[k],t[k],r[k],b[k]);}

    // find substructures
    numsub=0;
    for(i=0;i<n;i++) {
     for(j=0;j<n;j++) {
      if((i!=j)&&(l[i]<=l[j])&&(t[i]<=t[j])&&((r[j]-l[i])*(b[j]-t[i])<w*h)) { // topleft:i, bottomright:j, not full square, not single square
       err=0;

       //left border?

       fehlt=b[j]-b[i];
       ok=1;
       while ((fehlt>0)&&(err==0)&&(ok==1)) {
        ok=0;
        for(k=0;k<n;k++) {
         if ((l[k]==l[i])&&(t[k]==b[j]-fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[0][k]; }
        }
       }
       if (fehlt!=0){err=1;}

       //bottom border?

       fehlt=l[j]-l[i];
       ok=1;
       while ((fehlt>0)&&(err==0)&&(ok==1)) {
        ok=0;
        for(k=0;k<n;k++) {
         if ((b[k]==b[j])&&(r[k]==l[i]+fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[0][k]; }
        }
       }
       if (fehlt!=0){err=1;}

       //right border?

       fehlt=t[j]-t[i];
       ok=1;
       while ((fehlt>0)&&(err==0)&&(ok==1)) {
        ok=0;
        for(k=0;k<n;k++) {
         if ((r[k]==r[j])&&(b[k]==t[i]+fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[0][k]; }
        }
       }
       if (fehlt!=0){err=1;}

       //top border?

       fehlt=r[j]-r[i];
       ok=1;
       while ((fehlt>0)&&(err==0)&&(ok==1)) {
        ok=0;
        for(k=0;k<n;k++) {
         if ((t[k]==t[i])&&(l[k]==r[j]-fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[0][k]; }
        }
       }
       if (fehlt!=0){err=1;}

       if(err==0) { //found subrectangle or subsquare from i to j
        L[numsub]=l[i];
        T[numsub]=t[i];
        R[numsub]=r[j];
        B[numsub]=b[j];
        numsub++;
       }
      }
     }
    }
   // printf("id %d: %d subs\n",id,numsub);

   //sort subrectangles by area, ascending
   int ar[numsub];
   for(i=0;i<numsub;i++) {ar[i]=(R[i]-L[i])*(B[i]-T[i]);}
   for(i=0;i<numsub-1;i++) {
    for(j=i+1;j<numsub;j++) {
     if(ar[j]<ar[i]) {
      tmp=L[i]; L[i]=L[j]; L[j]=tmp;
      tmp=T[i]; T[i]=T[j]; T[j]=tmp;
      tmp=R[i]; R[i]=R[j]; R[j]=tmp;
      tmp=B[i]; B[i]=B[j]; B[j]=tmp;
      tmp=ar[i]; ar[i]=ar[j]; ar[j]=tmp;
     }
    }
   }

     L[numsub]=0; T[numsub]=0; R[numsub]=w; B[numsub]=h;


  sprintf(datname,"sq-%d.tex",ind+100000);
  datei=fopen(datname, "w");
 

  fprintf(datei,"\\documentclass{article}\n");
  fprintf(datei,"  \\usepackage[left=-4.4mm,right=-5mm,top=1mm,bottom=0mm,paperwidth=8cm,paperheight=11.1cm]{geometry}\n");
  fprintf(datei,"  \\usepackage{pstricks-add}\n");
  fprintf(datei,"\\begin{document}\n");
  fprintf(datei,"  \\thispagestyle{empty}\n  \\begin{minipage}[t]{8cm}\n");
  fprintf(datei,"    \\psset{unit=%fmm}\n",picturewidth/w);  
  fprintf(datei,"    \\setlength{\\parindent}{0pt}\n");  
  fprintf(datei,"    \\begin{pspicture}(0,0)(%d,%d)\n",w,h);



     for(k=0;k<n;k++) { //print cpss
      fprintf(datei,"      \\rput(%f,%f){\\psscalebox{%f}{%d}}\n",0.5*l[k]+0.5*r[k],h-0.5*t[k]-0.5*b[k],skal(r[k]-l[k],w),r[k]-l[k]);
     // fprintf(datei,"    \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",l[k],h-t[k],l[k],h-b[k]);
     // fprintf(datei,"    \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",l[k],h-b[k],r[k],h-b[k]);
      fprintf(datei,"        \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",r[k],h-b[k],r[k],h-t[k]);
      fprintf(datei,"        \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",r[k],h-t[k],l[k],h-t[k]);
      strcat(unterschrift,itoa(r[k]-l[k],buffer,10));
      if (k<n-1) {
        if((t[k]==t[k+1])&&(l[k+1]==r[k])) {strcat(unterschrift,",");} else {strcat(unterschrift,") (");}
      } else {strcat(unterschrift,")");}
     }
  fprintf(datei,"      \\psline[linewidth=0.1pt](0,0)(0,%d)\n",h);
  fprintf(datei,"      \\psline[linewidth=0.1pt](0,0)(%d,0)\n",w);

  fprintf(datei,"    \\end{pspicture}\n\n    \\medskip\n    \\begingroup\n      \\begin{minipage}[b][3cm][t]{3cm}\n");
  fprintf(datei,"        \\psset{unit=%fmm}\n",28.0/w);  
  fprintf(datei,"        \\begin{pspicture}(0,0)(%d,%d)\n",w,h);



     for(k=0;k<=numsub;k++) { //print subrects
      //fprintf(datei,"    \\rput(%f,%f){\\psscalebox{%f}{%d}}\n",i+0.5*code[k],h-f[i]-0.5*code[k],skal(code[k],w),code[k]);
      fprintf(datei,"          \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",L[k],h-T[k],L[k],h-B[k]);
      fprintf(datei,"          \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",L[k],h-B[k],R[k],h-B[k]);
      fprintf(datei,"          \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",R[k],h-B[k],R[k],h-T[k]);
      fprintf(datei,"          \\psline[linewidth=0.1pt](%d,%d)(%d,%d)\n",R[k],h-T[k],L[k],h-T[k]);
     }
  fprintf(datei,"        \\end{pspicture}\n      \\end{minipage}\n");
  fprintf(datei,"      \\begin{minipage}[b][3cm][t]{4.6cm}\n        \\begin{center}\n");
  fprintf(datei,"          %s\n",unterschrift);
  fprintf(datei,"        \\end{center}\n      \\end{minipage}\n    \\par\\endgroup\n  \\end{minipage}\n");
  fprintf(datei,"\\end{document}\n");
  fclose(datei);


    fscanf(infile,"%d",&n);            // n = order of dissection
  } // while n!=42
  fclose(infile);
//  fclose(outfile);
  
  printf("\n - - - - - Created %d files successfully. - - - - - -\n",ind);
  return 0;
}
