#include <stdio.h>
#include "xvideoshow.hpp"
#include "barlistuser.hpp"


class SquareDance : public XVideoShow, public BarListUser
{
public:
  SquareDance(unsigned int iWindowSize);
  ~SquareDance();
  void          UseBlackLinesOnWhite(); 
  void          UseWhiteLinesOnBlack();
  void          UseGreySquares();
  void          UseColoredSquares();
  void          SetLoopMode();
  void          SetDelay(unsigned int delay);
  void          ListCodes(); 
  bool          UseDataFile(const char *pFilename);
  virtual int   UpdateImageData();
  virtual void  DrawElement(unsigned long x, unsigned long y, unsigned long length);

private:
  void          DrawSquare();
  unsigned long m_ulDelay;
  double        m_scale;
  unsigned long m_CurrentSize; 
  FILE *        m_pDataFile;
  char          m_aBouwkampCode[4096];
  char          m_aTraditionalBC[4096];
  char          m_BackgroundColor;
  char          m_LineColor;
  bool          m_bDrawLines;
  bool          m_bColored;
  bool          m_bListCodes;
  bool          m_bLoopMode;
  bool          m_bFirstFrame;
};
