#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "squaredance.hpp"
#include "bars.hpp"
#include "bcsize.hpp"



SquareDance::SquareDance(unsigned int iWindowSize)
  : XVideoShow((char *)"SquareDance",iWindowSize,iWindowSize)
{
  m_scale = 1.0;
  m_pDataFile = 0;
  UseBlackLinesOnWhite();
  SetDelay(1000);
  m_bListCodes = false;
  m_bLoopMode = false;
  m_bFirstFrame = true;
}



SquareDance::~SquareDance()
{
  if (m_pDataFile)
  {
    fclose(m_pDataFile);
  }
}



void SquareDance::UseBlackLinesOnWhite() 
{ 
  m_bDrawLines = true;
  m_BackgroundColor = 255;
  m_LineColor = 0;
}



void SquareDance::UseWhiteLinesOnBlack()
{
  m_bDrawLines = true;
  m_BackgroundColor = 0;
  m_LineColor = 255;
}



void SquareDance::UseGreySquares()
{
  m_bDrawLines = false;
  m_bColored = false;
}



void SquareDance::UseColoredSquares()
{
  m_bDrawLines = false;
  m_bColored = true;
}



void SquareDance::SetLoopMode()
{
  m_bLoopMode = true;
}



void SquareDance::SetDelay(unsigned int delay) 
{
  m_ulDelay = delay * 1000;
}



void SquareDance::ListCodes() 
{
  m_bListCodes = true;
}



bool SquareDance::UseDataFile(const char *pFilename)
{
  if (m_pDataFile)
  {
    fclose(m_pDataFile);
    m_pDataFile = 0;
  }
  if (pFilename)
  {
    m_pDataFile = fopen(pFilename,"r");
  }

  return (m_pDataFile == 0);
}



int SquareDance::UpdateImageData()
{
  unsigned char *p = (unsigned char *)m_Image->data;
  int i;
  int j;

  //
  // clear image
  //
  for (i = 0; i < m_Image->height; i++)
  {
    for (j = 0; j < m_Image->width; j++, p += 2) 
    {
      //
      // "luminance"
      //
      p[0] = m_BackgroundColor;

      //
      // "chrominance/2"
      //
      p[1] = 128;
    }
  }

  if (!m_bFirstFrame)
  {
    usleep(m_ulDelay);
  }
  else
  {
    m_bFirstFrame = false;
  }
  if (m_pDataFile)
  {
    for (;;)
    {
      if (fgets(m_aBouwkampCode,4096,m_pDataFile) != 0)
      {
        if (m_aBouwkampCode[0] != '#')
        {
          DrawSquare();
          break;
        }
      }
      else
      { 
        if (m_bLoopMode)
        {
          rewind(m_pDataFile);
        }
        else
	{
          exit(0);
        }
      }
    }
  }

  return 0;
}



void SquareDance::DrawSquare()
{
  char *p = m_aBouwkampCode;
  unsigned long size = GetSize(&p);

  //
  // use bar list to get DrawElement called for each square
  //
  m_scale = (double)m_Image->height / size;
  m_CurrentSize = size;
  BarList Bars(size,size,this);
  int order = Bars.Take(p,m_bListCodes ? m_aTraditionalBC : 0);
  if (m_bListCodes)
  {
    unsigned long Min;
    unsigned long Max;
    Bars.GetElementRange(Min,Max);
    printf("order %d, size %ld, [%lu,...,%lu]: %s\n",
           order,size,Min,Max,m_aTraditionalBC);
  }
}


#if 0
#define LUMA       (char)(250 * (1 - (double)length / m_CurrentSize))
#define CHROMA(x)  (char)(45 + 200 * ((double)x + length / 2) / m_CurrentSize)
#else
#define LUMA       (char)((150 + (rand() % 100)) * (1 - (double)length / m_CurrentSize))
#define CHROMA(x)  (char)(45 + 200 * ((double)x + length / 2) / m_CurrentSize)
#endif

void SquareDance::DrawElement(unsigned long x, unsigned long y, unsigned long length)
{
  unsigned char *dot;
  unsigned char *p;
  unsigned long i;
  double k;

  dot = (unsigned char *)m_Image->data + 2 * ( 
        (m_Image->height - (unsigned long)(y * m_scale)) * m_Image->width + 
        (unsigned long)(x * m_scale));

  k = length * m_scale;
  if (m_bDrawLines)
  {
    //
    // horizontal line
    //
    for (i = 0, p = dot; i <= k; i++, p += 2)
    {
      p[0] = m_LineColor;
    }

    //
    // vertical line
    //
    for (i = 0, p = dot; i <= k; i++, p -= 2 * m_Image->width)
    {
      p[0] = m_LineColor;
    }
  }
  else
  {
    //
    // grey or colored mosaic
    //
    char luma = LUMA;
    char chroma1 = 128;
    char chroma2 = 128;
    unsigned long j;
    unsigned char *q;

    if (m_bColored)
    {
      chroma1 = CHROMA(x);
      chroma2 = CHROMA(y);
    }
    dot -= 2 * m_Image->width;
    dot += 2;
    for (i = 2, p = dot; i <= k; i++, p -= 2 * m_Image->width)
    {
      for (j = 2, q = p; j <= k; j++, q += 2)
      {
        q[0] = luma;
        q[1] = (j % 2) ? chroma1 : chroma2;
      }
    }
  }
}
