#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "squaredance.hpp"



static void help()
{
  
  puts("\n    Synopsis:\n");
  puts("      squaredance [options] datafile\n");
  puts("    Options available:\n");
  puts("      --blacklines\n");
  puts("           draw elements using black lines on white background\n");
  puts("      --whitelines\n");
  puts("           draw elements using white lines on black background\n");
  puts("      --grey\n");
  puts("           draw elements as grey squares\n");
  puts("      --color\n");
  puts("           draw elements as colored squares\n");
  puts("      --delay <milliseconds>\n");
  puts("           use specified delay time between frames\n");
  puts("      --list\n");
  puts("           list Bouwkamp codes during the square dance\n");
  puts("      --loop\n");
  puts("           show all the dissections in datafile in a loop\n\n");

  exit(0);
}



int main(int argc, char **argv) 
{
  unsigned int iWindowSize = 600;
  char *pDatafile = (char *)"spss.txt";

  if (char *pSize = getenv("SQUAREDANCE_WINDOW_SIZE"))
  {
    iWindowSize = strtoul(pSize,0,10);
  }

  SquareDance MySquareDance(iWindowSize);

  for (int i = 1; i < argc; i++)
  {
    if (!strcmp(argv[i],"--help") || !strcmp(argv[i],"-h"))
    {
      help();
    }
    if (!strcmp(argv[i],"--blacklines"))
    {
      MySquareDance.UseBlackLinesOnWhite();
    }
    else if (!strcmp(argv[i],"--whitelines"))
    {
      MySquareDance.UseWhiteLinesOnBlack();
    }
    else if (!strcmp(argv[i],"--grey"))
    {
      MySquareDance.UseGreySquares();
    }
    else if (!strcmp(argv[i],"--color"))
    {
      MySquareDance.UseColoredSquares();
    }
    else if (!strcmp(argv[i],"--delay"))
    {
      MySquareDance.SetDelay(atoi(argv[++i]));
    }
    else if (!strcmp(argv[i],"--list"))
    {
      MySquareDance.ListCodes();
    }
    else if (!strcmp(argv[i],"--loop"))
    {
      MySquareDance.SetLoopMode();
    }
    else if (strncmp(argv[i],"--",2))
    {
      pDatafile = argv[i];
      break;
    }
  }

  if (!MySquareDance.UseDataFile(pDatafile))
  {
    MySquareDance.Go();
  }
  else
  {
    fprintf(stderr,"cannot open datafile %s\n",pDatafile);
  }
  
  return 0;
}
