#include <stdio.h>
#include <stdlib.h>
#include <string.h>



struct spss 
{
  char buffer[4096];
  int  elements[1024];
  int  n;
};



static int compare_spss_elements(const void *x, const void *y)
{
  return (*(int *)y - *(int *)x);
}



static int size;



static int sort_spss_elements(struct spss *spss)
{
  char *p = spss->buffer;

  //
  // just assume 00TABLE format
  //
  unsigned long order  = strtoul(p,&p,10);
  unsigned long width  = strtoul(p,&p,10);
  unsigned long height = strtoul(p,&p,10);
  size = width;
  
  for (spss->n = 0; *p != '\n'; )
  {
    if (isdigit(*p))
    {
      spss->elements[spss->n++] = strtol(p,&p,10);
    }
    else
    {
      p++;
    }
  }
 
  qsort(spss->elements,spss->n,sizeof(int),compare_spss_elements);

  return spss->n;
}



#define INTERVALS      10000

static struct spss     spss;
static int             histogram[INTERVALS];



int main(int argc, char **argv)
{
  double ratio;
  int i;

  while (fgets(spss.buffer,4096,stdin) != NULL)
  {
    sort_spss_elements(&spss);
    for (i = 0; i < spss.n; i++)
    {
      ratio = (double)spss.elements[i] / size;
      histogram[(int)(INTERVALS * ratio)]++;
    }
  }
  for (i = 0; i < INTERVALS; i++)
  {
    printf("%d\n",histogram[i]);
  }

  return 0;
}
