#include <stdio.h>
#include <stdlib.h>
#include <string.h>



struct spss 
{
  char buffer[4096];
  int  elements[1024];
  int  n;
};



static int compare_spss_elements(const void *x, const void *y)
{
  return (*(int *)y - *(int *)x);
}



static int sort_spss_elements(struct spss *spss)
{
  char *p = spss->buffer;
  
  if (*p != '(')
  {
    //
    // assume 00TABLE format
    //
    unsigned long order  = strtoul(p,&p,10);
    unsigned long width  = strtoul(p,&p,10);
    unsigned long height = strtoul(p,&p,10);
  } 
  for (spss->n = 0; *p != '\n'; )
  {
    if (isdigit(*p))
    {
      spss->elements[spss->n++] = strtol(p,&p,10);
    }
    else
    {
      p++;
    }
  }
  qsort(spss->elements,spss->n,sizeof(int),compare_spss_elements);

  return spss->n;
}



static int spss_equal(struct spss *a, struct spss *b)
{
  if (a->n != b->n)
  {
    return 0;
  }

  return !memcmp(a->elements,b->elements,a->n * sizeof(int));
}



struct spss spss;


#define FOLLOWED_BY_ARGUMENT    ((i + 1 < argc) && (argv[i + 1][0] != '-'))

int main(int argc, char **argv)
{
  double min_ratio = 0.10;
  double ratio;
  int mode = 0;
  int i;

  for (i = 1; i < argc; i++)
  {
    if (!strcmp(argv[i],"--ratio") || !strcmp(argv[i],"-r"))
    {
      if (FOLLOWED_BY_ARGUMENT)
      {
        min_ratio = strtod(argv[++i],NULL);
      }
      else
      {
        fprintf(stderr,"%s: option %s ignored, no value given\n",argv[0],argv[i]);
      }
    }
    else if (!strcmp(argv[i],"--mode") || !strcmp(argv[i],"-m"))
    {
      if (FOLLOWED_BY_ARGUMENT)
      {
        mode = strtol(argv[++i],NULL,10);
      }
      else
      {
        fprintf(stderr,"%s: option %s ignored, no mode given\n",argv[0],argv[i]);
      }     
    }
  }

  while (fgets(spss.buffer,4096,stdin) != NULL)
  {
    sort_spss_elements(&spss);
    switch (mode)
    {
      default:
      case 0:
           ratio = (double)spss.elements[spss.n - 1] / spss.elements[0];
           if (min_ratio <= ratio)
           {
             fprintf(stderr,"%.3lf\n",ratio);
             printf("%s",spss.buffer);
           }
           break;

      case 1:
           for (i = 0; i < spss.n - 1; i++)
           {
             ratio = (double)spss.elements[i + 1] / spss.elements[i];
             if (min_ratio < ratio)
             {
               break;
             }   
           }
           if (i == spss.n - 1)
           {
             printf("%s",spss.buffer);
           }
           break;
    }
  }

  return 0;
}

