#include <stdio.h>
#include <stdlib.h>
#include <string.h>


struct spss 
{
  char buffer[4096];
  int  elements[256];
  int  n;
};



static int compare_spss_elements(const void *x, const void *y)
{
  return (*(int *)y - *(int *)x);
}



static int sort_spss_elements(struct spss *spss)
{
  char *p = spss->buffer;

  if (*p != '(')
  {
    //
    // assume 00TABLE format
    //
    unsigned long order  = strtoul(p,&p,10);
    unsigned long width  = strtoul(p,&p,10);
    unsigned long height = strtoul(p,&p,10);
  } 
  for (spss->n = 0; *p != '\n'; )
  {
    if (isdigit(*p))
    {
      spss->elements[spss->n++] = strtol(p,&p,10);
    }
    else
    {
      p++;
    }
  }
  qsort(spss->elements,spss->n,sizeof(int),compare_spss_elements);

  return spss->n;
}



static int spss_equal(struct spss *a, struct spss *b)
{
  int n = a->n;

  if (a->n != b->n)
  {
    return 0;
  }

  return !memcmp(a->elements,b->elements,n * sizeof(int));
}



static struct spss spss;
static struct spss saved_spss[16];



int main(int argc, char **argv)
{
  int required_matches = 1;
  int saved = 0;
  int i;

  if (1 < argc)
  {
    required_matches = strtol(argv[1],NULL,10);
  }

  while (fgets(spss.buffer,4096,stdin) != NULL)
  {
    sort_spss_elements(&spss);
    
    if (saved != 0) 
    {
      if (spss_equal(&spss,&saved_spss[0]))
      {
        memcpy(&saved_spss[saved++],&spss,sizeof(spss));
        if (15 <= saved)
        {
          fprintf(stderr,"must increase the maximum list size, sorry.\n");
          return -1;
        } 
      }
      else
      {
        if (required_matches < saved)
        {
          for (i = 0; i < saved; i++)
          {
            fputs(saved_spss[i].buffer,stdout);
          }
        }
        saved = 0;
      }
    }
    if (saved == 0)
    {
      memcpy(&saved_spss[saved++],&spss,sizeof(spss));
    }
  }

  return 0;
}
