#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "squaredance.hpp"
#include "bars.hpp"
#include "bcsize.hpp"



struct vertex
{
  unsigned long a;
  unsigned long b;
  unsigned long hits;
};

class VertexList
{
public:
  VertexList()
  {
    memset(vlist,0,1024 * sizeof(vertex));
    pNext = vlist;
    m_iCrossesFound = 0;
  };

  ~VertexList()
  {
  };

  void AddVertex(unsigned long a, unsigned long b)
  {
    for (int i = 0; pNext != vlist + i; i++)
    {
      if ((vlist[i].a == a) && (vlist[i].b == b))
      { 
        vlist[i].hits++;
        if (vlist[i].hits == 4)
        {
          m_iCrossesFound++;
        }
        return;
      }
    }
    pNext->a = a;
    pNext->b = b;
    pNext->hits = 1;
    pNext++;
  };

  int CrossesFound()
  {
    return m_iCrossesFound;
  };

private:

  vertex vlist[1024];
  vertex *pNext;
  int m_iCrossesFound;
};



class A : public BarListUser
{
public:
  A() {};
  ~A() {};

  virtual void DrawElement(unsigned long x, unsigned long y, unsigned long length)
  {
    m_VertexList.AddVertex(x,y);
    m_VertexList.AddVertex(x + length,y);
    m_VertexList.AddVertex(x,y + length);
    m_VertexList.AddVertex(x + length,y + length);
  };

  VertexList m_VertexList;
};



static char aBouwkampCode[4096];
static char aTraditionalBC[4096];



int main(int argc, char **argv)
{
  char *p;
  unsigned long size;
  int limit = 1;

  if (1 < argc)
  {
    limit = strtol(argv[1],0,10);
  }

  while (fgets(aBouwkampCode,4096,stdin) != NULL)
  {
    p = aBouwkampCode;
    size = GetSize(&p);
    A a;
    BarList Bars(size,size,&a);
    Bars.Take(p,aTraditionalBC);
    if (limit <= a.m_VertexList.CrossesFound())
    {
      puts(aTraditionalBC);
    }    
  }
 
  return 0;
}
