#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "squaredance.hpp"
#include "bars.hpp"
#include "bcsize.hpp"



struct vertex
{
  unsigned long x;
  unsigned long y;
};



struct square
{
  unsigned long left;
  unsigned long right;
  unsigned long bottom;
  unsigned long top;
};



class SquareList
{
public:
  SquareList()
  {
    memset(vlist,0,1024 * sizeof(vertex));
    pNextVertex = vlist;
    memset(slist,0,256 * sizeof(square));
    pNextSquare = slist;
  };

  ~SquareList() 
  {
  };

  void Add(unsigned long left, unsigned long right, unsigned long bottom, unsigned long top)
  {
    AddSquare(left,right,bottom,top);
    AddVertex(left,bottom);
    AddVertex(right,bottom);
    AddVertex(left,top);
    AddVertex(right,top);
  };

  int FindRects()
  {
    int r = 0;
    for (int i = 0; vlist + i < pNextVertex; i++)
    {
      for (int j = 0; vlist + j < pNextVertex; j++)
      {
        if (i == j)
	{
          continue;
        }
        for (int k = 0; vlist + k < pNextVertex; k++)
        {
          if ((k == i) || (k == j))
	  {
            continue;
	  }
          if ((vlist[i].x == vlist[j].x) && (vlist[i].y == vlist[k].y))
	  {
            for (int l = 0; vlist + l < pNextVertex; l++)
            {
              if ((l == i) || (l == j) || (l == k))
	      {
                continue;
	      }
              if ((vlist[l].x == vlist[k].x) && (vlist[l].y == vlist[j].y))
	      {             
                //
                // found four points which could form a rectangle -
                // check for a "blocking" square for each rectangle side
                //
                if (IsRealRectangle(vlist[i],vlist[j],vlist[k],vlist[l]))
		{
                  r++;
                }
              }
            }
          } 
        }
      }
    }

    return r;
  };

private:

  void AddVertex(unsigned long x, unsigned long y)
  {
    for (int i = 0; pNextVertex != vlist + i; i++)
    {
      if ((vlist[i].x == x) && (vlist[i].y == y))
      {        
        return;
      }
    }
    pNextVertex->x = x;
    pNextVertex->y = y;
    pNextVertex++;
  };

  void AddSquare(unsigned long left, unsigned long right, unsigned long bottom, unsigned long top)
  {
    pNextSquare->left = left;
    pNextSquare->right = right;
    pNextSquare->bottom = bottom;
    pNextSquare->top = top;
    pNextSquare++;
  };
              
  bool IsRealRectangle(vertex& i,vertex &j,vertex& k,vertex& l)
  {
    bool bRet = true;

    if ((k.x < i.x) || (i.y < j.y))
    {
      return false;
    } 

#if 0

    printf("(%d,%d)-(%d,%d)-(%d,%d)-(%d,%d)\n",
	i.x,i.y, 
        j.x,j.y, 
	k.x,k.y, 
        l.x,l.y); 

#endif

    //
    // i ---- k
    // |      |
    // j ---- l
    //

    for (int s = 0; bRet && (pNextSquare != slist + s); s++)
    {
      if (XCollisison(slist[s],i.x,k.x,k.y))
      {
        bRet = false;
      }
      if (XCollisison(slist[s],j.x,l.x,l.y))
      {
        bRet = false;
      }
      if (YCollisison(slist[s],j.y,i.y,i.x))
      {
        bRet = false;
      }
      if (YCollisison(slist[s],l.y,k.y,k.x))
      {
        bRet = false;
      }
    }

    return bRet;
  }

  bool XCollisison(square& s, unsigned long x1, unsigned long x2, unsigned long y)
  {
    return ((x1 <= s.left)   && (s.left  <= x2)  && 
            (x1 <= s.right)  && (s.right <= x2)  &&
	    (s.bottom < y)   && (y < s.top));
  };

  bool YCollisison(square& s, unsigned long y1, unsigned long y2, unsigned long x)
  {
    return ((y1 <= s.bottom) && (s.bottom <= y2) &&
	    (y1 <= s.top)    && (s.top <= y2)    &&
            (s.left < x)     && (x < s.right));
  }

  vertex vlist[1024];
  vertex *pNextVertex;
  square slist[256];
  square *pNextSquare;
};



class A : public BarListUser
{
public:
  A() {};
  ~A() {};

  virtual void DrawElement(unsigned long x, unsigned long y, unsigned long length)
  {
    m_SquareList.Add(x,x + length,y,y + length);
  };

  int FindRects()
  {
    return m_SquareList.FindRects();
  };  

private:
  SquareList m_SquareList;
};



static char aBouwkampCode[4096];
static char aTraditionalBC[4096];



static void WorkAsFilter()
{
  char *p;
  unsigned long size = 0;
  int r = 1;

  while (fgets(aBouwkampCode,4096,stdin) != NULL)
  {
    // puts(aBouwkampCode);
    p = aBouwkampCode;
    size = GetSize(&p);

    A a;
    BarList Bars(size,size,&a);
    int order = Bars.Take(p,aTraditionalBC);
    int rects = a.FindRects();
    if (order + r < rects)
    {
      //
      // write CPSS to stdout
      //
      fputs(aBouwkampCode,stdout);
    }
    else
    {
      //
      // write SPSS to file descriptor 3 (if opened)
      //
      write(3,aBouwkampCode,strlen(aBouwkampCode));
    }
  }
}



static void CheckBigLists(const char *biglist, const char *table)
{
  FILE *b = fopen(biglist,"r");
  FILE *t = fopen(table,"r");
  char listline[4096];
  char tableline[4096];
  char *p;
  unsigned long size = 0;
  int i = 0;

  while ((fgets(listline,4096,b) != 0) &&
	 (fgets(tableline,4096,t) != 0))
  {
    i++;
    p = tableline;
    size = GetSize(&p);
    A a;
    BarList Bars(size,size,&a);
    int order = Bars.Take(p,aTraditionalBC);
    int rects = a.FindRects();
    if (order + 1 < rects)
    {
      //
      // CPSS
      //
      if (!strstr(listline,"COMP"))
      {
        printf("*** error at line %d: dissection is COMPOUND\n",i);
        printf("  %s  %s",listline,tableline);
      }
    }
    else
    {
      //
      // SPSS
      //
      if (!strstr(listline,"SIMP"))
      {
        printf("*** error at line %d: dissection is SIMPLE \n",i);
        printf("  %s  %s",listline,tableline);
      }
    }    
  }

  fclose(b);
  fclose(t);
}



int main(int argc, char **argv)
{

  if (argc == 1)
  {
    WorkAsFilter();
  }
  else if (argc == 3)
  {
    CheckBigLists(argv[1],argv[2]);
  }

  return 0;
}
