#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "bcsize.hpp"



unsigned long GetSize(char **pBouwkampCode)
{
  unsigned long size = 0;
  char *p = strchr(*pBouwkampCode,'(');
  if (p)
  { 
    *pBouwkampCode = p;

    //
    // compute size from first Bouwkamp Code group
    //
    size = 0;
    do
    {
      p++;
      size += strtoul(p,&p,10);
    } while (*p == ',');
  }
  else
  {
    //
    // get size from OOTABLE line
    //
    strtoul(*pBouwkampCode,&p,10);
    unsigned long width  = strtoul(p,&p,10);
    unsigned long height = strtoul(p,&p,10);
    if (width != height)
    {
      fprintf(stderr,"*** not a square: %s\n",*pBouwkampCode);
    }
    size = width;

    *pBouwkampCode = p;
  }

  return size;
}
