#include <string.h>
#include <stdlib.h>
#include "squaredance.hpp"
#include "bars.hpp"
#include "bcsize.hpp"



static unsigned long size;



class A : public BarListUser
{
public:
  A(unsigned long ulOffsX, unsigned long ulOffsY) 
  {
    m_ulOffsX = ulOffsX;
    m_ulOffsY = ulOffsY;
  };
  ~A() {};
  virtual void DrawElement(unsigned long x, unsigned long y, unsigned long length)
  {
    double c = 2.0 * (double)length / size;
    double red = 0.0;
    double green = 0.0;
    double blue = 0.0;

    if (length % 4 == 2)
    {
      red   = 1.0;
      green = 0.33;
      blue  = 0.33;
    }
    else if (length % 4 == 1)
    {
      red   = 0.5;
      green = 1.0;
      blue  = 0.5;
    }
    else if (length % 4 == 0)
    {
      red   = 0.25;
      green = 0.25;
      blue  = 1.0;
    }
    else
    {
      red   = 1.0;
      green = 1.0;
      blue  = 0.5;
    }

    if (c < 0.1)
    {
      double a = red;
      red = blue;
      blue = a;
      c *= 9;
    }
    else if (c < 0.25)
    {
      double a = red;
      red = blue;
      blue = a;
      c *= 5;
    }

    printf("fill p shifted (-0.5u,-0.5u) scaled %lf shifted (%lfu,%lfu) withcolor %lf * red + %lf * green + %lf * blue;\n",
           1.0 * length,x + m_ulOffsX + length/2.0,y + m_ulOffsY + length/2.0,red * c,green * c,blue * c);
#if 1
    printf("draw q scaled %lu shifted (%luu,%luu) withcolor white;\n",
           length,x + m_ulOffsX,y + m_ulOffsY);
#endif
  }

private:
  unsigned long m_ulOffsX;
  unsigned long m_ulOffsY; 
};



static char aBouwkampCode[4096];
static char aTraditionalBC[4096];



int main(int argc, char **argv)
{
  char *p;
  unsigned int i;
  double width = 127.0;

  for (int i = 1; i < argc; i++)
  {
    if (!strcmp(argv[i],"--width") || !strcmp(argv[i],"-w"))
    {
      width = strtod(argv[++i],0);
    }
  }

  i = 0;
  while (fgets(aBouwkampCode,4096,stdin) != NULL)
  {
    p = aBouwkampCode;
    size = GetSize(&p);
    printf("beginfig(%d);\n",++i);
    printf("u := %lfmm;\n",width / size);
    printf("path p;\n");
    printf("path q;\n");
    printf("q := (0,0)--(u,0)--(u,u)--(0,u)--cycle;\n");
    printf("p := (0,0)--(0.5u,0.25u)--(u,0)--(0.75u,0.5u)--(u,u)--(0.5u,0.75u)--(0,u)--(0.25u,0.5u)--cycle;\n");
    printf("p := q;\n");
    printf("pickup pencircle scaled 0.66bp;\n");
    A a(0,0);
    BarList Bars(size,size,&a);
    Bars.Take(p,aTraditionalBC);
    puts("endfig;");
  }
  puts("end;");

  return 0;
}
