#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "squaredance.hpp"
#include "bars.hpp"
#include "bcsize.hpp"



class A : public BarListUser
{
public:
  A(double UnitLength, bool bNumbers, int iGraph) 
  {
    m_UnitLength = UnitLength;
    m_bNumbers = bNumbers;
    m_iGraph = iGraph;
  };
  ~A() {};
  virtual void DrawElement(unsigned long x, unsigned long y, unsigned long length)
  {
    if (m_iGraph == 0)
    {
      //
      // put out two lines (an SW angle) of a LaTeX picture
      //
      printf("\\put(%lu,%lu){\\line(0,1){%lu}}\n",x,y,length);
      printf("\\put(%lu,%lu){\\line(1,0){%lu}}\n",x,y,length);
    }
    else if (m_iGraph == 1)
    {
      printf("\\put(%lu,%lu){\\line(0,1){%lu}}\n",x + length / 2 ,y,length);
      printf("\\thicklines\\put(%lu,%lu){\\line(1,0){%lu}}\\thinlines\n",x,y,length);
    }
    else if (m_iGraph == -1)
    {
      printf("\\thicklines\\put(%lu,%lu){\\line(0,1){%lu}}\\thinlines\n",x,y,length);
      printf("\\put(%lu,%lu){\\line(1,0){%lu}}\n",x,y + length / 2,length);
    }
    
    if ((m_bNumbers) && (7.5 < length * m_UnitLength))
    {
     char s[16];
     sprintf(s,"%lu",length);
     printf("\\put(%lf,%lf){\\scriptsize %s}\n",
             x + (double)length / 2 - 0.66 * strlen(s) / m_UnitLength,
             y + (double)length / 2 - 0.8 / m_UnitLength,
             s);
    }
  };

private:
  double m_UnitLength;
  bool   m_bNumbers;
  int    m_iGraph;
};



static char aBouwkampCode[4096];
static char aTraditionalBC[4096];



int main(int argc, char **argv)
{
  char *p;
  unsigned long size = 0;
  double width = 180.0;
  int columns = 1;
  bool bNumbers = false;
  int iGraph = 0;
  int i = 0;

  for (int i = 1; i < argc; i++)
  {
    if (!strcmp(argv[i],"--width") || !strcmp(argv[i],"-w"))
    {
      width = atof(argv[++i]);
    }
    if (!strcmp(argv[i],"--columns") || !strcmp(argv[i],"-c"))
    {
      columns = atoi(argv[++i]);
    }
    else if (!strcmp(argv[i],"--numbers") || !strcmp(argv[i],"-n"))
    {
      bNumbers = true;
    }
    else if (!strcmp(argv[i],"-g1"))
    {
      iGraph = 1;
    }
    else if (!strcmp(argv[i],"-g2"))
    {
      iGraph = -1;
    }
  }

  i = 0;
  while (fgets(aBouwkampCode,4096,stdin) != NULL)
  {
    p = aBouwkampCode;
    size = GetSize(&p);
    double unitlength = width / size;
    printf("\\setlength{\\unitlength}{%.12lfmm}\n",unitlength);
    printf("\\hbox{}\\hfill\\begin{picture}(%lu,%lu)\n",size,size);
    A a(unitlength,bNumbers,iGraph);
    BarList Bars(size,size,&a);
    Bars.Take(p,aTraditionalBC);
    if (iGraph < 1)
    {
      printf("\\put(%lu,0){\\line(0,1){%lu}}\n",size,size);
    }
    if (-1 < iGraph)
    {
      printf("\\put(0,%lu){\\line(1,0){%lu}}\n",size,size);
    }
    printf("\\end{picture}\\hfill\\hbox{}\n");

    if (columns == 1)
    {
      char *q;
      printf("\n\\vskip5mm\n");
      for (q = 0, p = aTraditionalBC; p != 0; q = 0) 
      { 
        if (80 < strlen(p))
	{
          q = strchr(p + 75,'(');
          if (q)
	  {
            *q = '\0';
          }
        }
        printf("\\centerline{\\small\\hspace*{1em}%s}\n",p);
        if (q)
	{
          *q = '(';
        }
        p = q;
      }
      printf("\\vskip7mm\n\n");
    }
    else if (++i % columns == 0)
    {
      printf("\\hfill\\hbox{}\\vfill\\hbox{}\n");
    }
  }
 
  return 0;
}
