#include <list>
#include <string>
#include "barlistuser.hpp"



class Bar
{
public:
  Bar(unsigned long h, unsigned long a, unsigned long b) 
  {
    m_h = h;
    m_a = a;
    m_b = b;
  };

  ~Bar() {};

  bool JoinWith(Bar& Bar)
  {
    //
    // must have the same height
    //
    if (m_h != Bar.m_h)
    {
      return true;
    }
   
    //
    // right border must be equal to left border of other bar
    //
    if (m_b != Bar.m_a)
    {
      return true;
    }

    m_b = Bar.m_b;

    return false;
  };

  unsigned long m_h; // height
  unsigned long m_a; // left border
  unsigned long m_b; // right border
};



class BarList
{
public:
  BarList(unsigned long x, unsigned long y, BarListUser *pUser = 0);
  ~BarList();

  int Take(const char *pElements, char *pTraditionalBC = 0);
  void GetElementRange(unsigned long& Min, unsigned long& Max)
  {
    Min = m_min;
    Max = m_max;
  };

private:

  std::string        m_Elements;
  unsigned long      m_x;    // width
  unsigned long      m_y;    // height
  std::list<Bar>     m_list; // work list of bars
  unsigned long      m_min;
  unsigned long      m_max;
  BarListUser       *m_pUser;
};
