#include <assert.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "squaredance.hpp"
#include "bars.hpp"



BarList::BarList(unsigned long x, unsigned long y, BarListUser *pUser)
{
  m_x = x;
  m_y = y;
  Bar RootBar(0,0,m_x);
  m_list.push_back(RootBar);
  m_pUser = pUser;
  m_min = 0;
  m_max = 0;
}



BarList::~BarList()
{
  if (1 < m_list.size())
  {
    fprintf(stderr,"*** trapped %lu bars left\n", m_list.size());
    fprintf(stderr,"    %s\n",m_Elements.c_str());
  }
}



int BarList::Take(const char *pElements, char *pTraditionalBC)
{
  int iElements = 0;
  char *p = const_cast<char *>(pElements);
  char *q = pTraditionalBC;

  m_Elements = std::string(pElements);
  for (; (*p != '\0') && (*p != '*'); p += strspn(p,") \t\r\n"))
  {
    p += strspn(p,"( \t");

    //
    // select bar with minimum height -
    // New elements are to be put below it.
    //
    std::list<Bar>::iterator k = m_list.begin();
    for (std::list<Bar>::iterator j = m_list.begin(); j != m_list.end(); j++)
    { 
      if (j->m_h < k->m_h)
      {
        k = j;
      }
    }

    //
    // start rewriting Bouwkamp code in its original form if requested
    //
    if (q)
    {
      q += sprintf(q,"(");
    }

    //
    // make new bars below bar referred to by k, then forget this bar -
    //
    // The elements put below the minimum bar selected above 
    // have to fit into the interval below it, exactly.
    //
    unsigned long l = k->m_b - k->m_a;
    unsigned long a;
    unsigned long e;
    for (a = 0; a < l; a += e)
    {
      p += strspn(p,", \t");
      if (!isdigit(*p))
      {
        fprintf(stderr,"*** trapped nondigit character 0x%02x\n",*p);
        fprintf(stderr,"    %s\n",pElements);
        return iElements;
      }

      e = strtoul(p,&p,10);
      Bar b(k->m_h + e, k->m_a + a, k->m_a + a + e);
      m_list.insert(k,b);
 
      if (m_pUser)
      {
        long y = m_y - b.m_h;
        if (0 <= y)
	{
          m_pUser->DrawElement(b.m_a,y,e);
        } 
      }

      //
      // update some statistics
      //
      if ((e < m_min) || (m_min == 0))
      {
        m_min = e;
      }
      if (m_max < e)
      {
        m_max = e;
      }
      iElements++;

      //
      // write Bouwkamp code in its original form if requested
      //
      if (q)
      {
        q += sprintf(q,"%s%lu",(a != 0) ? "," : "",e); 
      }
    }

    //
    // finish Bouwkamp code group in its original form if requested
    //
    if (q)
    {
      q += sprintf(q,")");
    }
    m_list.erase(k);
    if (a != l)
    {
      fputs("*** trapped a != l\n",stderr);
      fprintf(stderr,"    %s\n",pElements);
    }

    //
    // try to join all adjacent bars
    //
    for (std::list<Bar>::iterator j = m_list.begin(); j != m_list.end();)
    { 
      std::list<Bar>::iterator n = j;
      if ((++n != m_list.end()) && !j->JoinWith(*n))
      {
        m_list.erase(n);
      }
      else
      {
        j++;
      }
    }
  }

  return iElements;
}
