// Stuart Anderson stuart.errol.anderson@gmail.com
// SQT (Squared Tiler)
// squared square/rectangle finder , finds ciss siss spss cpss cpsr cisr spsr sisr; and produces canonical bouwkampcode
// version 3#; date: 21st-Apr 2024
// latest version http://www.squaring.net/downloads

#include <iostream>
#include <cstdio>
#include <fstream>
#include <string>
#include <set>
#include <sstream>
#include <iomanip>
#include <vector>
#include <algorithm>
#include <functional>
#include <cmath>
#include <iterator>
#include <cstring>
#include <cstdlib>
#include <list>
#include <exception>
#include <utility>
#include <limits>
#include <boost/numeric/ublas/lu.hpp>
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/matrix_proxy.hpp>
#include <boost/numeric/ublas/triangular.hpp>
#include <boost/numeric/ublas/io.hpp>
#include <ctime>
#include <limits.h>


namespace ublas = boost::numeric::ublas;
using namespace std;

int gcd(int n,int m){return m==0?n:gcd(m,n%m);}

 #ifndef INVERT_MATRIX_HPP
 #define INVERT_MATRIX_HPP

 /* Matrix inversion routine. Uses lu_factorize and lu_substitute in uBLAS to invert a matrix and return a determinant */
 template<class T>
 double InvertMatrix (const ublas::matrix<T>& input, ublas::matrix<T>& inverse) {
	using namespace boost::numeric::ublas;
	typedef permutation_matrix<std::size_t> pmatrix;
	matrix<T> M(input);// create a working copy of the input
	pmatrix pm(M.size1());// create a permutation matrix for the LU-factorization
	int res = lu_factorize(M,pm);// perform LU-factorization
		if( res != 0 ) return 0;//if result is a zero determinant, the matrix is not invertible
	double product = 1;
	for(unsigned int i = 0; i<M.size1(); i++)
	{
		product = product * M(i,i);
	}
	inverse.assign(ublas::identity_matrix<T>(M.size1()));// create identity matrix of "inverse"
	lu_substitute(M, pm, inverse);// backsubstitute to get the inverse
	return product;
 }

#endif //INVERT_MATRIX_HPP
 

////////////////////////////////////////////////////////////////////////////////////////////////

void voltageG(vector < vector <int> >& GraphDual, unsigned int e) 
{
	unsigned int edge = e;
    do
    { 
		// if the target of the edge is an unvisited node 
		// and edge is not a reversal and its not the ground node
		if((GraphDual.at(edge).at(9) == -1)&&(GraphDual.at(edge).at(6)>= 0)) 
		{
			GraphDual.at(edge).at(8) = GraphDual.at(e).at(8);
			GraphDual.at(edge).at(9) = GraphDual.at(e).at(8) - GraphDual.at(edge).at(6);
			
			for (unsigned int a = 0; a < GraphDual.size(); a++) {
				for (unsigned int b = 0; b < GraphDual.size(); b++) {
					if ((GraphDual.at(b).at(0)==GraphDual.at(a).at(1))&&(GraphDual.at(b).at(8) == -1)) {
						GraphDual.at(b).at(8) = GraphDual.at(a).at(9);
					}
				}
			} 
			voltageG(GraphDual, GraphDual.at(edge).at(2));// do it again from target node / reversal edge
		} 
		edge = GraphDual.at(edge).at(12);
	} while (edge != e) ;
}


///////////////////////////////////////////////////////////////////////////////////////

void voltageD(vector < vector <int> >& GraphDual, unsigned int e) 
{
	unsigned int edge = e;
    do
    { 
		// if the target of the edge is an unvisited node 
		// and edge is not a reversal and its not the ground node
		if((GraphDual.at(edge).at(11) == -1)&&(GraphDual.at(edge).at(7)>= 0)) 
		{
			GraphDual.at(edge).at(10) = GraphDual.at(e).at(10);
			GraphDual.at(edge).at(11) = GraphDual.at(e).at(10) - GraphDual.at(edge).at(7);
			for (unsigned int a = 0; a < GraphDual.size(); a++) {
				for (unsigned int b = 0; b < GraphDual.size(); b++) {
					if ((GraphDual.at(b).at(3)==GraphDual.at(a).at(4))&&(GraphDual.at(b).at(10) == -1)) {
						GraphDual.at(b).at(10) = GraphDual.at(a).at(11);
					}
				}
			} 
			voltageD(GraphDual, GraphDual.at(edge).at(2));// do it again from target node / reversal edge
		} 
		edge = GraphDual.at(edge).at(5);
	} while (edge != e) ;
}

/////////////////////////////////////////////////////////////////////////////////////// 

bool simple_compound_test(int s0, int s1, int s2, vector<int> Size, vector<int> Top, vector<int> Left, vector<int> Right, vector<int> Bottom) {

		reverse(Top.begin(), Top.end());
		reverse(Left.begin(), Left.end());
		reverse(Right.begin(), Right.end());
		reverse(Bottom.begin(), Bottom.end());
		reverse(Size.begin(), Size.end());
		Size.push_back(s2);
		Size.push_back(s1);
		Size.push_back(s0);
		for(unsigned int y = 0; y<3;y++) {
			Top.push_back(0);
			Left.push_back(0);
			Right.push_back(0);
			Bottom.push_back(0);
		}
		reverse(Top.begin(), Top.end());
		reverse(Left.begin(), Left.end());
		reverse(Right.begin(), Right.end());
		reverse(Bottom.begin(), Bottom.end());
		reverse(Size.begin(), Size.end());
 		Size.push_back(Size.at(1));
 		Top.push_back(0);
 		Left.push_back(0);
 		Right.push_back(Size.at(1));
 		Bottom.push_back(Size.at(1));
 		bool comp;
	 	int top, left, right, bottom, squares, rectangles;
	 	top = 0;
 		left = 0;
 		right = 0;
 		bottom = 0;
 		squares = 0;
 		rectangles = 0;
		bool sw = false;
		bool ne = false;
		std::vector<bool> LeftEdge;
		std::vector<bool> TopEdge;
		std::vector<bool> RightEdge;
		std::vector<bool> BottomEdge;
		LeftEdge.assign(Size.at(2),false);
		TopEdge.assign(Size.at(1),false);
		RightEdge.assign(Size.at(2),false);
		BottomEdge.assign(Size.at(1),false);
		bool LeftExists = true;
		bool TopExists = true;
		bool RightExists = true;
		bool BottomExists = true;
		for (unsigned int k = 3; k< Size.size()-1; k++){
			top = Top.at(k);
			left = Left.at(k); // set north west corner, 
			for (unsigned int l = 3; l< Size.size()-1; l++){
				//std::cout<<"Right.at("<<l<<")= "<<Right.at(l)<<" left= "<<left<<" Bottom.at("<<l<<") = "<<Bottom.at(l) <<" top= "<<top<<std::endl;
				if ((Right.at(l) > left)&& (Bottom.at(l) > top) ){
					right = Right.at(l);
					bottom = Bottom.at(l);  //set south east corner
					for (unsigned int m= 3; m< Size.size()-1; m++){	
		   				if((Left.at(m) == left)&&(Bottom.at(m) == bottom)){
		   					//south west corner exists
		   		   			sw = true;
		   				}
		   		   		if ((Top.at(m) ==top)&&(Right.at(m) == right)){
		   					//north east corner exists
		   		   			ne = true;
		   					}
		   				}
						// if north west, south east, south west, and north east corners exist, found a rectangle/square, 
						if( (ne == true) && (sw == true)) {
			   			// can test if rectangle edges exist once we know the corners exist
						// test if a square or rectangle, update counts 
						// if  top - bottom = right - left, its a square
						if ( (bottom - top) == (right - left) ){
						if (k != l) {
							//std::cout<<"found square"<<std::endl;
				   			for (unsigned int q = 3; q< Size.size()-1; q++){
								// assign true to each point on integer lattice of tiling along, left, top, right, bottom edges
								if (left == Left.at(q)) {
									for ( int qq = Top.at(q); qq< Bottom.at(q); qq++){
										LeftEdge.at(qq) = true;
									}
								}
								if (right == Right.at(q)) {
									for ( int qq = Top.at(q); qq< Bottom.at(q); qq++){
										RightEdge.at(qq) = true;
									}
								}
								if (top == Top.at(q)) {
									for ( int qq = Left.at(q); qq< Right.at(q); qq++){
										TopEdge.at(qq) = true;
									}
								}
								if (bottom == Bottom.at(q)) {
									for ( int qq = Left.at(q); qq< Right.at(q); qq++){
										BottomEdge.at(qq) = true;
									}
								}		
							}
							// if any of the points on an edge are false, the rectangle edge doesnt exist
							for ( int q = left; q < right; q++){		
								if (TopEdge.at(q)==false){
									TopExists = false;
									//std::cout<<"no top"<<std::endl;
								}			
							}			
							for ( int q = top; q < bottom; q++){		
								if (RightEdge.at(q)==false){
									RightExists = false;
									//std::cout<<"no right"<<std::endl;
								}			
							}	
							for ( int q = left; q < right; q++){		
								if (BottomEdge.at(q)==false){
									BottomExists = false;
									//std::cout<<"no bottom"<<std::endl;
								}			
							}	
							for ( int q = top; q < bottom; q++){	
								if (LeftEdge.at(q)==false){
									LeftExists = false;
									//std::cout<<"no left"<<std::endl;
								}			
							}		
							// if all 4 edges exist it can be counted as a square or rectangular element/container/inclusion of the dissection							
							if ( (TopExists&&RightExists)&&(BottomExists&&	LeftExists) ) {				
							squares++;
							}	
							LeftEdge.assign(Size.at(2),false);
							TopEdge.assign(Size.at(1),false);
							RightEdge.assign(Size.at(2),false);
							BottomEdge.assign(Size.at(1),false);
							 LeftExists = true;
							 TopExists = true;
							 RightExists = true;
							 BottomExists = true;
							 } else squares++;
							 
					 	} else {
							// can test if rectangle edges exist once we know the corners exist
				   			for (unsigned int q = 3; q< Size.size()-1; q++){
								// assign true to each point on integer lattice of tiling along, left, top, right, bottom edges
								if (left == Left.at(q)) {
									for ( int qq = Top.at(q); qq< Bottom.at(q); qq++){
										LeftEdge.at(qq) = true;
									}
								}
								if (right == Right.at(q)) {
									for ( int qq = Top.at(q); qq< Bottom.at(q); qq++){
										RightEdge.at(qq) = true;
									}
								}
								if (top == Top.at(q)) {
									for ( int qq = Left.at(q); qq< Right.at(q); qq++){
										TopEdge.at(qq) = true;
									}
								}
								if (bottom == Bottom.at(q)) {
									for ( int qq = Left.at(q); qq< Right.at(q); qq++){
										BottomEdge.at(qq) = true;
									}
								}		
							}
							// if any of the points on an edge are false, the rectangle edge doesnt exist
							for ( int q = left; q < right; q++){		
								if (TopEdge.at(q)==false){
									TopExists = false;
									//std::cout<<"no top"<<std::endl;
								}			
							}			
							for ( int q = top; q < bottom; q++){		
								if (RightEdge.at(q)==false){
									RightExists = false;
									//std::cout<<"no right"<<std::endl;
								}			
							}	
							for ( int q = left; q < right; q++){		
								if (BottomEdge.at(q)==false){
									BottomExists = false;
									//std::cout<<"no bottom"<<std::endl;
								}			
							}	
							for ( int q = top; q < bottom; q++){	
								if (LeftEdge.at(q)==false){
									LeftExists = false;
									//std::cout<<"no left"<<std::endl;
								}			
							}		
							// if all 4 edges exist it can be counted as a square or rectangular element/container/inclusion of the dissection							
							if ( (TopExists&&RightExists)&&(BottomExists&&	LeftExists) ) {				
								rectangles++;
								}	
								LeftEdge.assign(Size.at(2),false);
								TopEdge.assign(Size.at(1),false);
								RightEdge.assign(Size.at(2),false);
								BottomEdge.assign(Size.at(1),false);

							 	LeftExists = true;
							 	TopExists = true;
							 	RightExists = true;
							 	BottomExists = true;
				   			   // } //else not trivial container rectangle
				   			} //square or rectangle else
				   		} // if nw & se corners true
					ne = false;
					sw = false;				   		
					} //next se corner
					 
			   	} //iterate over Size se corner
			} //iterate over Size nw corner
		//}	
		// Compound Simple Test		 if a tiling is a siss, or spss (number of squares = order + 1, 0 rectangles ) or an spsr, or sisr ( number of squares = order, 1 rectangle ) its simple
		// or else its compound; ciss, cpss, cisr, cpsr
	 	//std::cout<< "squares = "<<squares<<" rectangles = "<<rectangles<<" Order = "<<Size.at(0)<<std::endl;
		if (((squares==Size.at(0))&&(rectangles==1))||((squares==Size.at(0)+1)&&(rectangles==0))){
				comp = false;
				} else {
				comp = true;
		}
	 	squares = 0;
	 	rectangles = 0;
		 Top.clear() ;
		 Bottom.clear() ;
		 Left.clear();
		 Right.clear() ;
		 Size.clear() ;
		 return comp;
}

int main (int argc, char* argv[]){
	std::clock_t start;
    double duration;
    start = std::clock();
    bool do_simples = false; bool do_compounds = false; bool do_perfects = false; bool do_imperfects = false; bool do_rectangles = false; bool do_squares = false ;
    string plantri_file;
    if (argc == 1)
    {
		cout<<endl;
		cout <<"SQT (Squared Tiler)  by Stuart Anderson, "<<endl;
		cout <<"========================================================="<<endl;
		cout <<"stuart.errol.anderson@gmail.com"<<endl;
		cout <<"latest version http://www.squaring.net/downloads/sqfree-sqfind-sqt.zip"<<endl;
		cout <<"this version; v3 21st April 2024"<<endl;
		cout <<""<<endl;
		cout <<"Squared rectangles and squared squares are dissections of rectangles and squares "<<endl;
		cout <<"into smaller squares of integer sizes, called the elements."<<endl;
		cout <<"The number of elements is finite and is called the order of the dissection.  "<<endl;
		cout <<"Squared squares and squared rectangles are classified into simple or compound, and perfect or imperfect;"<<endl;
		cout <<"Compound dissections contain a smaller squared square or squared rectangle, simples do not."<<endl;
		cout <<"Perfect dissections have all squares different sizes, imperfects do not."<<endl;
		cout <<"The program sqt generates squared squares and squared rectangles"<<endl;
		cout <<"from 3-connected planar maps which are generated by the program plantri."<<endl;
		cout <<"The program sqt doesnt support 2-connected graphs (yet)."<<endl;
		cout <<"Plantri is by Gunnar Brinkmann and Brendan McKay and is available from"<<endl;
		cout <<"http://cs.anu.edu.au/~bdm/plantri/ ."<<endl;
		cout <<"sqt has the following options and combinations "<<endl;
		cout <<"Syntax is: sqt [-scpirS] filename"<<endl; 
		cout <<"(filename is a plantri binary file)."<<endl;
		cout <<"[-scpirS] are the optional arguments."<<endl;
		cout <<"s (lower case) for simples"<<endl;
		cout <<"c for compounds "<<endl;
		cout <<"p for perfects"<<endl;
		cout <<"i for imperfects"<<endl;
		cout <<"r for rectangles"<<endl;
		cout <<"S (upper case) for squares"<<endl;
		cout <<"If no arguments are given, default options used are -cspiS"<<endl;
		cout <<"i.e. compound, simple, perfect and imperfect squared squares (also known as quilts)."<<endl;
		cout <<"The output is saved as tablecode. Tablecode is canonical bouwkampcode without parentheses and commas"<<endl;
		cout <<"Format is ; order, width, height followed by the elements listed from left to right and top to bottom."<<endl;
		cout <<"Tablecode output  files are named with the input filename, a dash '-',"<<endl;
		cout <<"and letters s or c and p or i meaning simple or compound and perfect or imperfect,"<<endl;
		cout <<"followed by ss for squared squares or sr for squared rectangles"<<endl;
		cout <<endl;

		return 0;
    }
    else if (argc == 2)
	{
	    plantri_file = argv[1];
	    do_simples = true;
	    do_compounds = true;
	    do_perfects = true;
	    do_imperfects = true;
	    do_squares = true;
	    do_rectangles = false;
	}
	else if (argc == 3)
	{
		plantri_file = argv[2];
		string args = argv[1];
		if (args.find_first_of("-")!=string::npos)
		{
		    for (unsigned int c=1; c<args.length(); c++)//-scpirS
		    {
				if (args.find_first_of("s")!=string::npos) do_simples = true;
				if (args.find_first_of("c")!=string::npos) do_compounds = true;
				if (args.find_first_of("p")!=string::npos) do_perfects = true;
				if (args.find_first_of("i")!=string::npos) do_imperfects = true;
				if (args.find_first_of("r")!=string::npos) do_rectangles = true;
				if (args.find_first_of("S")!=string::npos) do_squares = true;
		    }
		    if (args.find_first_of("s")==string::npos) do_simples = false;
		    if (args.find_first_of("c")==string::npos) do_compounds = false;
		    if (args.find_first_of("p")==string::npos) do_perfects = false;
		    if (args.find_first_of("i")==string::npos) do_imperfects = false;
		    if (args.find_first_of("r")==string::npos) do_rectangles = false;
		    if (args.find_first_of("S")==string::npos) do_squares = false;
		} else { 
			cout<<"Syntax is: sqt [-scpirS] filename"<<endl;
			cout<<"type 'sqt', 'enter' for program information "<<endl;
			}
	}

    ifstream File(plantri_file.c_str(), ios::in | ios::binary);     
    if (!File) { // check it opened ok
    	std::cerr << "Cannot open file "<< plantri_file<< " \n"; 
    }


    cout<<"processing plantri file "<<plantri_file<<" ..."<<endl;
	int n=0; int v=0;unsigned int e=0; int f=0; int g =0 ;
	char c; 
    string line ="";
	vector< vector<unsigned int> > graph;
	vector<unsigned int> edges;
	int total_spss = 0; int total_spsr = 0; int total_siss = 0; int total_sisr = 0; int total_cpss = 0; int total_cpsr = 0; int total_ciss = 0; int total_cisr = 0;
    
	File.seekg(15, ios::beg); // skip 15 char file header >>planar_code<< 
	for(;;) {
		if(File.read (&c, 1)) {
			g++;
      		n = (unsigned char) c; // first char is n number of graph vertices
			graph.reserve(n); //number of graph vertices , dual faces		
      		for (int i = 0; i<n ; i++) { // cyclic adj lists for each node
            	if(File.read (&c, 1)) {
                  	v = (unsigned char) c;	
                  	e++;
					edges.push_back(v);
                 	while (v!=0) {
                 		if(File.read (&c, 1)) {
                  			v = (unsigned char) c;	
							if (v!=0) {	
            				edges.push_back(v);
            				e++;
            				}				 	
                  		}
                  		else {
            		        cout<<"read file "<<argv[2]<<" failed on:"<<" graph; "<<g<<" vertex; "<<v<<" edge; "<<e<<endl;
            		        break;
            	       }
            	    }
            	    graph.push_back(edges);
 					edges.clear();
            	}
            	else {
            		cout<<" read file failed"<<endl;
            		break;
            	}
			}
		}
		else {
				if (File.eof()){
					cout<<"end of file "<<plantri_file<<endl;
				} else {
					cout <<"check filename, "<<plantri_file<<" and file location"<<endl;
			}
			cout << "In file "<<plantri_file <<" "<<g<<" graphs were processed to find;" <<  endl;
			if ((do_simples==true)&&(do_perfects==true)&&(do_squares==true)) cout <<total_spss<< " simple perfect squared squares;"<<endl;
			if ((do_simples==true)&&(do_perfects==true)&&(do_rectangles==true)) cout <<total_spsr<< " simple perfect squared rectangles;"<<endl;
			if ((do_simples==true)&&(do_imperfects==true)&&(do_squares==true)) cout <<total_siss<< " simple imperfect squared squares;"<<endl;
			if ((do_simples==true)&&(do_imperfects==true)&&(do_rectangles==true)) cout <<total_sisr<< " simple imperfect squared rectangles;"<<endl;
			if ((do_compounds==true)&&(do_perfects==true)&&(do_squares==true)) cout <<total_cpss<< " compound perfect squared squares;"<<endl;
			if ((do_compounds==true)&&(do_perfects==true)&&(do_rectangles==true)) cout <<total_cpsr<< " compound perfect squared rectangles;"<<endl;
			if ((do_compounds==true)&&(do_imperfects==true)&&(do_squares==true)) cout <<total_ciss<< " compound imperfect squared squares;"<<endl;
			if ((do_compounds==true)&&(do_imperfects==true)&&(do_rectangles==true)) cout <<total_cisr<< " compound imperfect squared rectangles."<<endl;
			break;
		}

        f = e/2 - n + 2;
    	vector< vector< int> >::size_type uu;
		vector< int>::size_type vv;
    	e = e/2;
		ublas::matrix<double> Aa(e,n);
		ublas::matrix<double> K(n-1,n-1);
		ublas::matrix<double> V(n-1,n-1);
		ublas::matrix<double> F(e,e);
		ublas::matrix<double> T(n-1,e);
		ublas::vector<double> R(e);
		ublas::matrix<double> B(e,e);
		ublas::matrix<double> m(e,e);
		unsigned int i = 0;
		Aa.clear();//clear, then fill Aa incidence matrix with primal graph edge 1,-1 entries
    	for (unsigned int uu = 0; uu < graph.size(); uu++) { // iterate over the rows, source vertices
        	for (unsigned int vv = 0; vv < graph[uu].size(); vv++) { // iterate over edges to the target vertices
            	if (uu+1<graph[uu][vv]) { //
            		Aa(i,uu) =  1;             // edge coming from source to target, positive reference direction
            		Aa(i,graph[uu][vv]-1) = -1;// same edge going from target to source, negative reference direction
            		i++;
            	} 
        	}
    	}
    	i = 0;

		ublas::matrix_range<ublas::matrix<double> > A(Aa, ublas::range(0,e),ublas::range(1,n));
    	T = ublas::trans(A);
    	K = prod( T, A );
		double det = InvertMatrix(K , V);
		V = round(det)*V;
		m = prod( A, V );// m temp matrix
		F = prod( m, T );
        for(unsigned int i=0; i<(e); i++)
        {
        	if (round(F(i,i))!= 0){
        		R[i] = abs(gcd(round(F(i,0)),round( F(i,1))));
        	    }
        	else R[i]=1;
        	for (unsigned int j=1; j<e; j++){
        	    if (round(F(i,j))!= 0){
        	     	R[i] = abs(gcd(round(R[i]), round(F(i,j))));
        	     }
        	  }
        }

        for(unsigned int i=0; i<e; i++)
        {
        	for(unsigned int j=0; j<e; j++)
        	{
            	B(i,j) = round(F(i,j))/R[i];
            	if (abs(B(i,j))<0.0001) B(i,j) = 0.0;
        	}	    
        }
        int s2 = 0;  
        int s1 = 0;
        bool is_compound;
		bool is_square;
		bool is_perfect;
		set <string> spss; set <string> spsr; set <string> siss; set <string> sisr; set <string> cpss; set <string> cpsr; set <string> ciss; set <string> cisr;

        for(unsigned int i=0; i<e; i++)        {
            s1 = round(B(i,i));// side1 of the tiling is B(i,i);
        	s2 = round(det)/round(R[i])-s1; //side2 = determinant/reduction - side1
        	bool has_zero_edges = false; // false; no zero edges, true; has zero edges
        	if (s1 == s2 ) { 
        		is_square = true;
        	} else {
        		is_square = false;
        	}
    		list<int> Currents; 
    		for(unsigned int j=0; j<e; j++){  
    			if (B(i,j)==0){ 
    				has_zero_edges = true;
    			}
    			Currents.push_back(abs(B(i,j)));// use abs to get absolute values of currents, ignore sign
    		}
			Currents.sort();
			// sorted currents cout
			Currents.unique();
			if (Currents.size() == e) { // if all the branch currents are unique 
				is_perfect = true;                //  tiling squares are all different sizes , 'perfect'
			}
			else { 						// if some branch currents are the same
				is_perfect = false;                // some tilings squares are the same size
			}
			if (( ((is_square == true )&&(do_squares == true)) || ((is_square == false)&&(do_rectangles == true)) || ((is_perfect==true)&&(do_perfects==true)) || ((is_perfect==false)&&(do_imperfects==true)) )&&(has_zero_edges == false))
			{ 
				vector< vector<int> > GraphDual;
				vector<int> str; // edge s->t, 'str'; s source vertex, t target vertex, r index of reversal edge
				GraphDual.reserve(13); // 
				str.reserve(e);
				for (unsigned int a = 0; a< graph.size(); a++) {
					for (unsigned int b= 0; b < graph[a].size(); b++) {
		  				str.push_back(a+1); 		// 0 graph edge source vertex / bottom dual face
		  				str.push_back(graph[a][b]);	// 1 graph edge target vertex / top dual face
		  				str.push_back(0);			// 2 graph edge reversal edge 
		  				str.push_back(0);			// 3 dual edge source vertex / left graph face
						str.push_back(0);			// 4 dual edge target vertex / right graph face
		  				str.push_back(0);			// 5 dual edge cyclically adjacent edge 
		  				str.push_back(0);			// 6 graph edge branch current
		  				str.push_back(0);			// 7 dual edge branch current
		  				str.push_back(-1);			// 8 graph edge source voltage
		  				str.push_back(-1);			// 9 graph edge target voltage
		  				str.push_back(-1);			// 10 dual edge source voltage
		  				str.push_back(-1);			// 11 dual edge target voltage
		  				str.push_back(0);			// 12 graph edge cyclically adjacent edge 
		  				GraphDual.push_back(str);		
		  				str.clear();				
		  			}
				}	
				// find the reversal edge for each graph edge, and cyclically adjacent dual edge of reversal edge, and save both in GraphDual 
				for (unsigned int a = 0; a< GraphDual.size(); a++) {
					for (unsigned int b= 0; b < GraphDual.size(); b++) {
						if (a !=b) {  // all edges non-simple, dont need to test case a==b
							if ((GraphDual[a][0]==GraphDual[b][1])&&(GraphDual[a][1]==GraphDual[b][0])) { // if s==t and t==s ie it is a reversal edge
								GraphDual.at(a).at(2) = b;
							}
							if (b<GraphDual.size()-1){  //if not last item and if reversal edge has a successor in adjacency list set to successor
								if ((GraphDual[a][0]==GraphDual[b][1])&&(GraphDual[a][1]==GraphDual[b][0])&&(GraphDual[b+1][0] == GraphDual[b][0])) { 
									GraphDual.at(a).at(5) = b+1; // if not, successor is first item in adjacency list
								} else if ((GraphDual[a][0]==GraphDual[b][1])&&(GraphDual[a][1]==GraphDual[b][0])&&(GraphDual[b+1][0] != GraphDual[b][0])){ 
									GraphDual.at(a).at(5) = b - (graph[GraphDual[b][0]-1].size()-1);
								}
							} else if ((GraphDual[a][0]==GraphDual[b][1])&&(GraphDual[a][1]==GraphDual[b][0])) { // last item in  GraphDual
								 GraphDual.at(a).at(5) = b - (graph[GraphDual[b][0]-1].size()-1);
							}
						}
					}
				}	
				// find graph edge cyclically adjacent edge
				int start = 0;

				for (unsigned int a = 1; a< GraphDual.size(); a++) {
					if (GraphDual[a-1][0]==GraphDual[a][0]) { 
						GraphDual.at(a-1).at(12) = a; // 
					} else {
						GraphDual.at(a-1).at(12) = start;
						start = a;
					}
				}
				GraphDual.at(GraphDual.size()-1).at(12) = start;
				// construct  face index (dual graph vertices) and save in GraphDual
				int c=0;
				unsigned int thisedge = 0;
				for (unsigned int a = 0; a< GraphDual.size(); a++) {
					thisedge = a;
					if (GraphDual.at(thisedge).at(3) == 0) c++; 
					while (GraphDual.at(thisedge).at(3) == 0){ // iterate over the edges of the face until all have been indexed
						GraphDual.at(thisedge).at(3) = c;	//source face index is set to c
						thisedge = GraphDual.at(thisedge).at(5); //new thisedge set to the edge cyclically adjacent to thisedge
					}
				}
				for (unsigned int a = 0; a< GraphDual.size(); a++) {
					GraphDual.at(a).at(4) = GraphDual.at(GraphDual.at(a).at(2)).at(3) ; //target face set to reversal edge face
				}
				// create the dual graph 
				vector< vector<unsigned int> > dual;
				dual.reserve(f); //number of dual vertices | graph faces
				thisedge = 0;
				int t = 0;
				for (unsigned int a = 0; a < GraphDual.size(); a++) {
					if ((GraphDual.at(a).at(3)) == (t+1)) { // if the source face of the edge is equal to the index + 1 ( offset to zero based vector array )
						thisedge = a;
						do{ // 
							edges.push_back(GraphDual.at(thisedge).at(4));// 4 dual edge target face
							thisedge = GraphDual.at(thisedge).at(5); // 5 cyclically adjacent edge 
						}while ((thisedge != a));
						t++;
						dual.push_back(edges);
						edges.clear();
					}  
				}
				// perfection / imperfection test
	    		unsigned int ecount=0;
	    		unsigned int dcount=0;
	    		unsigned int edgeindx=0;
				// assign currents to edges of graph and dual, and set polar voltages
				for (uu = 0; uu < graph.size(); uu++) { // iterate over the rows, source vertices
	    			for (vv = 0; vv < graph[uu].size(); vv++) { // iterate over the target vertices
	    				if (uu+1<graph[uu][vv]) { //
						    if(i == ecount) {
								//assign currents, voltages to polar graph, dual edges and nodes
								GraphDual.at(dcount).at(6) = s1; //polar graph edge current
								GraphDual.at(GraphDual.at(dcount).at(2)).at(6) = -s1;//polar graph reversal edge current
								GraphDual.at(dcount).at(7) = s2; //polar dual edge current
								GraphDual.at(GraphDual.at(dcount).at(2)).at(7) = -s2;//polar dual reversal edge current
								GraphDual.at(dcount).at(8) = s1; //set graph polar edge current source node voltage to polar edge current value
								GraphDual.at(dcount).at(10) = s2;//set dual polar edge current target node voltage to polar edge current value
								edgeindx = dcount;//count of all edges
								} else {
								//assign currents to graph and dual edges
								GraphDual.at(dcount).at(6) = B(i,ecount);//graph edge current
								GraphDual.at(GraphDual.at(dcount).at(2)).at(6) = -B(i,ecount);//graph reversal edge current
								GraphDual.at(dcount).at(7) = -B(i,ecount);//dual edge current
								GraphDual.at(GraphDual.at(dcount).at(2)).at(7) = B(i,ecount);//dual reversal edge current
							}
	    		  			ecount++;  //count of +ve edges
	    		  		}//
	    		  		dcount++; //count of all edges
	    			}
				} 
				//Calculate graph and dual vertex voltages
				voltageG(GraphDual, edgeindx);
				voltageD(GraphDual, edgeindx);
				//display(GraphDual);
				//generate bouwkampcode given x,y coordinates  and element sizes 
 				//(equivalent to graph & dual node voltages, x[],y[] and edge currents s[j+2] respectively)
				vector<int> x;
				vector<int> y;
				vector<int> s;
				s.push_back(e-1);
				s.push_back(s1);
				s.push_back(s2);
				for (unsigned int a = 0; a< GraphDual.size(); a++) {
					if ((GraphDual.at(a).at(6)>0)&&(a!=edgeindx)){
						x.push_back(GraphDual.at(a).at(8));
						y.push_back(GraphDual.at(a).at(10));
						s.push_back(GraphDual.at(a).at(6));
					}
				}
				s.at(0) = s.size()-3;
				for (unsigned int a = 0; a < GraphDual.size(); a++) {
					GraphDual.at(a).at(8)= -1;
					GraphDual.at(a).at(9)= -1;
				 	GraphDual.at(a).at(10)= -1;
					GraphDual.at(a).at(11)= -1;
				}
				std::vector<int> Top ;
				std::vector<int> Bottom ;
				std::vector<int> Left;
				std::vector<int> Right ;
				std::vector<int> Size ;
				Top.reserve(s.size()+1) ;
				Bottom.reserve(s.size()+1) ;
				Left.reserve(s.size()+1);
				Right.reserve(s.size()+1) ;
				Size.reserve(s.size()+1) ;
				//create Top, Left, Right, Bottom (x,y) coordinate vectors and Size vector
				for (unsigned int j = 0; j <  s.size()-3; j++){	
					Right.push_back(x[j]);
					Left.push_back(x[j] - s[j+3]);
					Top.push_back(y[j]);
					Bottom.push_back(y[j] + s[j+3]);
					Size.push_back(s[j+3]);
				}

				is_compound = simple_compound_test(s.at(0), s1, s2, Size, Top, Left, Right, Bottom);
				if (((is_compound == true)&&(do_compounds == false))||((is_compound == false)&&(do_simples == false))) {continue;}
				//copy element position vectors
				std::vector<int> sortedTop(Top); //copy Top vector to sortedTop vector using constructor
				std::vector<int> sortedLeft(Left);// "      Left     "      "  sortedLeft  "          "           "
				std::vector<int> sortedRight(Right); //    copy Right vector to sortedRight vector using constructor
				std::vector<int> sortedBottom(Bottom);// "      Bottom "      "  sortedBottom  "          "           "		
				//sort copied element position vectors
				std::sort(sortedTop.begin(), sortedTop.end()); // sort sortedTop vector in ascending order
				std::sort(sortedLeft.begin(), sortedLeft.end());//   "    sortedLeft   "       "      "               "
				std::sort(sortedRight.begin(), sortedRight.end()); //       sort sortedRight vector in ascending order
				std::sort(sortedBottom.begin(), sortedBottom.end());//   "    sortedBottom   "       "      "               "			
				//eliminate duplicate values to get unique sorted element position vectors
				sortedTop.erase( std::unique( sortedTop.begin(),sortedTop.end() ), sortedTop.end() ); // unique sortedTop vector in ascending order
				sortedLeft.erase( std::unique( sortedLeft.begin(),sortedLeft.end() ), sortedLeft.end() );//   "         sortedLeft   "       "      "               "			
				sortedRight.erase( std::unique( sortedRight.begin(),sortedRight.end() ), sortedRight.end() ); //                unique sortedTop vector in ascending order
				sortedBottom.erase( std::unique( sortedBottom.begin(),sortedBottom.end() ), sortedBottom.end() );//       "       sortedBottom   "   "      "               "		
				std::vector<int> compBkcode; 
				std::vector<std::vector<int> > bkCodes;

				compBkcode.push_back(s.at(0));  
				compBkcode.push_back(s.at(1));
				compBkcode.push_back(s.at(2));  

				for (unsigned int p=0; p < sortedTop.size(); p++){
					for (unsigned int q=0; q < sortedLeft.size(); q++){
						for (unsigned int r=0; r < Size.size(); r++){
							if((sortedTop.at(p)==Top.at(r))&&(sortedLeft.at(q)==Left.at(r))){
								compBkcode.push_back(Size.at(r));
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();

				//2. create bouwkampcode Top Right -> Bottom Left;  Top down
				compBkcode.push_back(s.at(0));  // Order of squared square
				compBkcode.push_back(s.at(1));  // Width  "      "             "
				compBkcode.push_back(s.at(2));  // Height "     "             "
				for (unsigned int p=0; p < sortedTop.size(); p++){
					for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
						for (unsigned int r=0; r < Size.size(); r++){
							if((sortedTop.at(p)==Top.at(r))&&(*qit==Right.at(r))){
								compBkcode.push_back(Size.at(r));
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();

		 		//3. create bouwkampcode Bottom Right -> Top Left ; Bottom up
				compBkcode.push_back(s.at(0));  // Order of squared square
				compBkcode.push_back(s.at(1));  // Width  "      "             "
				compBkcode.push_back(s.at(2));  // Height "     "             "
				for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
					for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
						for (unsigned int r=0; r < Size.size(); r++){
							if((*pit==Bottom.at(r))&&(*qit==Right.at(r))){
								compBkcode.push_back(Size.at(r));
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
				//4. create bouwkampcode Bottom Left -> Top Right ; Bottom up
				compBkcode.push_back(s.at(0));  // Order of squared square
				compBkcode.push_back(s.at(1));  // Width  "      "             "
				compBkcode.push_back(s.at(2));  // Height "     "             "
				for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
					for (unsigned int q=0; q < sortedLeft.size(); q++){
						for (unsigned int r=0; r < Size.size(); r++){
							if((*pit==Bottom.at(r))&&(sortedLeft.at(q)==Left.at(r))){
								compBkcode.push_back(Size.at(r));
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
		 		//5. create bouwkampcode Top Left -> Bottom Right ; Left across
				compBkcode.push_back(s.at(0));  // Order of squared square
				compBkcode.push_back(s.at(2));  // Width  "      "             "
				compBkcode.push_back(s.at(1));  // Height "     "             "
				for (unsigned int q=0; q < sortedLeft.size(); q++){
					for (unsigned int p=0; p < sortedTop.size(); p++){
						for (unsigned int r=0; r < Size.size(); r++){
							if((sortedTop.at(p)==Top.at(r))&&(sortedLeft.at(q)==Left.at(r))){
								compBkcode.push_back(Size.at(r));
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
		 		//6. create bouwkampcode Top Right -> Bottom Left ; Right across
				compBkcode.push_back(s.at(0));  // Order of squared square
				compBkcode.push_back(s.at(2));  // Width  "      "             "
				compBkcode.push_back(s.at(1));  // Height "     "             "
				for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
					for (unsigned int p=0; p < sortedTop.size(); p++){
						for (unsigned int r=0; r < Size.size(); r++){
							if((sortedTop.at(p)==Top.at(r))&&(*qit==Right.at(r))){
								compBkcode.push_back(Size.at(r));
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
		 		//7. create bouwkampcode Bottom Right -> Top Left ; Right across
				compBkcode.push_back(s.at(0));  // Order of squared square
				compBkcode.push_back(s.at(2));  // Width  "      "             "
				compBkcode.push_back(s.at(1));  // Height "     "             "
				for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
					for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
						for (unsigned int r=0; r < Size.size(); r++){
							if((*pit==Bottom.at(r))&&(*qit==Right.at(r))){
								compBkcode.push_back(Size.at(r));
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
		 		//8. create bouwkampcode Bottom Left -> Top Right ; Left across
				compBkcode.push_back(s.at(0));  // Order of squared square
				compBkcode.push_back(s.at(2));  // Width  "      "             "
				compBkcode.push_back(s.at(1));  // Height "     "             "
				for (unsigned int q=0; q < sortedLeft.size(); q++){
					for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
						for (unsigned int r=0; r < Size.size(); r++){
							if((*pit==Bottom.at(r))&&(sortedLeft.at(q)==Left.at(r))){
								compBkcode.push_back(Size.at(r));
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
				
				//canonical bouwkampcode string method

				stringstream ss;
				int wordsize;
				vector<string> bkrowstring;
				if ((s[1] > s[2] )||(s[1] == s[2])) {
					wordsize = ceil(log10(s[1]));
					if (ceil(log10(s[1]))== log10(s[1])) wordsize++;
				} else {
					wordsize = ceil(log10(s[2]));
					if (ceil(log10(s[2]))== log10(s[2])) wordsize++;
				}

				
				//cout<<wordsize<<endl;
				unsigned int l = Size.size()+3; //l is bouwkampcode length
				//unsigned int ssize = l*wordsize;
				for (unsigned int p = 0; p < 8 ; p++) {
					for (unsigned int q = 0; q < l ; q++) {
						ss << setw(wordsize) << setfill('0')<<bkCodes[p][q];
					}
					bkrowstring.push_back(ss.str());
					ss.str("");
					ss.clear();
				}
				//for (unsigned int p = 0; p < 8 ; p++) {
				//	for (unsigned int q = 0; q < 8 ; q++) {
				//		if (q<p) {
				//			if (std::lexicographical_compare(bkrowstring.at(q).c_str(),bkrowstring.at(q).c_str()+ssize,bkrowstring.at(p).c_str(),bkrowstring.at(p).c_str()+ssize)) {
				//			//std::cout << bkrowstring.at(p) << " is greater than " << bkrowstring.at(q) << std::endl;
				//				compsum.at(p) = compsum.at(p)++;
				//			} else { compsum.at(q) = compsum.at(q)++; }
				//		}
				//	}
				//}
				//row qq with the largest sum is the canonical row
				std::vector<std::string>::iterator result = std::max_element(bkrowstring.begin(), bkrowstring.end());
				int qq = std::distance(bkrowstring.begin(), result) ;
				//compsum.clear();
				bkrowstring.clear();
				
				//cout<<"write canonical code"<<endl;
				std::ostringstream bk;
				for (unsigned int j=0; j < Size.size()+3; j++){
					bk<<bkCodes[qq][j]<<" ";
					//cout<<bkCodes[qq][j]<<" ";
				}
				//cout<<endl;
				bk<<endl;
				
				if ((is_compound==false)&&(do_simples==true)&&(is_perfect==true)&&(do_perfects==true)&&(is_square==true)&&(do_squares==true)) {
					spss.insert(bk.str()); 
				}
				if ((is_compound==false)&&(do_simples==true)&&(is_perfect==true)&&(do_perfects==true)&&(is_square==false)&&(do_rectangles==true)) {
					spsr.insert(bk.str()); 
				}
				if ((is_compound==false)&&(do_simples==true)&&(is_perfect==false)&&(do_imperfects==true)&&(is_square==true)&&(do_squares==true)) {
					siss.insert(bk.str()); 
				}
				if ((is_compound==false)&&(do_simples==true)&&(is_perfect==false)&&(do_imperfects==true)&&(is_square==false)&&(do_rectangles==true)) {
					sisr.insert(bk.str());
				}
				if ((is_compound==true)&&(do_compounds==true)&&(is_perfect==true)&&(do_perfects==true)&&(is_square==true)&&(do_squares==true)) {
					cpss.insert(bk.str());
				}
				if ((is_compound==true)&&(do_compounds==true)&&(is_perfect==true)&&(do_perfects==true)&&(is_square==false)&&(do_rectangles==true)) {
					cpsr.insert(bk.str());
				}
				if ((is_compound==true)&&(do_compounds==true)&&(is_perfect==false)&&(do_imperfects==true)&&(is_square==true)&&(do_squares==true)) {
					ciss.insert(bk.str());
				}
				if ((is_compound==true  )&&(do_compounds==true)&&(is_perfect==false)&&(do_imperfects==true)&&(is_square==false)&&(do_rectangles==true)) {
					cisr.insert(bk.str());
				}
				bk.str("");
				bk.clear();
				bkCodes.clear();
				compBkcode.clear();
				x.clear();
				y.clear();
				s.clear();
				Top.clear() ;
				Bottom.clear() ;
				Left.clear();
				Right.clear() ;
				Size.clear() ;
				//Boundary.clear() ;
				sortedTop.clear() ;
				sortedBottom.clear() ;
				sortedLeft.clear();
				sortedRight.clear() ;	
				GraphDual.clear();
				dual.clear();
				Currents.clear();
			}//square/rectangle perfect/imperfect zero edges or not
        }//iterate over all solutions
        //output unique solutions
		std::ostringstream ous;
		std::ofstream bkcanon_file;	// create ofstream  tiling bouwkampcode output file
		set<string>::iterator itspss;
		if ((do_simples==true)&&(do_perfects==true)&&(do_squares==true)&&(!spss.empty())) {
			ous <<plantri_file<<"-"<<"spss.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itspss=spss.begin(); itspss!=spss.end(); itspss++) {
				bkcanon_file<< *itspss;
				total_spss++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		spss.clear();
		set<string>::iterator itspsr;
		if ((do_simples==true)&&(do_perfects==true)&&(do_rectangles==true)&&(!spsr.empty())) {
			ous <<plantri_file<<"-"<<"spsr.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itspsr=spsr.begin(); itspsr!=spsr.end(); itspsr++) {
				bkcanon_file<< *itspsr;
				total_spsr++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		spsr.clear();
		set<string>::iterator itsiss;
		if ((do_simples==true)&&(do_imperfects==true)&&(do_squares==true)&&(!siss.empty())) {
			ous <<plantri_file<<"-"<<"siss.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itsiss=siss.begin(); itsiss!=siss.end(); itsiss++) {
				bkcanon_file<< *itsiss;
				total_siss++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		siss.clear();
		set<string>::iterator itsisr;
		if ((do_simples==true)&&(do_imperfects==true)&&(do_rectangles==true)&&(!sisr.empty())) {
			ous <<plantri_file<<"-"<<"sisr.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itsisr=sisr.begin(); itsisr!=sisr.end(); itsisr++) {
				bkcanon_file<< *itsisr;
				total_sisr++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		sisr.clear();
		set<string>::iterator itcpss;
		if ((do_compounds==true)&&(do_perfects==true)&&(do_squares==true)&&(!cpss.empty())) {
			ous <<plantri_file<<"-"<<"cpss.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itcpss=cpss.begin(); itcpss!=cpss.end(); itcpss++) {
				bkcanon_file<< *itcpss;
				total_cpss++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		cpss.clear();
		set<string>::iterator itcpsr;
		if ((do_compounds==true)&&(do_perfects==true)&&(do_rectangles==true)&&(!cpsr.empty())) {
			ous <<plantri_file<<"-"<<"cpsr.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itcpsr=cpsr.begin(); itcpsr!=cpsr.end(); itcpsr++) {
				bkcanon_file<< *itcpsr;
				total_cpsr++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		cpsr.clear();
		set<string>::iterator itciss;
		if ((do_compounds==true)&&(do_imperfects==true)&&(do_squares==true)&&(!ciss.empty())) {
			ous <<plantri_file<<"-"<<"ciss.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itciss=ciss.begin(); itciss!=ciss.end(); itciss++) {
				bkcanon_file<< *itciss;
				total_ciss++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		ciss.clear();
		set<string>::iterator itcisr;
		if ((do_compounds==true)&&(do_imperfects==true)&&(do_rectangles==true)&&(!cisr.empty())) {
			ous <<plantri_file<<"-"<<"cisr.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itcisr=cisr.begin(); itcisr!=cisr.end(); itcisr++) {
				bkcanon_file<< *itcisr;
				total_cisr++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		cisr.clear();
		//clear objects
		graph.clear();
    	edges.clear();
		Aa.clear();
		K.clear();
		V.clear();	
		F.clear();
		T.clear();
		R.clear();
		B.clear();
		m.clear();  
		e = 0;  	
	}
    duration = ( std::clock() - start ) / (double) CLOCKS_PER_SEC;
    std::cout<<"processing took "<< duration <<" seconds."<<'\n';
  	return 0;
}
