#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <iomanip>
#include <vector>
#include <algorithm>
#include <cmath>
#include <iterator>
#include <cstring>
#include <cstdlib>
#include <list>
#include <exception>
#include <boost/numeric/ublas/lu.hpp>
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/matrix_proxy.hpp>
#include <boost/numeric/ublas/triangular.hpp>
#include <boost/numeric/ublas/io.hpp>
#include <boost/progress.hpp>
#include <limits.h>
#include <sys/time.h>
double get_time(){
    struct timeval t;
    gettimeofday(&t, NULL);
    double time = t.tv_sec + (double) t.tv_usec/1000000;
    return time;
}

// Stuart Anderson stuart.errol.anderson@gmail.com, http://www.squaring.net
// May 12th 2013
// sqfree ( squared square / square free finder ) , finds candidates for siss spss cpss ciss (simple and compound, perfect and imperfect are not distinguished by this software)
// by testing the determinant of the Kirchhoff (discrete Laplacian matrix) to check if it can be factored as 2mk^2, where m and k are integers and m is a square-free number.
// Such a factoring is a necessary but not sufficient condition for a 2 or 3 connected graph to produce a squared square.
// input is a plantri filename which must be present in the same folder
// candidate graphs are saved with x_prefix as plantri files with 15 char x header (order = no. graph edges - 1)

namespace ublas = boost::numeric::ublas;
using namespace std;
using boost::timer;

#ifndef INVERT_MATRIX_HPP
#define INVERT_MATRIX_HPP

/* Matrix inversion routine.
	Uses lu_factorize and lu_substitute in uBLAS to invert a matrix and return a determinant */
template<class T>
double InvertMatrix (const ublas::matrix<T>& input, ublas::matrix<T>& inverse) {
	using namespace boost::numeric::ublas;
	typedef permutation_matrix<std::size_t> pmatrix;
	// create a working copy of the input
	matrix<T> M(input);
	// create a permutation matrix for the LU-factorization
	pmatrix pm(M.size1());
	// perform LU-factorization
	int res = lu_factorize(M,pm);
	if( res != 0 ) return 0;
	//0 determinant the matrix is not invertible
	double product = 1;
	std::vector<int> vec;
	for(unsigned int j = 0; j<M.size1(); j++)
	{
		product = product * M(j,j);
		if ((M(j,j)-abs(M(j,j)))<0.00000001) vec.push_back(M(j,j));
	}
	std::sort(vec.begin(), vec.end());
	// create identity matrix of "inverse"
	inverse.assign(ublas::identity_matrix<T>(M.size1()));
	// backsubstitute to get the inverse
	lu_substitute(M, pm, inverse);
	return product;
 }

 #endif //INVERT_MATRIX_HPP
 
//values taken from http://oeis.org/A005117 A005117 Squarefree numbers: numbers that are not divisible by a square greater than 1. 
 
int sqfree[] ={1,2,3,5,6,7,10,11,13,14,15,17,19,21,22,23,26,29,30,31,33,34,35,37,38,39,41,42,43,46,47,51,53,55,57,58,59,61,62,65,66,67,69,70,71,73,74,77,78,79,82,83,85,86,87,
89,91,93,94,95,97,101,102,103,105,106,107,109,110,111,113,114,115,118,119,122,123,127,129,130,131,133,134,137,138,139,141,142,143,145,146,149,151,154,155,157,158,159,
161,163,165,166,167,170,173,174,177,178,179,181,182,183,185,186,187,190,191,193,194,195,197,199,201,202,203,205,206,209,210,211,213,214,215,217,218,219,221,222,223,226,
227,229,230,231,233,235,237,238,239,241,246,247,249,251,253,254,255,257,258,259,262,263,265,266,267,269,271,273,274,277,278,281,282,283,285,286,287,290,291,293,295,298,
299,301,302,303,305,307,309,310,311,313,314,317,318,319,321,322,323,326,327,329,330,331,334,335,337,339,341,345,346,347,349,353,354,355,357,358,359,362,365,366,367,370,
371,373,374,377,379,381,382,383,385,386,389,390,391,393,394,395,397,398,399,401,402,403,406,407,409,410,411,413,415,417,418,419,421,422,426,427,429,430,431,433,434,435,
437,438,439,442,443,445,446,447,449,451,453,454,455,457,458,461,462,463,465,466,467,469,470,471,473,474,478,479,481,482,483,485,487,489,491,493,494,497,498,499,501,502,
503,505,506,509,510,511,514,515,517,518,519,521,523,526,527,530,533,534,535,537,538,541,542,543,545,546,547,551,553,554,555,557,559,561,562,563,565,566,569,570,571,573,
574,577,579,581,582,583,586,587,589,590,591,593,595,597,598,599,601,602,606,607,609,610,611,613,614,615,617,618,619,622,623,626,627,629,631,633,634,635,638,641,642,643,
645,646,647,649,651,653,654,655,658,659,661,662,663,665,667,669,670,671,673,674,677,678,679,681,682,683,685,687,689,690,691,694,695,697,698,699,701};//429 values

//code lines 91 - 224 taken from http://stackoverflow.com/questions/295579/fastest-way-to-determine-if-an-integers-square-root-is-an-integer by A.Rex

typedef signed long long int int64;

int start[1024] =
{1,3,1769,5,1937,1741,7,1451,479,157,9,91,945,659,1817,11,
1983,707,1321,1211,1071,13,1479,405,415,1501,1609,741,15,339,1703,203,
129,1411,873,1669,17,1715,1145,1835,351,1251,887,1573,975,19,1127,395,
1855,1981,425,453,1105,653,327,21,287,93,713,1691,1935,301,551,587,
257,1277,23,763,1903,1075,1799,1877,223,1437,1783,859,1201,621,25,779,
1727,573,471,1979,815,1293,825,363,159,1315,183,27,241,941,601,971,
385,131,919,901,273,435,647,1493,95,29,1417,805,719,1261,1177,1163,
1599,835,1367,315,1361,1933,1977,747,31,1373,1079,1637,1679,1581,1753,1355,
513,1539,1815,1531,1647,205,505,1109,33,1379,521,1627,1457,1901,1767,1547,
1471,1853,1833,1349,559,1523,967,1131,97,35,1975,795,497,1875,1191,1739,
641,1149,1385,133,529,845,1657,725,161,1309,375,37,463,1555,615,1931,
1343,445,937,1083,1617,883,185,1515,225,1443,1225,869,1423,1235,39,1973,
769,259,489,1797,1391,1485,1287,341,289,99,1271,1701,1713,915,537,1781,
1215,963,41,581,303,243,1337,1899,353,1245,329,1563,753,595,1113,1589,
897,1667,407,635,785,1971,135,43,417,1507,1929,731,207,275,1689,1397,
1087,1725,855,1851,1873,397,1607,1813,481,163,567,101,1167,45,1831,1205,
1025,1021,1303,1029,1135,1331,1017,427,545,1181,1033,933,1969,365,1255,1013,
959,317,1751,187,47,1037,455,1429,609,1571,1463,1765,1009,685,679,821,
1153,387,1897,1403,1041,691,1927,811,673,227,137,1499,49,1005,103,629,
831,1091,1449,1477,1967,1677,697,1045,737,1117,1737,667,911,1325,473,437,
1281,1795,1001,261,879,51,775,1195,801,1635,759,165,1871,1645,1049,245,
703,1597,553,955,209,1779,1849,661,865,291,841,997,1265,1965,1625,53,
1409,893,105,1925,1297,589,377,1579,929,1053,1655,1829,305,1811,1895,139,
575,189,343,709,1711,1139,1095,277,993,1699,55,1435,655,1491,1319,331,
1537,515,791,507,623,1229,1529,1963,1057,355,1545,603,1615,1171,743,523,
447,1219,1239,1723,465,499,57,107,1121,989,951,229,1521,851,167,715,
1665,1923,1687,1157,1553,1869,1415,1749,1185,1763,649,1061,561,531,409,907,
319,1469,1961,59,1455,141,1209,491,1249,419,1847,1893,399,211,985,1099,
1793,765,1513,1275,367,1587,263,1365,1313,925,247,1371,1359,109,1561,1291,
191,61,1065,1605,721,781,1735,875,1377,1827,1353,539,1777,429,1959,1483,
1921,643,617,389,1809,947,889,981,1441,483,1143,293,817,749,1383,1675,
63,1347,169,827,1199,1421,583,1259,1505,861,457,1125,143,1069,807,1867,
2047,2045,279,2043,111,307,2041,597,1569,1891,2039,1957,1103,1389,231,2037,
65,1341,727,837,977,2035,569,1643,1633,547,439,1307,2033,1709,345,1845,
1919,637,1175,379,2031,333,903,213,1697,797,1161,475,1073,2029,921,1653,
193,67,1623,1595,943,1395,1721,2027,1761,1955,1335,357,113,1747,1497,1461,
1791,771,2025,1285,145,973,249,171,1825,611,265,1189,847,1427,2023,1269,
321,1475,1577,69,1233,755,1223,1685,1889,733,1865,2021,1807,1107,1447,1077,
1663,1917,1129,1147,1775,1613,1401,555,1953,2019,631,1243,1329,787,871,885,
449,1213,681,1733,687,115,71,1301,2017,675,969,411,369,467,295,693,
1535,509,233,517,401,1843,1543,939,2015,669,1527,421,591,147,281,501,
577,195,215,699,1489,525,1081,917,1951,2013,73,1253,1551,173,857,309,
1407,899,663,1915,1519,1203,391,1323,1887,739,1673,2011,1585,493,1433,117,
705,1603,1111,965,431,1165,1863,533,1823,605,823,1179,625,813,2009,75,
1279,1789,1559,251,657,563,761,1707,1759,1949,777,347,335,1133,1511,267,
833,1085,2007,1467,1745,1805,711,149,1695,803,1719,485,1295,1453,935,459,
1151,381,1641,1413,1263,77,1913,2005,1631,541,119,1317,1841,1773,359,651,
961,323,1193,197,175,1651,441,235,1567,1885,1481,1947,881,2003,217,843,
1023,1027,745,1019,913,717,1031,1621,1503,867,1015,1115,79,1683,793,1035,
1089,1731,297,1861,2001,1011,1593,619,1439,477,585,283,1039,1363,1369,1227,
895,1661,151,645,1007,1357,121,1237,1375,1821,1911,549,1999,1043,1945,1419,
1217,957,599,571,81,371,1351,1003,1311,931,311,1381,1137,723,1575,1611,
767,253,1047,1787,1169,1997,1273,853,1247,413,1289,1883,177,403,999,1803,
1345,451,1495,1093,1839,269,199,1387,1183,1757,1207,1051,783,83,423,1995,
639,1155,1943,123,751,1459,1671,469,1119,995,393,219,1743,237,153,1909,
1473,1859,1705,1339,337,909,953,1771,1055,349,1993,613,1393,557,729,1717,
511,1533,1257,1541,1425,819,519,85,991,1693,503,1445,433,877,1305,1525,
1601,829,809,325,1583,1549,1991,1941,927,1059,1097,1819,527,1197,1881,1333,
383,125,361,891,495,179,633,299,863,285,1399,987,1487,1517,1639,1141,
1729,579,87,1989,593,1907,839,1557,799,1629,201,155,1649,1837,1063,949,
255,1283,535,773,1681,461,1785,683,735,1123,1801,677,689,1939,487,757,
1857,1987,983,443,1327,1267,313,1173,671,221,695,1509,271,1619,89,565,
127,1405,1431,1659,239,1101,1159,1067,607,1565,905,1755,1231,1299,665,373,
1985,701,1879,1221,849,627,1465,789,543,1187,1591,923,1905,979,1241,181};

bool bad255[512] =
{0,0,1,1,0,1,1,1,1,0,1,1,1,1,1,0,0,1,1,0,1,0,1,1,1,0,1,1,1,1,0,1,
 1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,0,1,1,1,1,0,1,1,1,
 0,1,0,1,1,0,0,1,1,1,1,1,0,1,1,1,1,0,1,1,0,0,1,1,1,1,1,1,1,1,0,1,
 1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,1,1,1,0,1,1,1,1,0,0,1,1,1,1,1,1,
 1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,1,1,0,1,1,1,1,1,
 1,1,1,1,1,1,0,1,1,0,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1,
 1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,
 1,0,1,1,1,0,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,
 0,0,1,1,0,1,1,1,1,0,1,1,1,1,1,0,0,1,1,0,1,0,1,1,1,0,1,1,1,1,0,1,
 1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,0,1,1,1,1,0,1,1,1,
 0,1,0,1,1,0,0,1,1,1,1,1,0,1,1,1,1,0,1,1,0,0,1,1,1,1,1,1,1,1,0,1,
 1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,0,1,1,1,0,1,1,1,1,0,0,1,1,1,1,1,1,
 1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,1,1,0,1,1,1,1,1,
 1,1,1,1,1,1,0,1,1,0,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1,
 1,1,1,0,0,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,
 1,0,1,1,1,0,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,1,1,1,
 0,0};

inline bool is_square( int64 x ) {
    // Quickfail
    if( x < 0 || (x&2) || ((x & 7) == 5) || ((x & 11) == 8) )
        return false;
    if( x == 0 )
        return true;

    // Check mod 255 = 3 * 5 * 17, for fun
    int64 y = x;
    y = (y & 4294967295LL) + (y >> 32);
    y = (y & 65535) + (y >> 16);
    y = (y & 255) + ((y >> 8) & 255) + (y >> 16);
    if( bad255[y] )
        return false;

    // Divide out powers of 4 using binary search
    if((x & 4294967295LL) == 0)
        x >>= 32;
    if((x & 65535) == 0)
        x >>= 16;
    if((x & 255) == 0)
        x >>= 8;
    if((x & 15) == 0)
        x >>= 4;
    if((x & 3) == 0)
        x >>= 2;

    if((x & 7) != 1)
        return false;

    // Compute sqrt using something like Hensel's lemma
    int64 r, t, z;
    r = start[(x >> 3) & 1023];
    do {
        z = x - r * r;
        if( z == 0 )
            return true;
        if( z < 0 )
            return false;
        t = z & (-z);
        r += (z & t) >> 1;
        if( r > (t  >> 1) )
            r = t - r;
    } while( t <= (1LL << 33) );

    return false;
}

int main (int argc, char* argv[]){
	if(argc==1) {
		cout<<"	"<<argv[0]<<" extracts candidate graphs of squared squares"<<endl;
		cout<<"	from plantri graphs and saves them as a plantri file with an x_ prefix."<<endl;
		cout<<"	My sqfind and sqt programs are also needed to reject candidates "<<endl;
		cout<<"	that dont work and to produce Bouwkampcode from the graphs which do produce squared squares."<<endl;
		cout<<"	sqfree, finds candidates for squared squares, by testing the determinant of the Kirchhoff (discrete Laplacian) matrix to check "<<endl;
		cout<<"	if it can be factored as 2mk^2, where m and k are integers and m is a square-free number."<<endl;
		cout<<"	Such a factoring is a necessary but not sufficient condition for a 2 or 3-connected graph to produce a squared square."<<endl;
		cout<<"	A plantri binary file is required for input"<<endl;
		cout<<"	Only plantri files produced with the e switch (all have same number of edges) are suitable for processing;"<<endl;
		cout<<"	use the plantri -e switch with a particular edge value, not an edge range "<<endl;
		cout<<"	plantri is available from http://cs.anu.edu.au/~bdm/plantri/"<<endl;
		cout<<"	The program "<<argv[0]<<" is by Stuart Errol Anderson."<<endl;
		cout<<"	stuart.errol.anderson@gmail.com, "<<endl;
		cout<<"	the latest version of "<<argv[0]<<" is available from http://www.squaring.net/downloads"<<endl;
		exit(0);
	}
	double time_start = get_time();
	string pla_input_file;
	string outputfilename;
	string noddy_input_file(argv[1]);
	ifstream  File(noddy_input_file.c_str(), ios::in | ios::binary);     
	outputfilename = "x_";
	outputfilename.append(argv[1]);	//Concatenates  Same as outputfilename += argv[1];
	ofstream plantriOutFile(outputfilename.c_str(), ios::out | ios::ate  | ios::binary );
	std::ofstream det_file;	// create ofstream
	if (!File) { // check it opened ok
		std::cerr << "Cannot open file "<< argv[1]<< " \n"; 
	}
	if (!plantriOutFile) { // check it opened ok
		std::cerr << "Cannot open file "<<outputfilename.c_str()<< " \n"; 
	}
	timer  t1;
	ofstream noddy_file;
	cout<<"processing plantri file "<<argv[1]<<" for squared square candidate graphs..."<<endl;
	int n=0; int v=0; int g =0 ;int gcount = 0; unsigned int e = 0; int d=0;
	bool start = true;
	bool gsave = false;
	char c; 
	ublas::matrix<double> K;
	//read plantri graph and create row and column reduced Kirchhoff matrix K from it
	File.seekg(15, ios::beg); // skip 15 char file header >>planar_code<<
	for(;;) {
		if(File.read (&c, 1)) {
			g++;
			n = (unsigned char) c; // first char is n number of graph vertices
			K.resize(n-1,n-1);
			d = 0;
			for (int i = 0; i<n ; i++) { // cyclic adj lists for each node
				if(File.read (&c, 1)) {
					v = (unsigned char) c;
					d++;
					if ((i!=n-1)&&(v-1!=n-1)) { 
						K(i,v-1) = -1;
					}
					while (v!=0) {
						if(File.read (&c, 1)) {
							v = (unsigned char) c;	
							if (v!=0) {	
								if ((i!=n-1)&&(v-1!=n-1)) { 
									K(i,v-1) = -1;
								 }
							d++;
							}
						}
						else {
							cout<<"read file failed"<<endl;
						break;
						}
					}
					e += d;
					if (i!=n-1) {
						K(i,i) = d; 
					}
					d = 0;
				}
				else {
					cout<<" read file failed"<<endl;
					break;
				}
			}
		}
		else {
			if (File.eof()){
				cout <<"end of file "<<argv[1]<<endl;
			} else {
				cout <<"check filename, "<<argv[1]<<" and file location"<<endl;
			}
 			double time_end = get_time();
			cout << "graphs processed = " << g << ";" << endl;
			if (gcount >0) {
				cout <<gcount<<" graphs saved to plantri file " << outputfilename  <<  endl;
			}
			else { 
				cout <<"no squared square graphs found, nothing to save  "  <<  endl;
			}
			std::cout<<"This program has run for: "<< time_end - time_start<< " seconds."<<std::endl;
			plantriOutFile.close();
			File.close();
			break;
		}
		ublas::matrix<double> V(n-1,n-1);
		double det = InvertMatrix(K , V);
		long det_long = static_cast<long>(det+0.5);
		if (det_long % 2 == 0) {
			long det2 = det_long/2;
			for (int s=0; s < 429 ; s++ ) {
				if ((det2 % sqfree[s] == 0)&&(is_square(det2/sqfree[s]))) { //if determinant/2 is divisible by a squarefree number and the divided number is a perfect square number, 
					gsave = true;											//then it's a squared square candidate.
					break;
				}
			}
		} else { gsave = false ; }
		if (gsave == true){ //save the graph if it produces squared square(s)
			vector<int> pcode;//
			vector<int>::iterator the_iterator;
			char x;
			long int q = -(1+e+n);//number of bytes from the file pointer to the start of the graph
			File.clear();
			File.seekg(q, ios::cur);//move the file pointer from it's current position back to the starting byte of the graph
			for ( int ii = 0; ii<-q ; ii++){ //read plantri code of the graph to a vector
				if(File.read (&x,  1)){
					v = (unsigned char) x;
					pcode.push_back(v);
				}else {
					cout <<"read file failed"<<endl;
					break;
				}
			}
			if (start == true) {
				plantriOutFile.seekp(0, ios::beg);//
				x = 'x'; // write pseudo 15 char plantri file header with 15 'x' chars, dont use plantri code header so my files are distinguishable from those produced by plantri
				for ( int j = 0; j<15;j++) { 
					plantriOutFile.write((char*)&x, 1);
				}
				start = false;
			}
			cout<<"copy graph number "<<g<<" from "<<noddy_input_file<<" to "<<outputfilename<<endl;
			the_iterator = pcode.begin();//iterate over pcode vector to ofstream to save the graph to the output file;
			while( the_iterator != pcode.end() ){
				unsigned int i = *the_iterator;
				plantriOutFile.write((char*)&i,  1);
				++the_iterator;
			}
			gcount++;
			pcode.clear();	
			gsave = false;
		}
		//clear objects
		K.clear();
		V.clear();
		e = 0;  	
	}
	det_file.close();
	return 0;
}
