#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <iomanip>
#include <vector>
#include <algorithm>
#include <cmath>
#include <iterator>
#include <cstring>
#include <cstdlib>
#include <list>
#include <exception>
#include <boost/numeric/ublas/lu.hpp>
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/matrix_proxy.hpp>
#include <boost/numeric/ublas/triangular.hpp>
#include <boost/numeric/ublas/io.hpp>
#include <boost/progress.hpp>
#include <limits.h>
#include <sys/time.h>
double get_time(){
    struct timeval t;
    gettimeofday(&t, NULL);
    double d = t.tv_sec + (double) t.tv_usec/1000000;
    return d;
}

// Stuart Anderson stuart.errol.anderson@gmail.com
// August 18th 2012
// sqfind ( squared square / quilt finder ) , finds  siss spss cpss ciss (simple and compound are not distinguished by this software)
// input is a plantri filename which must be present in the same folder
// quilts / squared squares without zero edges are saved with x_prefix as plantri files with 15 char x header (order = no. graph edges - 1)

namespace ublas = boost::numeric::ublas;
using namespace std;
using boost::timer;

int gcd(int n,int m){return m==0?n:gcd(m,n%m);}

#ifndef INVERT_MATRIX_HPP
#define INVERT_MATRIX_HPP

/* Matrix inversion routine.
	Uses lu_factorize and lu_substitute in uBLAS to invert a matrix and return a determinant */
template<class T>
double InvertMatrix (const ublas::matrix<T>& input, ublas::matrix<T>& inverse) {
	using namespace boost::numeric::ublas;
	typedef permutation_matrix<std::size_t> pmatrix;
	// create a working copy of the input
	matrix<T> M(input);
	// create a permutation matrix for the LU-factorization
	pmatrix pm(M.size1());
	// perform LU-factorization
	int res = lu_factorize(M,pm);
	if( res != 0 ) return 0;
	//0 determinant the matrix is not invertible
	double product = 1;
	std::vector<int> vec;
	for(unsigned int j = 0; j<M.size1(); j++)
	{
		product = product * M(j,j);
		if ((M(j,j)-abs(M(j,j)))<0.00000001) vec.push_back(M(j,j));
	}
	std::sort(vec.begin(), vec.end());
	// create identity matrix of "inverse"
	inverse.assign(ublas::identity_matrix<T>(M.size1()));
	// backsubstitute to get the inverse
	lu_substitute(M, pm, inverse);
	return product;
 }

 #endif //INVERT_MATRIX_HPP

//#define round(x) ((x) < LONG_MIN-0.5 || (x) > LONG_MAX+0.5 ?\error() : ((x)>=0?(long)((x)+0.5):(long)((x)-0.5))

int main (int argc, char* argv[]){
	if(argc==1) {
		cout<<"	"<<argv[0]<<" extracts the graphs of squared squares / quilts"<<endl;
		cout<<"	from plantri graphs and saves them as a plantri file with an x_ prefix."<<endl;
		cout<<"	A plantri binary file is required for input"<<endl;
		cout<<"	Only plantri files produced with the same number of edges are suitable for processing with sqfind"<<endl;
		cout<<"	use the plantri -e switch with a particular edge value, not an edge range "<<endl;
		cout<<"	plantri is available from http://cs.anu.edu.au/~bdm/plantri/"<<endl;
		cout<<"	The program sqfind is by Stuart Errol Anderson."<<endl;
		cout<<"	stuart.errol.anderson@gmail.com, "<<endl;
		cout<<"	If bouwkampcode, postscript and classification of tilings are required, "<<endl;
		cout<<"	other programs such as sqt, tc2bkp and bk2pss should be used to classify "<<endl;
		cout<<"	extract bouwkampcode/tablecode and produce postscript from the x_files produced by sqfind."<<endl;
		cout<<"	sqfind, sqt, tk2bkp, bk2pss and other software is available from http://www.squaring.net/downloads"<<endl;
		exit(0);
	}
	double time_start = get_time();
	string pla_input_file;
	string outputfilename;
	string noddy_input_file(argv[1]);
	ifstream          File(noddy_input_file.c_str(), ios::in | ios::binary);     
	outputfilename = "x_";
	outputfilename.append(argv[1]);	//Concatenates  Same as outputfilename += argv[1];
	ofstream plantriOutFile(outputfilename.c_str(), ios::out | ios::ate  | ios::binary );
	//cout<<noddy_input_file.c_str()<<" "<<outputfilename.c_str()<<" "<<"seekp outF "<<plantriOutFile.tellp()<<endl;
	if (!File) { // check it opened ok
		std::cerr << "Cannot open file "<< argv[1]<< " \n"; 
	}
	if (!plantriOutFile) { // check it opened ok
		std::cerr << "Cannot open file "<<outputfilename.c_str()<< " \n"; 
	}
	timer  t1;
	ofstream noddy_file;
	cout<<"processing plantri file "<<argv[1]<<" for square tiling..."<<endl;
	int n=0; int v=0;unsigned int e=0; int f=0; int g =0 ;int gcount = 0;
	bool swtch = true;
	bool gsave = true;
	char c; 
	string line ="";
	vector< vector<unsigned int> > graph;
	vector<unsigned int> edges;
	int pc = 0;  //perfect square counter
	int ic = 0;  //imperfect square counter
	string p = "i"; // i imperfect, p perfect
	File.seekg(15, ios::beg); // skip 15 char file header >>planar_code<<
	//	File.seekg(15+(g-1)*bsize, ios::beg);//skip 15 char file header >>planar_code<< and go to graph g, (only works if all graphs have same number of edges, ie edge switch used in plantri, for a given number of edges ,not a range of edges)
	for(;;) {
		if(File.read (&c, 1)) {
			g++;
			//cout <<g<<endl;
			n = (unsigned char) c; // first char is n number of graph vertices
			//cout<<" "<<n;
			graph.reserve(n); //number of graph vertices , dual faces
			//int degree = 0;
			for (int i = 0; i<n ; i++) { // cyclic adj lists for each node
				if(File.read (&c, 1)) {
					v = (unsigned char) c;
					//cout<<" "<<v<<" ";
					e++;
					edges.push_back(v);
					while (v!=0) {
						if(File.read (&c, 1)) {
							v = (unsigned char) c;	
							//cout <<v;
							if (v!=0) {	
							edges.push_back(v);
							e++;
							}
						}
						else {
							cout<<"read file failed"<<endl;
						break;
						}
					}
					graph.push_back(edges);
 					edges.clear();
				}
				else {
					cout<<" read file failed"<<endl;
					break;
				}
			}
		}
		else {
			if (File.eof()){
				cout <<"end of file "<<argv[1]<<endl;
			} else {
				cout <<"check filename, "<<argv[1]<<" and file location"<<endl;
			}
 			double time_end = get_time();
			cout << "graphs processed = " << g << ";" << endl;
			cout << "imperfect squares = "<< ic << endl;
			cout << "perfect squares = "<< pc << endl;
			if (gcount >0) {
				cout <<gcount<<" graphs saved to plantri file " << outputfilename  <<  endl;
			}
			else { 
				cout <<"no squared square graphs found, nothing to save  "  <<  endl;
			}
			std::cout<<"This program has run for: "<< time_end - time_start<< " seconds."<<std::endl;
			plantriOutFile.close();
			File.close();
			break;
		}
		f = e/2 - n + 2;
		e = e/2;
		ublas::matrix<double> Aa(e,n);
		ublas::matrix<double> K(n-1,n-1);
		ublas::matrix<double> V(n-1,n-1);
		ublas::matrix<double> F(e,e);
		ublas::matrix<double> T(n-1,e);
		ublas::vector<double> R(e);
		ublas::matrix<double> B(e,e);
		ublas::matrix<double> m(e,e);

		//cout<<"fill Aa incidence matrix with primal graph edge 1,-1 entries"<<endl;
		unsigned int i = 0;
		Aa.clear();
		//cout<<"gsize "<<graph.size()<<"guu vv size "<<graph[0].size()<<endl;
		for (unsigned int uu = 0; uu < graph.size(); uu++) { // iterate over the rows, source vertices
			for (unsigned int vv = 0; vv < graph[uu].size(); vv++) { // iterate over edges to the target vertices
				if (uu+1<graph[uu][vv]) { //
					Aa(i,uu) =  1;             // edge coming from source to target, positive reference direction
					Aa(i,graph[uu][vv]-1) = -1;// same edge going from target to source, negative reference direction
					i++;
				} 
			}
		}
		//cout << Aa <<endl;
		i = 0;
		ublas::matrix_range<ublas::matrix<double> > A(Aa, ublas::range(0,e),ublas::range(1,n));
		T = ublas::trans(A);
		//K = A . T
		K = prod( T, A );	
		double det = InvertMatrix(K , V);
		// multiply the determinant by the inverted matrix
		V = round(det)*V;
		//F = T . V . A    ;  F = transpose[A] * V * A, use a temporary matrix m in a 2 step calculation for speed m = V * A, F = T * m
		m = prod( A, V );// m temp matrix
		F = prod( m, T );
		// calculating the currents reduction factors vector 
		for(unsigned int i=0; i<e; i++)
		{
			if (round(F(i,i))!= 0){
				R[i] = abs(gcd(round(F(i,0)),round( F(i,1))));
				}
			else R[i]=1;
			for (unsigned int j=1; j<e; j++){
				if (round(F(i,j))!= 0){
					R[i] = abs(gcd(round(R[i]), round(F(i,j))));
				}
				
			}
			// cout<< R[i]<<" ";
		}
		// cout<<endl;
		// dividing the currents matrix F by the reduction vector R
		// B = F/R  
		for(unsigned int i=0; i<e; i++)
		{
			for(unsigned int j=0; j<e; j++)
			{
				B(i,j) = round(F(i,j))/R[i];
				if (abs(B(i,j))<0.00000001){ B(i,j) = 0.0; }
			}
		}
		int s2 = 0;  
		int s1 = 0;
		gsave = true;
		for(unsigned int i=0; i<e; i++)        {
			s1 = round(B(i,i));// side1 of the tiling is B(i,i);
			s2 = round(det)/round(R[i])-s1; //side2 = determinant/reduction - side1
			//cout <<s1<<" "<<s2<<endl;
			int z = 0; // 0; no zero edges, 1; has zero edges
			list<int> Currents; 
			for(unsigned int j=0; j<e; j++){  
				Currents.push_back(abs(B(i,j)));// use abs to get absolute values of currents, ignore sign
				if (B(i,j)== 0) z = 1;
			}
			if (z == 1) continue;//if zero edge set z to 1
			// perfection / imperfection test
			Currents.sort();
			// sorted currents cout
			Currents.unique();
			if (Currents.size() == e) { // if all the branch currents are unique 
				p = "p";                //  tiling squares are all different sizes , 'perfect'
			}
			else {
				p = "i";
			}
			if ((s1==s2)) { //if ((s1==s2)&&(p =="p")),  if a square and perfect, and may not have zero edges
				if (p=="p") {
					pc++; 
					cout<<"graph g= "<<g<<" n= "<<n<<" f= "<<f<<" e= "<<e<<" det= "<< setprecision (20) <<round(det)<<endl;
					cout<<p<<" "<<e-1<<" "<<abs(B(i,i))<<" "<<s2; //output polar (battery) edge
					for(unsigned int j=0; j<e; j++) {
						if (i!=j) cout<<"	"<<B(i,j);// output edges except dont output polar (battery) edge twice
					}
				} else {
					ic++;
				}
				cout<<endl;	
				if (swtch){// write pseudo 15 char plantri file header with 15 'x' chars
					char x;
					plantriOutFile.seekp(0, ios::beg);
					x = 'x'; // only this once
					for ( int j = 0; j<15;j++) { 
						plantriOutFile.write((char*)&x, 1);
					}
					swtch = false;
					//plantriOutFile.seekp(15, ios::beg);
				}
				//save the graph (once) if it produces squared square(s)
				if (gsave == true){
					vector<int> pcode;//
					vector<int>::iterator the_iterator;
					char x;
					long int q = -(1+2*e+n);
					File.clear();
					File.seekg(q, ios::cur);//		
					for ( int ii = 0; ii<-q ; ii++){ //read plantri code to a vector
						if(File.read (&x,  1)){
							v = (unsigned char) x;
							pcode.push_back(v);
						}else {
							cout <<"read file failed"<<endl;
							break;
						}
					}
					if ((z==0)||(gsave != false)) {
						cout<<"copy graph number "<<g<<" from "<<noddy_input_file<<" to "<<outputfilename<<endl;
						the_iterator = pcode.begin();//iterate over pcode vector to ofstream;
						while( the_iterator != pcode.end() ){
							unsigned int i = *the_iterator;
							//cout <<i<<" ";
							plantriOutFile.write((char*)&i,  1);
							++the_iterator;
						}
						//cout<<endl;
						gcount++;
					} 
					pcode.clear();	
					gsave = false;
					swtch = false;	
					p = "i";
				}
			}
		Currents.clear();
		}
		//clear objects
		graph.clear();
		edges.clear();
		Aa.clear();
		K.clear();
		V.clear();	
		F.clear();
		T.clear();
		R.clear();
		B.clear();
		m.clear();  
		e = 0;  	
	}
	return 0;
}
