// Stuart Anderson stuart.errol.anderson@gmail.com
// Lorenz Milla 
// SQT (Square Quilter / Squared Tiler) 
// squared square/rectangle finder , finds ciss siss spss cpss cpsr cisr spsr sisr; and produces canonical bouwkampcode
// date: 18th-June 2013
// latest version http://www.squaring.net/downloads

#include <iostream>
#include <fstream>
#include <string>
#include <set>
#include <sstream>
#include <iomanip>
#include <vector>
#include <algorithm>
#include <functional>
#include <cmath>
#include <iterator>
#include <cstring>
#include <cstdlib>
#include <list>
#include <exception>
#include <utility>
#include <limits>
#include <limits.h>
#include <sys/time.h>
double get_time(){
    struct timeval t;
    gettimeofday(&t, NULL);
    double d = t.tv_sec + (double) t.tv_usec/1000000;
    return d;
}

//namespace ublas = boost::numeric::ublas;
using namespace std;

int gcd(int n,int m){return m==0?n:gcd(m,n%m);}

//using boost::timer;

////////////////////////////////////////////////////////////////////////////////////////////////

void voltageG(int GraphDual[100][13], unsigned int e, unsigned int GraphDualSize) 
{
	unsigned int edge = e;
    do
    { 
		// if the target of the edge is an unvisited node 
		// and edge is not a reversal and its not the ground node
		if((GraphDual[edge][9] == -1)&&(GraphDual[edge][6]>= 0)) 
		{
			GraphDual[edge][8] = GraphDual[e][8];
			GraphDual[edge][9] = GraphDual[e][8] - GraphDual[edge][6];
			
			for (unsigned int a = 0; a < GraphDualSize; a++) {
				for (unsigned int b = 0; b < GraphDualSize; b++) {
					if ((GraphDual[b][0]==GraphDual[a][1])&&(GraphDual[b][8] == -1)) {
						GraphDual[b][8] = GraphDual[a][9];
					}
				}
			} 
			voltageG(GraphDual, GraphDual[edge][2],GraphDualSize);// do it again from target node / reversal edge
		} 
		edge = GraphDual[edge][12];
	} while (edge != e) ;
}


///////////////////////////////////////////////////////////////////////////////////////

void voltageD(int GraphDual[100][13], unsigned int e, unsigned int GraphDualSize) 
{
	unsigned int edge = e;
    do
    { 
		// if the target of the edge is an unvisited node 
		// and edge is not a reversal and its not the ground node
		if((GraphDual[edge][11] == -1)&&(GraphDual[edge][7]>= 0)) 
		{
			GraphDual[edge][10] = GraphDual[e][10];
			GraphDual[edge][11] = GraphDual[e][10] - GraphDual[edge][7];
			for (unsigned int a = 0; a < GraphDualSize; a++) {
				for (unsigned int b = 0; b < GraphDualSize; b++) {
					if ((GraphDual[b][3]==GraphDual[a][4])&&(GraphDual[b][10] == -1)) {
						GraphDual[b][10] = GraphDual[a][11];
					}
				}
			} 
			voltageD(GraphDual, GraphDual[edge][2], GraphDualSize);// do it again from target node / reversal edge
		} 
		edge = GraphDual[edge][5];
	} while (edge != e) ;
}

/////////////////////////////////////////////////////////////////////////////////////// 

bool comp_test(int n, int w, int h, vector<int> tc, vector<int> l, vector<int> t, vector<int> r, vector<int> b) {
int i,j,k,fehlt,err,ok;
    for(i=0;i<n;i++) {
     for(j=0;j<n;j++) {
      if((i!=j)&&(l[i]<=l[j])&&(t[i]<=t[j])&&((r[j]-l[i])*(b[j]-t[i])<w*h)) { // topleft:i, bottomright:j, not full square, not single square
       err=0;
       //left border?
           fehlt=b[j]-b[i];
           ok=1;
           while ((fehlt>0)&&(err==0)&&(ok==1)) {
            ok=0;
            for(k=0;k<n;k++) {
             if ((l[k]==l[i])&&(t[k]==b[j]-fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[k]; }
            }
           }
           if (fehlt!=0){err=1;}
       //bottom border?
           fehlt=l[j]-l[i];
           ok=1;
           while ((fehlt>0)&&(err==0)&&(ok==1)) {
            ok=0;
            for(k=0;k<n;k++) {
             if ((b[k]==b[j])&&(r[k]==l[i]+fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[k]; }
            }
           }
           if (fehlt!=0){err=1;}
       //right border?
           fehlt=t[j]-t[i];
           ok=1;
           while ((fehlt>0)&&(err==0)&&(ok==1)) {
            ok=0;
            for(k=0;k<n;k++) {
             if ((r[k]==r[j])&&(b[k]==t[i]+fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[k]; }
            }
           }
           if (fehlt!=0){err=1;}
       //top border?
           fehlt=r[j]-r[i];
           ok=1;
           while ((fehlt>0)&&(err==0)&&(ok==1)) {
            ok=0;
            for(k=0;k<n;k++) {
             if ((t[k]==t[i])&&(l[k]==r[j]-fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[k]; }
            }
           }
           if (fehlt!=0){err=1;}
       if(err==0) { //found subrectangle or subsquare from i to j
        return true;
       }
      }
     }
    }
 return false;
}

int main (int argc, char* argv[]){
	double time_start = get_time();
    bool do_simples = false; bool do_compounds = false; bool do_perfects = false; bool do_imperfects = false; bool do_rectangles = false; bool do_squares = false ;
    string plantri_file;
    if (argc == 1)
    {
		cout<<endl;
		cout <<"SQT (Square Quilter / Squared Tiler)  by Stuart Anderson, Lorenz Milla "<<endl;
		cout <<"========================================================="<<endl;
		cout <<"stuart.errol.anderson@gmail.com"<<endl;
		cout <<"latest version http://www.squaring.net/downloads"<<endl;
		cout <<"version 1#; date 8th-June 2013"<<endl;
		cout <<""<<endl;
		cout <<"Squared rectangles and squared squares are dissections of rectangles and squares "<<endl;
		cout <<"into smaller squares of integer sizes, called the elements."<<endl;
		cout <<"The number of elements is finite and is called the order of the dissection.  "<<endl;
		cout <<"Squared squares and squared rectangles are classified into simple or compound, and perfect or imperfect;"<<endl;
		cout <<"Compound dissections contain a smaller squared square or squared rectangle, simples do not."<<endl;
		cout <<"Perfect dissections have all squares different sizes, imperfects do not."<<endl;
		cout <<"Quilts are squared squares with no such classification."<<endl;
		cout <<"The program sqt generates squared squares, squared rectangles and quilts"<<endl;
		cout <<"from 2 and 3-connected planar maps which are generated by the program plantri."<<endl;
		cout <<"Plantri is by Gunnar Brinkmann and Brendan McKay and is available from"<<endl;
		cout <<"http://cs.anu.edu.au/~bdm/plantri/ ."<<endl;
		cout <<"sqt has the following options and combinations "<<endl;
		cout <<"Syntax is: sqt [-scpirS] filename"<<endl; 
		cout <<"(filename is a plantri binary file)."<<endl;
		cout <<"[-scpirS] are the optional arguments."<<endl;
		cout <<"s (lower case) for simples"<<endl;
		cout <<"c for compounds "<<endl;
		cout <<"p for perfects"<<endl;
		cout <<"i for imperfects"<<endl;
		cout <<"r for rectangles"<<endl;
		cout <<"S (upper case) for squares"<<endl;
		cout <<"If no arguments are given, default options used are -cspiS"<<endl;
		cout <<"i.e. compound, simple, perfect and imperfect squared squares (also known as quilts)."<<endl;
		cout <<"The output is saved as tablecode. Tablecode is canonical bouwkampcode without parentheses and commas"<<endl;
		cout <<"Format is ; order, width, height followed by the elements listed from left to right and top to bottom."<<endl;
		cout <<"Tablecode output  files are named with the input filename, a dash '-',"<<endl;
		cout <<"and letters s or c and p or i meaning simple or compound and perfect or imperfect,"<<endl;
		cout <<"followed by ss for squared squares or sr for squared rectangles"<<endl;
		cout <<endl;

		return 0;
    }
    else if (argc == 2)
	{
	    plantri_file = argv[1];
	    do_simples = true;
	    do_compounds = true;
	    do_perfects = true;
	    do_imperfects = true;
	    do_squares = true;
	    do_rectangles = false;
	}
	else if (argc == 3)
	{
		plantri_file = argv[2];
		string args = argv[1];
		if (args.find_first_of("-")!=string::npos)
		{
		    for (unsigned int c=1; c<args.length(); c++)//-scpirS
		    {
				if (args.find_first_of("s")!=string::npos) do_simples = true;
				if (args.find_first_of("c")!=string::npos) do_compounds = true;
				if (args.find_first_of("p")!=string::npos) do_perfects = true;
				if (args.find_first_of("i")!=string::npos) do_imperfects = true;
				if (args.find_first_of("r")!=string::npos) do_rectangles = true;
				if (args.find_first_of("S")!=string::npos) do_squares = true;
		    }
		    if (args.find_first_of("s")==string::npos) do_simples = false;
		    if (args.find_first_of("c")==string::npos) do_compounds = false;
		    if (args.find_first_of("p")==string::npos) do_perfects = false;
		    if (args.find_first_of("i")==string::npos) do_imperfects = false;
		    if (args.find_first_of("r")==string::npos) do_rectangles = false;
		    if (args.find_first_of("S")==string::npos) do_squares = false;
		} else { 
			cout<<"Syntax is: sqt [-scpirS] filename"<<endl;
			cout<<"type 'sqt', 'enter' for program information "<<endl;
			}
	}

    ifstream File(plantri_file.c_str(), ios::in | ios::binary);     
    if (!File) { // check it opened ok
    	std::cerr << "Cannot open file "<< plantri_file<< " \n"; 
    }
    //timer  t1;

    cout<<"processing plantri file "<<plantri_file<<" ..."<<endl;
	int n=0; int v=0;unsigned int e=0; int g =0 ; // int f=0; 
	char c; 
    string line ="";
	//vector< vector<unsigned int> > graph;
	unsigned int graph[50][100];
	//vector<unsigned int> edges;
	//unsigned int edges[100];
	int total_spss = 0; int total_spsr = 0; int total_siss = 0; int total_sisr = 0; int total_cpss = 0; int total_cpsr = 0; int total_ciss = 0; int total_cisr = 0;
    
	File.seekg(15, ios::beg); // skip 15 char file header >>planar_code<< 
	for(;;) {
		if(File.read (&c, 1)) {
			g++;
      		n = (unsigned char) c; // first char is n number of graph vertices
			//graph.reserve(n); //number of graph vertices , dual faces		
      		for (int i = 0; i<n ; i++) { // cyclic adj lists for each node
		int ec=0;
            	if(File.read (&c, 1)) {
                  	v = (unsigned char) c;	
			graph[i][ec]=v;
                  	ec++;
                 	while (v!=0) {
                 		if(File.read (&c, 1)) {
                  			v = (unsigned char) c;	
					if (v!=0) {	
            				graph[i][ec]=v;
            				ec++;
            				}				 	
                  		}
                  		else {
            		        cout<<"read file failed"<<endl;
            		        break;
            	       }
            	    }
		    e+=ec;
		    graph[i][99]=ec; // save number of edges starting from node i
            	    //graph.push_back(edges);
 		//			edges.clear();
            	}
            	else {
            		cout<<" read file failed"<<endl;
            		break;
            	}
			}
		}
		else {
				if (File.eof()){
					cout<<"end of file "<<plantri_file<<endl;
				} else {
					cout <<"check filename, "<<plantri_file<<" and file location"<<endl;
			}
			cout << "In file "<<plantri_file <<" "<<g<<" graphs were processed to find;" <<  endl;
			if ((do_simples==true)&&(do_perfects==true)&&(do_squares==true)) cout <<total_spss<< " simple perfect squared squares;"<<endl;
			if ((do_simples==true)&&(do_perfects==true)&&(do_rectangles==true)) cout <<total_spsr<< " simple perfect squared rectangles;"<<endl;
			if ((do_simples==true)&&(do_imperfects==true)&&(do_squares==true)) cout <<total_siss<< " simple imperfect squared squares;"<<endl;
			if ((do_simples==true)&&(do_imperfects==true)&&(do_rectangles==true)) cout <<total_sisr<< " simple imperfect squared rectangles;"<<endl;
			if ((do_compounds==true)&&(do_perfects==true)&&(do_squares==true)) cout <<total_cpss<< " compound perfect squared squares;"<<endl;
			if ((do_compounds==true)&&(do_perfects==true)&&(do_rectangles==true)) cout <<total_cpsr<< " compound perfect squared rectangles;"<<endl;
			if ((do_compounds==true)&&(do_imperfects==true)&&(do_squares==true)) cout <<total_ciss<< " compound imperfect squared squares;"<<endl;
			if ((do_compounds==true)&&(do_imperfects==true)&&(do_rectangles==true)) cout <<total_cisr<< " compound imperfect squared rectangles."<<endl;
			double time_end = get_time();
			std::cout<<"This program has run for: "<< time_end - time_start<< " seconds."<<std::endl<<std::endl;
			break;
		}

//        f = e/2 - n + 2;
//    	vector< vector< int> >::size_type uu;
//		vector< int>::size_type vv;
    	e = e/2;
			
			// ############## begin new code #####################
			
			
		double Aa[e][n];
		double K[n-1][n-1];
		double R[e];
		
		//cout<<"fill Aa incidence matrix with primal graph edge 1,-1 entries"<<endl;
		unsigned int i = 0;
		//Aa.clear();
		for(unsigned int ii=0;ii<e;ii++) { for(int jj=0;jj<n;jj++) { Aa[ii][jj]=0.0; } }
		//cout<<"gsize "<<n<<"guu vv size "<<graph[0].size()<<endl;
		for (int uu = 0; uu < n; uu++) { // iterate over the rows, source vertices
			for (unsigned int vv = 0; vv < graph[uu][99]; vv++) { // iterate over edges to the target vertices
				if (uu+1<graph[uu][vv]) { //
					Aa[i][uu] =  1.0;             // edge coming from source to target, positive reference direction
					Aa[i][graph[uu][vv]-1] = -1.0;// same edge going from target to source, negative reference direction
					i++;
				} 
			}
		}
		//cout << Aa <<endl;
		i = 0;
		//ublas::matrix_range<ublas::matrix<double> > A(Aa, ublas::range(0,e),ublas::range(1,n));
		//double A[e][n-1];
		//double T[n-1][e];
		//for(unsigned int ii=0;ii<e;ii++) { for(int jj=0;jj<n-1;jj++) { A[ii][jj]=Aa[ii][jj+1]; T[jj][ii]=A[ii][jj]; } } // leave first column away
		
		//T = ublas::trans(A);
		//K = A . T
		//K = prod( T, A );	
		for(int ii=0;ii<n-1;ii++) { for(int jj=0;jj<=ii;jj++) { K[ii][jj]=0.0; for(unsigned int kk=0;kk<e;kk++) { K[ii][jj]+=Aa[kk][ii]*Aa[kk][jj]; } K[jj][ii]=K[ii][jj]; } }
		
	//########## start decomposing K = L D L^T, 
		double dett=1.0;
    double dd[n-1];
		double ll[n-1][n-1];
		 for(int ii=0;ii<n-1;ii++) {
		  dd[ii]=0.0;
			for(int jj=0;jj<n-1;jj++) {
			 ll[ii][jj]=0.0;
		  }
		 }
		 for (int jj=0;jj<n-1;jj++) {
			ll[jj][jj]=1.0;
			dd[jj]=K[jj][jj];
			for(int kk=0;kk<jj;kk++) { dd[jj] = dd[jj] - ll[jj][kk]*dd[kk]*ll[jj][kk];}
			for(int ii=jj+1;ii<n-1;ii++) {
				ll[jj][ii]=0;
				ll[ii][jj]=K[ii][jj];
				for(int kk=0;kk<jj;kk++) { ll[ii][jj] = ll[ii][jj] - ll[ii][kk]*dd[kk]*ll[jj][kk]; }
				ll[ii][jj] = ll[ii][jj]/dd[jj];
			}
			dett=dett*dd[jj]; 
		 }
		int ii;
		int j;
		int k;
		//######### start inverting K, first VV = L^(-1)
		double VV[n-1][n-1];
for(ii=0;ii<n-1;ii++) {
 for(j=0;j<n-1;j++) {
  if(ii==j) { VV[ii][j]=1; } else { VV[ii][j]=0; }
 }
}
for(ii=0;ii<n-1;ii++) {
 for(j=ii+1;j<n-1;j++) {
  for(k=0;k<=j;k++) {
   VV[j][k]-=ll[j][ii]*VV[ii][k];
  }
 }
}
//now VV=L^(-1)


	//####### start V = VV^T * VVV
	double V[n-1][n-1];
	for(ii=0;ii<n-1;ii++) {
	  for(j=0;j<=ii;j++) {
		  V[ii][j]=0;
		  for(k=ii;k<n-1;k++) {
			  V[ii][j]+=VV[k][ii]*dett/dd[k]*VV[k][j];
			}
			V[j][ii]=V[ii][j];
		}
	}
	// now V = K^(-1)*det(K)
		
		
		
		double det = dett; //InvertMatrix(K , V);
		// multiply the determinant by the inverted matrix
		//V = round(det)*V;
		
		//for(i=0;i<n-1;i++) {
		// for(j=0;j<n-1;j++) {
		//  std::cout<<V[i][j]<<" ";
		// }
		//  std::cout<<std::endl;
	  //}
		//std::cout<<std::endl;
		
		
		//F = T . V . A    ;  F = transpose[A] * V * A, use a temporary matrix m in a 2 step calculation for speed m = V * A, F = T * m
		double m[e][n-1];
		double F[e][e];
		
		for(i=0;i<e;i++) {for(j=0;j<n-1;j++) { m[i][j]=0.0; for(k=0;k<n-1;k++) { m[i][j]+=Aa[i][k]*V[k][j]; } } }
		//m = prod( A, V );// m temp matrix
		
		for(i=0;i<e;i++) {for(unsigned int j=0;j<e;j++) { F[i][j]=0.0; for(k=0;k<n-1;k++) { F[i][j]+=m[i][k]*Aa[j][k]; } } }
		//F = prod( m, T );
		// calculating the currents reduction factors vector 
		for(unsigned int i=0; i<e; i++)
		{
			if (round(F[i][i])!= 0){
				R[i] = abs(gcd(round(F[i][0]),round( F[i][1])));
				}
			else R[i]=1;
			for (unsigned int j=1; j<e; j++){
				if (round(F[i][j])!= 0){
					R[i] = abs(gcd(round(R[i]), round(F[i][j])));
				}
				
			}
			// cout<< R[i]<<" ";
		}
		// cout<<endl;
		// dividing the currents matrix F by the reduction vector R
		// B = F/R  
    double B[e][e];
		for(unsigned int i=0; i<e; i++)
		{
			for(unsigned int j=0; j<e; j++)
			{
				B[i][j] = round(F[i][j])/R[i];
				if (abs(B[i][j])<0.00000001){ B[i][j] = 0.0; }
			}
		}
		
			
				// ################ end of new code #######################
				
        int s2 = 0;  
        int s1 = 0;
        bool is_compound;
		bool is_square;
		bool is_perfect;
		set <string> spss; set <string> spsr; set <string> siss; set <string> sisr; set <string> cpss; set <string> cpsr; set <string> ciss; set <string> cisr;

        for(unsigned int i=0; i<e; i++)        {
            s1 = round(B[i][i]);// side1 of the tiling is B(i,i);
        	s2 = round(det)/round(R[i])-s1; //side2 = determinant/reduction - side1
        	bool has_zero_edges = false; // false; no zero edges, true; has zero edges
        	if (s1 == s2 ) { 
        		is_square = true;
        	} else {
        		is_square = false;
        	}
    		list<int> Currents; 
    		for(unsigned int j=0; j<e; j++){  
    			if (B[i][j]==0){ 
    				has_zero_edges = true;
    			}
    			Currents.push_back(abs(B[i][j]));// use abs to get absolute values of currents, ignore sign
    		}
			Currents.sort();
			// sorted currents cout
			Currents.unique();
			if (Currents.size() == e) { // if all the branch currents are unique 
				is_perfect = true;                //  tiling squares are all different sizes , 'perfect'
			}
			else { 						// if some branch currents are the same
				is_perfect = false;                // some tilings squares are the same size
			}
			if (( ((is_square == true )&&(do_squares == true)) || ((is_square == false)&&(do_rectangles == true)) || ((is_perfect==true)&&(do_perfects==true)) || ((is_perfect==false)&&(do_imperfects==true)) )&&(has_zero_edges == false))
			{ 
				int GraphDual[100][13];
				//int str[13]; // edge s->t, 'str'; s source vertex, t target vertex, r index of reversal edge
				//GraphDual.reserve(13); // 
				//str.reserve(e);
				int GraphDualSize=0;
				for (int a = 0; a< n; a++) {
					for (unsigned int b= 0; b < graph[a][99]; b++) {
						GraphDual[GraphDualSize][0]=a+1; 		// 0 graph edge source vertex / bottom dual face
		  				GraphDual[GraphDualSize][1]=graph[a][b];	// 1 graph edge target vertex / top dual face
		  				GraphDual[GraphDualSize][2]=0;			// 2 graph edge reversal edge 
		  				GraphDual[GraphDualSize][3]=0;			// 3 dual edge source vertex / left graph face
						GraphDual[GraphDualSize][4]=0;			// 4 dual edge target vertex / right graph face
		  				GraphDual[GraphDualSize][5]=0;			// 5 dual edge cyclically adjacent edge 
		  				GraphDual[GraphDualSize][6]=0;			// 6 graph edge branch current
		  				GraphDual[GraphDualSize][7]=0;			// 7 dual edge branch current
		  				GraphDual[GraphDualSize][8]=-1;			// 8 graph edge source voltage
		  				GraphDual[GraphDualSize][9]=-1;			// 9 graph edge target voltage
		  				GraphDual[GraphDualSize][10]=-1;		// 10 dual edge source voltage
		  				GraphDual[GraphDualSize][11]=-1;		// 11 dual edge target voltage
		  				GraphDual[GraphDualSize][12]=0;			// 12 graph edge cyclically adjacent edge 
		  				GraphDualSize++;
		  			}
				}	
				// find the reversal edge for each graph edge, and cyclically adjacent dual edge of reversal edge, and save both in GraphDual 
				for (int a = 0; a< GraphDualSize; a++) {
					for (int b= 0; b < GraphDualSize; b++) {
						if (a !=b) {  // all edges non-simple, dont need to test case a==b
							if ((GraphDual[a][0]==GraphDual[b][1])&&(GraphDual[a][1]==GraphDual[b][0])) { // if s==t and t==s ie it is a reversal edge
								GraphDual[a][2] = b;
							}
							if (b<GraphDualSize-1){  //if not last item and if reversal edge has a successor in adjacency list set to successor
								if ((GraphDual[a][0]==GraphDual[b][1])&&(GraphDual[a][1]==GraphDual[b][0])&&(GraphDual[b+1][0] == GraphDual[b][0])) { 
									GraphDual[a][5] = b+1; // if not, successor is first item in adjacency list
								} else if ((GraphDual[a][0]==GraphDual[b][1])&&(GraphDual[a][1]==GraphDual[b][0])&&(GraphDual[b+1][0] != GraphDual[b][0])){ 
									GraphDual[a][5] = b - (graph[GraphDual[b][0]-1][99]-1);
								}
							} else if ((GraphDual[a][0]==GraphDual[b][1])&&(GraphDual[a][1]==GraphDual[b][0])) { // last item in  GraphDual
								 GraphDual[a][5] = b - (graph[GraphDual[b][0]-1][99]-1);
							}
						}
					}
				}	
				// find graph edge cyclically adjacent edge
				int start = 0;

				for (int a = 1; a< GraphDualSize; a++) {
					if (GraphDual[a-1][0]==GraphDual[a][0]) { 
						GraphDual[a-1][12] = a; // 
					} else {
						GraphDual[a-1][12] = start;
						start = a;
					}
				}
				GraphDual[GraphDualSize-1][12] = start;
				// construct  face index (dual graph vertices) and save in GraphDual
				int c=0;
				unsigned int thisedge = 0;
				for (int a = 0; a< GraphDualSize; a++) {
					thisedge = a;
					if (GraphDual[thisedge][3] == 0) c++; 
					while (GraphDual[thisedge][3] == 0){ // iterate over the edges of the face until all have been indexed
						GraphDual[thisedge][3] = c;	//source face index is set to c
						thisedge = GraphDual[thisedge][5]; //new thisedge set to the edge cyclically adjacent to thisedge
					}
				}
				for (int a = 0; a< GraphDualSize; a++) {
					GraphDual[a][4] = GraphDual[GraphDual[a][2]][3] ; //target face set to reversal edge face
				}
				// create the dual graph 




//#######################



				//int dual[100][100];
				//dual.reserve(f); //number of dual vertices | graph faces
				//thisedge = 0;
				//int t = 0;
				//for (unsigned int a = 0; a < GraphDualSize; a++) {
			//		if ((GraphDual[a][3]) == (t+1)) { // if the source face of the edge is equal to the index + 1 ( offset to zero based vector array )
			//			thisedge = a;
			///			do{ // 
			//				dual[a].push_back(GraphDual[thisedge][4]);// 4 dual edge target face
			//				thisedge = GraphDual[thisedge][5]; // 5 cyclically adjacent edge 
			//			}while ((thisedge != a));
			//			t++;
			//			dual.push_back(edges);
		//	/			edges.clear();
			//		}  
			//	}
				// perfection / imperfection test
	    		unsigned int ecount=0;
	    		unsigned int dcount=0;
	    		unsigned int edgeindx=0;
				// assign currents to edges of graph and dual, and set polar voltages
				for (int uu = 0; uu < n; uu++) { // iterate over the rows, source vertices
	    			for (unsigned int vv = 0; vv < graph[uu][99]; vv++) { // iterate over the target vertices
	    				if (uu+1<graph[uu][vv]) { //
						    if(i == ecount) {
								//assign currents, voltages to polar graph, dual edges and nodes
								GraphDual[dcount][6] = s1; //polar graph edge current
								GraphDual[GraphDual[dcount][2]][6] = -s1;//polar graph reversal edge current
								GraphDual[dcount][7] = s2; //polar dual edge current
								GraphDual[GraphDual[dcount][2]][7] = -s2;//polar dual reversal edge current
								GraphDual[dcount][8] = s1; //set graph polar edge current source node voltage to polar edge current value
								GraphDual[dcount][10] = s2;//set dual polar edge current target node voltage to polar edge current value
								edgeindx = dcount;//count of all edges
								} else {
								//assign currents to graph and dual edges
								GraphDual[dcount][6] = B[i][ecount];//graph edge current
								GraphDual[GraphDual[dcount][2]][6] = -B[i][ecount];//graph reversal edge current
								GraphDual[dcount][7] = -B[i][ecount];//dual edge current
								GraphDual[GraphDual[dcount][2]][7] = B[i][ecount];//dual reversal edge current
							}
	    		  			ecount++;  //count of +ve edges
	    		  		}//
	    		  		dcount++; //count of all edges
	    			}
				} 
				//Calculate graph and dual vertex voltages
				voltageG(GraphDual, edgeindx, GraphDualSize);
				voltageD(GraphDual, edgeindx, GraphDualSize);
				//display(GraphDual);
				//generate bouwkampcode given x,y coordinates  and element sizes 
 				//(equivalent to graph & dual node voltages, x[],y[] and edge currents s[j+2] respectively)
				vector<int> x;
				vector<int> y;
				vector<int> s;
				s.push_back(e-1);
				s.push_back(s1);
				s.push_back(s2);
				for (int a = 0; a< GraphDualSize; a++) {
					if ((GraphDual[a][6]>0)&&(a!=edgeindx)){
						x.push_back(GraphDual[a][8]);
						y.push_back(GraphDual[a][10]);
						s.push_back(GraphDual[a][6]);
					}
				}
				s[0] = s.size()-3;
				for (int a = 0; a < GraphDualSize; a++) {
					GraphDual[a][8]= -1;
					GraphDual[a][9]= -1;
				 	GraphDual[a][10]= -1;
					GraphDual[a][11]= -1;
				}
				std::vector<int> Top ;
				std::vector<int> Bottom ;
				std::vector<int> Left;
				std::vector<int> Right ;
				std::vector<int> Size ;
				Top.reserve(s.size()+1) ;
				Bottom.reserve(s.size()+1) ;
				Left.reserve(s.size()+1);
				Right.reserve(s.size()+1) ;
				Size.reserve(s.size()+1) ;
				//create Top, Left, Right, Bottom (x,y) coordinate vectors and Size vector
				for (unsigned int j = 0; j <  s.size()-3; j++){	
					Right.push_back(x[j]);
					Left.push_back(x[j] - s[j+3]);
					Top.push_back(y[j]);
					Bottom.push_back(y[j] + s[j+3]);
					Size.push_back(s[j+3]);
				}

				is_compound = comp_test(s[0], s1, s2,Size,Left,Top,Right,Bottom);
				//simple_compound_test(s[0], s1, s2, Size, Top, Left, Right, Bottom);
				if (((is_compound == true)&&(do_compounds == false))||((is_compound == false)&&(do_simples == false))) {continue;}
				//copy element position vectors
				std::vector<int> sortedTop(Top); //copy Top vector to sortedTop vector using constructor
				std::vector<int> sortedLeft(Left);// "      Left     "      "  sortedLeft  "          "           "
				std::vector<int> sortedRight(Right); //    copy Right vector to sortedRight vector using constructor
				std::vector<int> sortedBottom(Bottom);// "      Bottom "      "  sortedBottom  "          "           "		
				//sort copied element position vectors
				std::sort(sortedTop.begin(), sortedTop.end()); // sort sortedTop vector in ascending order
				std::sort(sortedLeft.begin(), sortedLeft.end());//   "    sortedLeft   "       "      "               "
				std::sort(sortedRight.begin(), sortedRight.end()); //       sort sortedRight vector in ascending order
				std::sort(sortedBottom.begin(), sortedBottom.end());//   "    sortedBottom   "       "      "               "			
				//eliminate duplicate values to get unique sorted element position vectors
				sortedTop.erase( std::unique( sortedTop.begin(),sortedTop.end() ), sortedTop.end() ); // unique sortedTop vector in ascending order
				sortedLeft.erase( std::unique( sortedLeft.begin(),sortedLeft.end() ), sortedLeft.end() );//   "         sortedLeft   "       "      "               "			
				sortedRight.erase( std::unique( sortedRight.begin(),sortedRight.end() ), sortedRight.end() ); //                unique sortedTop vector in ascending order
				sortedBottom.erase( std::unique( sortedBottom.begin(),sortedBottom.end() ), sortedBottom.end() );//       "       sortedBottom   "   "      "               "		
				std::vector<int> compBkcode; 
				std::vector<std::vector<int> > bkCodes;

				compBkcode.push_back(s[0]);  
				compBkcode.push_back(s[1]);
				compBkcode.push_back(s[2]);  

				for (unsigned int p=0; p < sortedTop.size(); p++){
					for (unsigned int q=0; q < sortedLeft.size(); q++){
						for (unsigned int r=0; r < Size.size(); r++){
							if((sortedTop[p]==Top[r])&&(sortedLeft[q]==Left[r])){
								compBkcode.push_back(Size[r]);
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();

				//2. create bouwkampcode Top Right -> Bottom Left;  Top down
				compBkcode.push_back(s[0]);  // Order of squared square
				compBkcode.push_back(s[1]);  // Width  "      "             "
				compBkcode.push_back(s[2]);  // Height "     "             "
				for (unsigned int p=0; p < sortedTop.size(); p++){
					for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
						for (unsigned int r=0; r < Size.size(); r++){
							if((sortedTop[p]==Top[r])&&(*qit==Right[r])){
								compBkcode.push_back(Size[r]);
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();

		 		//3. create bouwkampcode Bottom Right -> Top Left ; Bottom up
				compBkcode.push_back(s[0]);  // Order of squared square
				compBkcode.push_back(s[1]);  // Width  "      "             "
				compBkcode.push_back(s[2]);  // Height "     "             "
				for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
					for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
						for (unsigned int r=0; r < Size.size(); r++){
							if((*pit==Bottom[r])&&(*qit==Right[r])){
								compBkcode.push_back(Size[r]);
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
				//4. create bouwkampcode Bottom Left -> Top Right ; Bottom up
				compBkcode.push_back(s[0]);  // Order of squared square
				compBkcode.push_back(s[1]);  // Width  "      "             "
				compBkcode.push_back(s[2]);  // Height "     "             "
				for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
					for (unsigned int q=0; q < sortedLeft.size(); q++){
						for (unsigned int r=0; r < Size.size(); r++){
							if((*pit==Bottom[r])&&(sortedLeft[q]==Left[r])){
								compBkcode.push_back(Size[r]);
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
		 		//5. create bouwkampcode Top Left -> Bottom Right ; Left across
				compBkcode.push_back(s[0]);  // Order of squared square
				compBkcode.push_back(s[2]);  // Width  "      "             "
				compBkcode.push_back(s[1]);  // Height "     "             "
				for (unsigned int q=0; q < sortedLeft.size(); q++){
					for (unsigned int p=0; p < sortedTop.size(); p++){
						for (unsigned int r=0; r < Size.size(); r++){
							if((sortedTop[p]==Top[r])&&(sortedLeft[q]==Left[r])){
								compBkcode.push_back(Size[r]);
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
		 		//6. create bouwkampcode Top Right -> Bottom Left ; Right across
				compBkcode.push_back(s[0]);  // Order of squared square
				compBkcode.push_back(s[2]);  // Width  "      "             "
				compBkcode.push_back(s[1]);  // Height "     "             "
				for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
					for (unsigned int p=0; p < sortedTop.size(); p++){
						for (unsigned int r=0; r < Size.size(); r++){
							if((sortedTop[p]==Top[r])&&(*qit==Right[r])){
								compBkcode.push_back(Size[r]);
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
		 		//7. create bouwkampcode Bottom Right -> Top Left ; Right across
				compBkcode.push_back(s[0]);  // Order of squared square
				compBkcode.push_back(s[2]);  // Width  "      "             "
				compBkcode.push_back(s[1]);  // Height "     "             "
				for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
					for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
						for (unsigned int r=0; r < Size.size(); r++){
							if((*pit==Bottom[r])&&(*qit==Right[r])){
								compBkcode.push_back(Size[r]);
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
		 
		 		//8. create bouwkampcode Bottom Left -> Top Right ; Left across
				compBkcode.push_back(s[0]);  // Order of squared square
				compBkcode.push_back(s[2]);  // Width  "      "             "
				compBkcode.push_back(s[1]);  // Height "     "             "
				for (unsigned int q=0; q < sortedLeft.size(); q++){
					for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
						for (unsigned int r=0; r < Size.size(); r++){
							if((*pit==Bottom[r])&&(sortedLeft[q]==Left[r])){
								compBkcode.push_back(Size[r]);
							}
						}
					}
				}
				bkCodes.push_back(compBkcode);
				compBkcode.clear();
				
				//canonical bouwkampcode string method
				vector<unsigned int> compsum (8);
				stringstream ss;
				int wordsize;
				vector<string> bkrowstring;
				if (s[1] > s[2] ) {
					wordsize = ceil(log10(s[1]));
					if (ceil(log10(s[1]))==log10(s[1])) wordsize++;
					} else {
					wordsize = ceil(log10(s[2]));
					if (ceil(log10(s[2]))==log10(s[2])) wordsize++;
				}
				
				//cout<<wordsize<<endl;
				unsigned int l = Size.size()+3; //l is bouwkampcode length
				unsigned int ssize = l*wordsize;
				for (unsigned int p = 0; p < 8 ; p++) {
					for (unsigned int q = 0; q < l ; q++) {
						ss << setw(wordsize) << setfill('0')<<bkCodes[p][q];
					}
					bkrowstring.push_back(ss.str());
					ss.str("");
					ss.clear();
				}
				for (unsigned int p = 0; p < 8 ; p++) {
					for (unsigned int q = 0; q < 8 ; q++) {
						if (q<p) {
							if (lexicographical_compare(bkrowstring[q].c_str(),bkrowstring[q].c_str()+ssize,bkrowstring[p].c_str(),bkrowstring[p].c_str()+ssize)) {
		  						//cout << bkrowstring[p] << " is greater than " << bkrowstring[q] << endl;
		  						compsum[p] = compsum[p]++;
							} else { compsum[q] = compsum[q]++; }
  						}
					}
				}
				//row qq with the largest sum is the canonical row
				std::vector<unsigned int>::iterator result = std::max_element(compsum.begin(), compsum.end());
				int qq = std::distance(compsum.begin(), result) ;
				compsum.clear();
				bkrowstring.clear();
				
				//cout<<"write canonical code"<<endl;
				std::ostringstream bk;
				for (unsigned int j=0; j < Size.size()+3; j++){
					bk<<bkCodes[qq][j]<<" ";
					//cout<<bkCodes[qq][j]<<" ";
				}
				//cout<<endl;
				bk<<endl;
				
				if ((is_compound==false)&&(do_simples==true)&&(is_perfect==true)&&(do_perfects==true)&&(is_square==true)&&(do_squares==true)) {
					spss.insert(bk.str()); 
				}
				if ((is_compound==false)&&(do_simples==true)&&(is_perfect==true)&&(do_perfects==true)&&(is_square==false)&&(do_rectangles==true)) {
					spsr.insert(bk.str()); 
				}
				if ((is_compound==false)&&(do_simples==true)&&(is_perfect==false)&&(do_imperfects==true)&&(is_square==true)&&(do_squares==true)) {
					siss.insert(bk.str()); 
				}
				if ((is_compound==false)&&(do_simples==true)&&(is_perfect==false)&&(do_imperfects==true)&&(is_square==false)&&(do_rectangles==true)) {
					sisr.insert(bk.str());
				}
				if ((is_compound==true)&&(do_compounds==true)&&(is_perfect==true)&&(do_perfects==true)&&(is_square==true)&&(do_squares==true)) {
					cpss.insert(bk.str());
				}
				if ((is_compound==true)&&(do_compounds==true)&&(is_perfect==true)&&(do_perfects==true)&&(is_square==false)&&(do_rectangles==true)) {
					cpsr.insert(bk.str());
				}
				if ((is_compound==true)&&(do_compounds==true)&&(is_perfect==false)&&(do_imperfects==true)&&(is_square==true)&&(do_squares==true)) {
					ciss.insert(bk.str());
				}
				if ((is_compound==true  )&&(do_compounds==true)&&(is_perfect==false)&&(do_imperfects==true)&&(is_square==false)&&(do_rectangles==true)) {
					cisr.insert(bk.str());
				}
				bk.str("");
				bk.clear();
				bkCodes.clear();
				compBkcode.clear();
				x.clear();
				y.clear();
				s.clear();
				Top.clear() ;
				Bottom.clear() ;
				Left.clear();
				Right.clear() ;
				Size.clear() ;
				//Boundary.clear() ;
				sortedTop.clear() ;
				sortedBottom.clear() ;
				sortedLeft.clear();
				sortedRight.clear() ;	
				//GraphDual.clear();
				//dual.clear();
				Currents.clear();
			}//square/rectangle perfect/imperfect zero edges or not
        }//iterate over all solutions
        //output unique solutions
		std::ostringstream ous;
		std::ofstream bkcanon_file;	// create ofstream  tiling bouwkampcode output file
		set<string>::iterator itspss;
		if ((do_simples==true)&&(do_perfects==true)&&(do_squares==true)&&(!spss.empty())) {
			ous <<plantri_file<<"-"<<"spss.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itspss=spss.begin(); itspss!=spss.end(); itspss++) {
				bkcanon_file<< *itspss;
				total_spss++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		spss.clear();
		set<string>::iterator itspsr;
		if ((do_simples==true)&&(do_perfects==true)&&(do_rectangles==true)&&(!spsr.empty())) {
			ous <<plantri_file<<"-"<<"spsr.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itspsr=spsr.begin(); itspsr!=spsr.end(); itspsr++) {
				bkcanon_file<< *itspsr;
				total_spsr++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		spsr.clear();
		set<string>::iterator itsiss;
		if ((do_simples==true)&&(do_imperfects==true)&&(do_squares==true)&&(!siss.empty())) {
			ous <<plantri_file<<"-"<<"siss.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itsiss=siss.begin(); itsiss!=siss.end(); itsiss++) {
				bkcanon_file<< *itsiss;
				total_siss++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		siss.clear();
		set<string>::iterator itsisr;
		if ((do_simples==true)&&(do_imperfects==true)&&(do_rectangles==true)&&(!sisr.empty())) {
			ous <<plantri_file<<"-"<<"sisr.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itsisr=sisr.begin(); itsisr!=sisr.end(); itsisr++) {
				bkcanon_file<< *itsisr;
				total_sisr++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		sisr.clear();
		set<string>::iterator itcpss;
		if ((do_compounds==true)&&(do_perfects==true)&&(do_squares==true)&&(!cpss.empty())) {
			ous <<plantri_file<<"-"<<"cpss.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itcpss=cpss.begin(); itcpss!=cpss.end(); itcpss++) {
				bkcanon_file<< *itcpss;
				total_cpss++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		cpss.clear();
		set<string>::iterator itcpsr;
		if ((do_compounds==true)&&(do_perfects==true)&&(do_rectangles==true)&&(!cpsr.empty())) {
			ous <<plantri_file<<"-"<<"cpsr.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itcpsr=cpsr.begin(); itcpsr!=cpsr.end(); itcpsr++) {
				bkcanon_file<< *itcpsr;
				total_cpsr++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		cpsr.clear();
		set<string>::iterator itciss;
		if ((do_compounds==true)&&(do_imperfects==true)&&(do_squares==true)&&(!ciss.empty())) {
			ous <<plantri_file<<"-"<<"ciss.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itciss=ciss.begin(); itciss!=ciss.end(); itciss++) {
				bkcanon_file<< *itciss;
				total_ciss++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		ciss.clear();
		set<string>::iterator itcisr;
		if ((do_compounds==true)&&(do_imperfects==true)&&(do_rectangles==true)&&(!cisr.empty())) {
			ous <<plantri_file<<"-"<<"cisr.txt";
			bkcanon_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!bkcanon_file) // check it opened ok
			{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
			}
			for (itcisr=cisr.begin(); itcisr!=cisr.end(); itcisr++) {
				bkcanon_file<< *itcisr;
				total_cisr++;
			}
			bkcanon_file.close();  
		}
		ous.str("");
		ous.clear();
		cisr.clear();
		//clear objects
		//graph.clear();
    	//edges.clear();
		e = 0;  	
	}
  	return 0;
}
