#include <stdio.h>
#include <assert.h>
#include <ctype.h>

#include "Boundary.h"

Boundary boundary;

int read_field( char**x ) {
    int v;
    assert( **x );
    assert( sscanf( *x, "%d", &v ) == 1 );
    while (isdigit(**x)) {
        ++*x;
    }
    while (**x && !isdigit(**x)) {
        ++*x;
    }
    return v;
}

struct Aps {
    int width;
    int height;
    int x;
    int y;
} aps [1000];

struct Rect {
    int size;
    int x;
    int y;
} rect[1000];

struct CombinedElement {
    int size;
    int x;
    int y;
} combined_elements[1000];

int main()
{
    char * lineptr = 0;
    size_t len;
    while(getline( &lineptr, &len, stdin )  != -1 ) {
        char* p = lineptr;

        // find the start of the rectangle
        char* rstring = p;
        while (*++rstring != '[' );
        bool reverse_rect = false;
        if ( rstring[1] == '[' ) {
            reverse_rect = true;
            ++rstring;
        }
        while(!isdigit(*++rstring));

        int aps_order = read_field( &p );
        int aps_width = read_field( &p );
        int aps_height = read_field( &p );
        int num_aps_elements = 0;
        int rectangle_loc = -1;
        while ( p < rstring ) {
            if (p[-1] == ':') {
                aps[--num_aps_elements].height = read_field( &p );
                rectangle_loc = num_aps_elements;
            } else {
                aps[num_aps_elements].width = read_field( &p );
                aps[num_aps_elements].height = aps[num_aps_elements].width;
            }
            ++num_aps_elements;
        }
        
        // now extract the rectangle elements
        int num_rectangle_elements = aps_order + 1 - num_aps_elements;
        p = rstring;
        for ( int i = 0; i < num_rectangle_elements; ++ i ) {
            rect[i].size = read_field( &p );
        }

        // figure out the x/y coordinates of all aps elements
        boundary.initialize( aps_width, aps_height );
        for ( int i = 0; i < num_aps_elements; ++ i ) {
            int x, y;
            boundary.get_loc_lowest( x, y );
            aps[i].x = x;
            aps[i].y = y;
            boundary.add_square( x, x+aps[i].width, y, y+aps[i].height );
        }

        // figure out the x/y coordinates of the rectangle
        int rectangle_width = aps[rectangle_loc].width;
        int rectangle_height = aps[rectangle_loc].height;
        if ( reverse_rect ) {
            int temp = rectangle_width;
            rectangle_width = rectangle_height;
            rectangle_height = temp;
        }
        boundary.initialize( rectangle_width, rectangle_height );
        for ( int i = 0; i < num_rectangle_elements; ++ i ) {
            int x, y;
            boundary.get_loc_lowest( x, y );
            rect[i].x = x;
            rect[i].y = y;
            boundary.add_square( x, x+rect[i].size, y, y+rect[i].size );
        }

        // now create the combined list of all squares
        int num_combined_elements = 0;
        for ( int i = 0; i < num_aps_elements; ++i ) {
            if ( i != rectangle_loc ) {
                combined_elements[num_combined_elements].size = aps[i].width;
                combined_elements[num_combined_elements].x = aps[i].x;
                combined_elements[num_combined_elements].y = aps[i].y;
                ++num_combined_elements;
            }
        }
        int rectangle_x = aps[ rectangle_loc ].x;
        int rectangle_y = aps[ rectangle_loc ].y;

        for ( int i = 0; i < num_rectangle_elements; ++ i ) {
            combined_elements[num_combined_elements].size = rect[i].size;
            if ( reverse_rect ) {
                combined_elements[num_combined_elements].x = rectangle_x + rect[i].y;
                combined_elements[num_combined_elements].y = rectangle_y + rect[i].x;
            } else {
                combined_elements[num_combined_elements].x = rectangle_x + rect[i].x;
                combined_elements[num_combined_elements].y = rectangle_y + rect[i].y;
            }
            ++num_combined_elements;
        }

        // now sort the combined elements
        for ( int i =1; i < num_combined_elements; ++i ) {
            for ( int j = i; j > 0; --j ) {
                if (    combined_elements[j].y*aps_width + combined_elements[j].x
                     <  combined_elements[j-1].y*aps_width + combined_elements[j-1].x ) {
                    CombinedElement temp = combined_elements[j];
                    combined_elements[j] = combined_elements[j-1];
                    combined_elements[j-1] = temp;
                } else {
                    break;
                }
            }
        }
        assert( num_combined_elements == aps_order );

        // run a validity check
        int area = 0;
        for ( int i = 0; i < num_combined_elements; ++i ) {
            int size = combined_elements[i].size;
            int x = combined_elements[i].x;
            int y = combined_elements[i].y;
            area += size*size;
            assert( x >= 0 && y >= 0 && x <= aps_width && y <= aps_width );
            for ( int j = 0; j < num_combined_elements; ++j ) {
                int size2 = combined_elements[j].size;
                int x2 = combined_elements[j].x;
                int y2 = combined_elements[j].y;
                // verify no overlap
                assert( i==j || x >= x2+size2 || y >= y2+size2 || x+size <= x2 || y+size <= y2 );
            }
        }
        assert( area == aps_width*aps_width );

        // print the bcode
        int y_last = -1;
        printf( "%d %d %d (", aps_order, aps_width, aps_height );
        for ( int i =0; i < num_combined_elements; ++i ) {
            int y_next = combined_elements[i].y;
            if ( y_last == y_next ) 
                printf (",");
            else if ( y_last >= 0 )
                printf (")(");
            printf("%d", combined_elements[i].size );
            y_last = y_next;
        }
        printf(")\n");
    }
}







                
                        








