#ifndef MATRIX_H
#define MATRIX_H

#include "Types.h"

double gcd( double x, double y );

class Matrix {

    public:

    Matrix();
    Matrix(u32 n );
    Matrix( Matrix& m );
    Matrix& operator=( Matrix& m );
    Matrix( struct Graph &g );
    ~Matrix();

    double& select( u32 x, u32 y );
    double invert();
    double determinant();
    void   print();
    void   add_edge_ref(u32 n0, u32 n1);
    void   add_edge(u32 n0, u32 n1);
    double transfer_impedance(u32 n0, u32 n1, u32 n2, u32 n3);


    private:

    typedef double Data[32][32];
    Data* data;
    u32 size;
    enum MState { INIT, CHOL, INVERSE } mstate;
    double det;

    void chol();
    void inverse_chol();
    void chol2inverse();

};

#endif // MATRIX_H
