#ifndef BOUNDARY_H
#define BOUNDARY_H

// if we take a perfect square and fill in the components squares from
// a bouwkamp code, then when the square is partially filled, the boundary
// between the filled and unfilled portion will be a set of horizontal and
// vertical line segments.  This class defines that boundary.  Methods
// included both to add a square and make the corresponding change to the boundary
// and also to determine where the next square should be added.  The boundary
// is uniquely defined by a set of points which are the left ends of each of
// the horizontal segments.
class Boundary {
    struct {
        int x;
        int y;
    } points[100];

    int m_width;
    int m_height;
    int m_num_points;
    int m_filled_area;

public:

    void initialize( int width, int height );
    void add_square( int left, int right, int bottom, int top );
    void remove_square( int left, int right, int bottom, int top );
    void get_loc_lowest( int &x, int &y );
    void get_loc_well(  int &x, int &y, int &width );
    void check( );

};

#endif // BOUNDARY_H

