// #########################################################################################################
// # comptc2all - written by Lorenz Milla, Dossenheim, Germany, Version: 03/Nov/2013.                      #
// # reads in tablecode or Bouwkampcode, splits into several files, depending on the order.                #
// # requires one argument: the inputfilename.                                                             #
// # outputs one tablecode per line to inputfilename-(order).txt                                           #
// # feel free to modify!                                                                                  #
// #########################################################################################################

#include <stdio.h>
#include <string.h>
#include <time.h>

int main(int argc, char *argv[]) {
  double tm = clock();
  if(argc==1) { printf("usage: splitbyorder.exe input.txt\n"); return 0; } else {
    FILE* file = fopen(argv[1], "r");
		FILE *outfile;
		char outfilename[45];
		if (file==NULL) { printf("failed to open %s\n",argv[1]); return 0; } else {
			printf("Processing tablecode into different orders ...\n");
      char info[1024];
		  int i,n,count=0;
			int countbyorder[100];
			for(i=0;i<100;i++){countbyorder[i]=0;}
			int ordermin=100; int ordermax=0;
			while(fscanf(file,"%d",&n) != EOF) {
        fgets(info, sizeof(info), file);
				sprintf(outfilename,"%s-%d.txt",argv[1],n);
				outfile=fopen(outfilename, "a");
				fprintf(outfile,"%d%s",n,info);
				fclose(outfile);
				countbyorder[n]++; count++;
				if (n<ordermin) {ordermin=n;}
				if (n>ordermax) {ordermax=n;}
			}
			if (feof(file)) {
			  printf("%.3f seconds. %d tablecodes analyzed. End-of-File reached.\n",(clock()-tm)/1000,count);
				for(i=ordermin;i<=ordermax;i++) {
				  if (countbyorder[i]>0) {printf("order %d: %d tablecodes saved to %s-%d.txt\n",i,countbyorder[i],argv[1],i);}
				}
			} else { printf("End-of-File was not reached.\n"); }
			fclose(file);
    }
    return 0;
	}
}
