﻿// #########################################################################################################
// # comptc2canon - written by Lorenz Milla, Dossenheim, Germany, Version: 03/Nov/2013.                    #
// # reads in tablecode, looks for compound substructures, generates all isomers, outputs the canonical.   #
// # requires one argument: the inputfilename.                                                             #
// # outputs one tablecode per line to inputfilename-canon.txt,                                            #
// # where it adds a numbering in the end, counting through the different isomers.                         #
// # CPSS with too complex substructures can't be processed, are saved to inputfilename-canon-problem.txt  #
// # Up to order 30 it proved to work well with all the CPSS, but in higher orders it's incomplete         #
// # and I can't guarantee anything, because the different cases in the code grew a bit confusing.         #
// # feel free to modify!                                                                                  #
// #########################################################################################################

#include <stdio.h>
#include <string.h>
#include <time.h>

const int MO = 100; //maximum order of the squared squares to process

int main(int argc, char *argv[]) {
  int err,ok,fehlt,tmp,tmpp,summe;
  FILE *outfile;
	FILE *outfilebad;
  int i,j,k,x,y,z,ind,bad,noncanon=0;
  char info[1024];
  char outfilename[256];
	char outfilenamebad[256];
	int fl[512][MO],ft[512][MO],fr[512][MO],fb[512][MO]; // j-th element of the i-th isomer // max. 64*8 isomers!
  int l[MO],t[MO],r[MO],b[MO],tc[512][MO];
  int numsub;
  int L[100],T[100],R[100],B[100]; //maximum 100 subrectangles/subsquares ok!
  int cas,n,w,h,numflips;
 
  int neighbor(int a, int b) {
  	if((T[a]==T[b])&&(B[a]==B[b])&&((L[a]==L[b])||(R[a]==R[b]))) { return 1; }
		if((L[a]==L[b])&&(R[a]==R[b])&&((T[a]==T[b])||(B[a]==B[b]))) { return 2; }
		return 0;
	}
 
  int bigger(int a, int b) {
       //returns the index of the numerically bigger tablecode
       int ii,rr;
       rr=a;
       for(ii=n-1;ii>=0;ii--) {
        if(tc[b][ii]>tc[a][ii]) {rr=b; }
        if(tc[b][ii]<tc[a][ii]) {rr=a; }
       }
       return rr;
  }


  int allflips(int useflip, int sq, int pos) {
      // flips the sq-th dissection with the useflip-th subrectangle,
      // saves them to pos, pos+1, ... th position
       int zz=3;
       int ii,jj;
       if (R[useflip]-L[useflip]==B[useflip]-T[useflip]) {zz+=4;}

       for(ii=0;ii<n;ii++) { //create 4 or 8 isomers

         if((fl[sq][ii]>=L[useflip])&&(ft[sq][ii]>=T[useflip])&&(fr[sq][ii]<=R[useflip])&&(fb[sq][ii]<=B[useflip])) {

            fl[pos+0][ii]=L[useflip]+R[useflip]-fr[sq][ii]; //left-right-mirrored
            ft[pos+0][ii]=ft[sq][ii];
            fr[pos+0][ii]=L[useflip]+R[useflip]-fl[sq][ii];
            fb[pos+0][ii]=fb[sq][ii];

            fl[pos+1][ii]=fl[sq][ii];                         //top-bottom-mirrored
            ft[pos+1][ii]=T[useflip]+B[useflip]-fb[sq][ii];
            fr[pos+1][ii]=fr[sq][ii];
            fb[pos+1][ii]=T[useflip]+B[useflip]-ft[sq][ii];

            fl[pos+2][ii]=L[useflip]+R[useflip]-fr[sq][ii]; //lr&tb-mirrored
            ft[pos+2][ii]=T[useflip]+B[useflip]-fb[sq][ii];
            fr[pos+2][ii]=L[useflip]+R[useflip]-fl[sq][ii];
            fb[pos+2][ii]=T[useflip]+B[useflip]-ft[sq][ii];

            if (zz==7) {
              fl[pos+3][ii]=L[useflip]+(ft[sq][ii]-T[useflip]);   //original, 90 degrees rotated anticlockwise
              ft[pos+3][ii]=T[useflip]+(R[useflip]-fr[sq][ii]);
              fr[pos+3][ii]=R[useflip]-(B[useflip]-fb[sq][ii]);
              fb[pos+3][ii]=B[useflip]-(fl[sq][ii]-L[useflip]);

              fl[pos+4][ii]=L[useflip]+(ft[pos+0][ii]-T[useflip]);   //lr-mirrored, 90 degrees rotated anticlockwise
              ft[pos+4][ii]=T[useflip]+(R[useflip]-fr[pos+0][ii]);
              fr[pos+4][ii]=R[useflip]-(B[useflip]-fb[pos+0][ii]);
              fb[pos+4][ii]=B[useflip]-(fl[pos+0][ii]-L[useflip]);

              fl[pos+5][ii]=L[useflip]+(ft[pos+1][ii]-T[useflip]);   //tb-mirrored, 90 degrees rotated anticlockwise
              ft[pos+5][ii]=T[useflip]+(R[useflip]-fr[pos+1][ii]);
              fr[pos+5][ii]=R[useflip]-(B[useflip]-fb[pos+1][ii]);
              fb[pos+5][ii]=B[useflip]-(fl[pos+1][ii]-L[useflip]);

              fl[pos+6][ii]=L[useflip]+(ft[pos+2][ii]-T[useflip]);   //lr&tb-mirrored, 90 degrees rotated anticlockwise
              ft[pos+6][ii]=T[useflip]+(R[useflip]-fr[pos+2][ii]);
              fr[pos+6][ii]=R[useflip]-(B[useflip]-fb[pos+2][ii]);
              fb[pos+6][ii]=B[useflip]-(fl[pos+2][ii]-L[useflip]);

            }
            } else {
              for(jj=0;jj<zz;jj++) {
                fl[pos+jj][ii]=fl[sq][ii];
                ft[pos+jj][ii]=ft[sq][ii];
                fb[pos+jj][ii]=fb[sq][ii];
                fr[pos+jj][ii]=fr[sq][ii];
              }
            }
        }
        return zz;
  }

  int tbmirr(int useflip, int sq, int pos) {
      // flips the sq-th dissection with the useflip-th subrectangle, only top/bottom
      // saves them to pos-th position
      int ii;
      for(ii=0;ii<n;ii++) { //create 1 mirrored isomer
         if((fl[sq][ii]>=L[useflip])&&(ft[sq][ii]>=T[useflip])&&(fr[sq][ii]<=R[useflip])&&(fb[sq][ii]<=B[useflip])) {
            fl[pos][ii]=fl[sq][ii];                         //top-bottom-mirrored
            ft[pos][ii]=T[useflip]+B[useflip]-fb[sq][ii];
            fr[pos][ii]=fr[sq][ii];
            fb[pos][ii]=T[useflip]+B[useflip]-ft[sq][ii];
          } else {
                fl[pos][ii]=fl[sq][ii];
                ft[pos][ii]=ft[sq][ii];
                fb[pos][ii]=fb[sq][ii];
                fr[pos][ii]=fr[sq][ii];
          }
      }
      return 1;
  }


  int lrmirr(int useflip, int sq, int pos) {
      // flips the sq-th dissection with the useflip-th subrectangle, only left/right
      // saves them to pos-th position
      int ii;
      for(ii=0;ii<n;ii++) { //create 1 mirrored isomer
         if((fl[sq][ii]>=L[useflip])&&(ft[sq][ii]>=T[useflip])&&(fr[sq][ii]<=R[useflip])&&(fb[sq][ii]<=B[useflip])) {
            fl[pos+0][ii]=L[useflip]+R[useflip]-fr[sq][ii]; //left-right-mirrored
            ft[pos+0][ii]=ft[sq][ii];
            fr[pos+0][ii]=L[useflip]+R[useflip]-fl[sq][ii];
            fb[pos+0][ii]=fb[sq][ii];
          } else {
                fl[pos][ii]=fl[sq][ii];
                ft[pos][ii]=ft[sq][ii];
                fb[pos][ii]=fb[sq][ii];
                fr[pos][ii]=fr[sq][ii];
          }
      }
      return 1;
  }

  int diagmirr(int useflip, int sq, int pos) {
      // flips the sq-th dissection with the useflip-th subrectangle, only left/right
      // saves them to pos-th position
      int ii;
      for(ii=0;ii<n;ii++) { //create 1 mirrored isomer
         if((fl[sq][ii]>=L[useflip])&&(ft[sq][ii]>=T[useflip])&&(fr[sq][ii]<=R[useflip])&&(fb[sq][ii]<=B[useflip])) {
            fl[pos][ii]=ft[sq][ii];                         //top-bottom-mirrored
            ft[pos][ii]=fl[sq][ii];
            fr[pos][ii]=fb[sq][ii];
            fb[pos][ii]=fr[sq][ii];
          } else {
                fl[pos][ii]=fl[sq][ii];
                ft[pos][ii]=ft[sq][ii];
                fb[pos][ii]=fb[sq][ii];
                fr[pos][ii]=fr[sq][ii];
          }
      }
      return 1;
  }

  int PosStep[100];
  int WidthStep[100];
  int HeightStep[100];
	int tc2ltrb(int n, int w, int h, int *code, int *l, int *t, int *r, int *b) { // returns 1 if ok, and 0 if error.
		int NumStep;
		int i,a,s,tmp,mergeleft,mergeright;
		
		// initialize: one empty step
		NumStep=1;
		PosStep[0]=0;
		WidthStep[0]=w;
		HeightStep[0]=0;
		i=0;
		do {
			s=0; for (a=0;a<NumStep;a++) { if (HeightStep[a]<HeightStep[s]) { s=a; } }
			l[i]=PosStep[s]; t[i]=HeightStep[s]; r[i]=l[i]+code[i]; b[i]=t[i]+code[i];
			tmp=code[i]-WidthStep[s];
			if (tmp>0) { return 0; } //square doesn't fit into gap!
			else if (tmp==0) { // code[i] fills up the whole step[s]
				if ((s>0)&&(HeightStep[s]+code[i]==HeightStep[s-1])) { mergeleft=1; } else { mergeleft=0; }
				if ((s<NumStep-1)&&(HeightStep[s]+code[i]==HeightStep[s+1])) { mergeright=1; } else { mergeright=0; }
				if ((mergeleft==1)&&(mergeright==1)) { // step[s-1],step[s],step[s+1] form one new step
					NumStep=NumStep-2;
					WidthStep[s-1] += WidthStep[s]+WidthStep[s+1];
					for(a=s;a<NumStep;a++) {
						PosStep[a]=PosStep[a+2];
						WidthStep[a]=WidthStep[a+2];
						HeightStep[a]=HeightStep[a+2];
					}
				}
				if ((mergeleft==1)&&(mergeright==0)) {// step[s-1],step[s] form one new step
					NumStep=NumStep-1;
					WidthStep[s-1] += WidthStep[s];
					for(a=s;a<NumStep;a++) {
						PosStep[a]=PosStep[a+1];
						WidthStep[a]=WidthStep[a+1];
						HeightStep[a]=HeightStep[a+1];
					}
				}
				if ((mergeleft==0)&&(mergeright==1)) {// step[s],step[s+1] form one new step
					NumStep=NumStep-1;
					WidthStep[s] += WidthStep[s+1];
					HeightStep[s] += code[i];
					for(a=s+1;a<NumStep;a++) {
						PosStep[a]=PosStep[a+1];
						WidthStep[a]=WidthStep[a+1];
						HeightStep[a]=HeightStep[a+1];
					}
				}
				if ((mergeleft==0)&&(mergeright==0)) {// step[s] is being filled up further
					HeightStep[s] += code[i];
				}
			} else if (tmp<0) { //step[s] is only partly filled, starting from left
				if ((s>0)&&(HeightStep[s]+code[i]==HeightStep[s-1])) { mergeleft=1; } else { mergeleft=0; }
				if (mergeleft==1) { //step[s-1] grows wider, step[s] gets thinner
					WidthStep[s-1] += code[i];
					WidthStep[s] -= code[i];
					PosStep[s] += code[i];
				}
				if (mergeleft==0) { //step[s] is being cut into two steps (one new)
					NumStep++;
					for(a=NumStep-1;a>=s+2;a--) {
						PosStep[a]=PosStep[a-1];
						WidthStep[a]=WidthStep[a-1];
						HeightStep[a]=HeightStep[a-1];
					}
					PosStep[s+1]=PosStep[s]+code[i];
					WidthStep[s+1]=WidthStep[s]-code[i];
					HeightStep[s+1]=HeightStep[s];
					WidthStep[s]=code[i];
					HeightStep[s]+=code[i];      
				}
			}
			i++;
		} while (i<n);
		if ((NumStep==1)&&(HeightStep[0]==h)&&(PosStep[0]==0)&&(WidthStep[0]==w)) { return 1; } else { return 0; }
		// if only one step is left, and this fills the whole rectangle, then the ltrb code is correct.
	}

  double tm = clock();
  if(argc==1) { printf("usage: comptc2canon.exe input.txt\n"); return 0; } else {
    FILE* file = fopen(argv[1], "r");
		if (file==NULL) { printf("failed to open %s\n",argv[1]); return 0; } else {
			printf("Processing tablecode from %s...\n",argv[1]);
			ind=0;
			summe=0;
			sprintf(outfilename,"%s-canon.txt",argv[1]);
			outfile=fopen(outfilename, "w");
			sprintf(outfilenamebad,"%s-canon-problem.txt",argv[1]);
			outfilebad=fopen(outfilenamebad, "w");
			bad=0;
			while(fscanf(file,"%d",&n) != EOF) {
				ind++;


				//read in tablecode
				fscanf(file,"%d",&w);            // w = width of rectangle
				fscanf(file,"%d",&h);            // h = height of rectangle
				for(i=0;i<n;i++) { fscanf(file,"%d",&tc[0][i]); }
        fgets(info, sizeof(info), file);
				size_t ln = strlen(info) - 1;
				if (info[ln] == '\n') info[ln] = '\0';



				// create ltrb code
				i=tc2ltrb(n, w, h, &tc[0][0], l, t, r, b);
				if(i==0) {printf("error in line %d\n",ind);}
				
				
				//for(k=0;k<n;k++) {printf("%d: %d %d %d %d\n",tc[0][k],l[k],t[k],r[k],b[k]);}

				// find substructures
				numsub=0;
				for(i=0;i<n;i++) {
				 for(j=0;j<n;j++) {
					if((i!=j)&&(l[i]<=l[j])&&(t[i]<=t[j])&&((r[j]-l[i])*(b[j]-t[i])<w*h)) { // topleft:i, bottomright:j, not full square, not single square
					 err=0;
					 //left border?
							 fehlt=b[j]-b[i];
							 ok=1;
							 while ((fehlt>0)&&(err==0)&&(ok==1)) {
								ok=0;
								for(k=0;k<n;k++) {
								 if ((l[k]==l[i])&&(t[k]==b[j]-fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[0][k]; }
								}
							 }
							 if (fehlt!=0){err=1;}
					 //bottom border?
							 fehlt=l[j]-l[i];
							 ok=1;
							 while ((fehlt>0)&&(err==0)&&(ok==1)) {
								ok=0;
								for(k=0;k<n;k++) {
								 if ((b[k]==b[j])&&(r[k]==l[i]+fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[0][k]; }
								}
							 }
							 if (fehlt!=0){err=1;}
					 //right border?
							 fehlt=t[j]-t[i];
							 ok=1;
							 while ((fehlt>0)&&(err==0)&&(ok==1)) {
								ok=0;
								for(k=0;k<n;k++) {
								 if ((r[k]==r[j])&&(b[k]==t[i]+fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[0][k]; }
								}
							 }
							 if (fehlt!=0){err=1;}
					 //top border?
							 fehlt=r[j]-r[i];
							 ok=1;
							 while ((fehlt>0)&&(err==0)&&(ok==1)) {
								ok=0;
								for(k=0;k<n;k++) {
								 if ((t[k]==t[i])&&(l[k]==r[j]-fehlt)&&(fehlt>0)) { ok=1; fehlt-=tc[0][k]; }
								}
							 }
							 if (fehlt!=0){err=1;}
					 if(err==0) { //found subrectangle or subsquare from i to j
						L[numsub]=l[i];
						T[numsub]=t[i];
						R[numsub]=r[j];
						B[numsub]=b[j];
						numsub++;
					 }
					}
				 }
				}
			 L[numsub]=0; T[numsub]=0; R[numsub]=w; B[numsub]=h; // the whole square
				 
			 //sort subrectangles by area, ascending
			 int ar[numsub];
			 for(i=0;i<numsub;i++) {ar[i]=(R[i]-L[i])*(B[i]-T[i]);}
			 for(i=0;i<numsub-1;i++) {
				for(j=i+1;j<numsub;j++) {
				 if(ar[j]<ar[i]) {
					tmp=L[i]; L[i]=L[j]; L[j]=tmp;
					tmp=T[i]; T[i]=T[j]; T[j]=tmp;
					tmp=R[i]; R[i]=R[j]; R[j]=tmp;
					tmp=B[i]; B[i]=B[j]; B[j]=tmp;
					tmp=ar[i]; ar[i]=ar[j]; ar[j]=tmp;
				 }
				}
			 }

				 for(i=0;i<n;i++) { fl[0][i]=l[i]; ft[0][i]=t[i]; fr[0][i]=r[i]; fb[0][i]=b[i]; }
				 numflips=1;

				 cas=940;
				 if (numsub==1) { //easiest case: only one subrectangle, 4 isomers.
					 tmp=allflips(0,0,numflips); //flip around one rectangle
					 numflips+=tmp;
					 cas=10;
				 } else if (numsub==2) {
					 if ((L[0]==L[1])&&(R[0]==R[1])&&((T[0]==T[1])||(B[0]==B[1]))) { //0-th is extended to the top or bottom
								tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
								numflips+=tmp;
								tmp=0;
							 for(i=0;i<numflips;i++) {
								 tmp+=tbmirr(1,i,numflips+tmp); //mirror around second (larger) rectangle
							 }
							 numflips+=tmp;
							 cas=21;
					 } else if ((T[0]==T[1])&&(B[0]==B[1])&&((L[0]==L[1])||(R[0]==R[1]))) { //0-th is extended to the left or right
								tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
								numflips+=tmp;
								tmp=0;
							 for(i=0;i<numflips;i++) {
								 tmp+=lrmirr(1,i,numflips+tmp); //mirror around second (larger) rectangle
							 }
							 numflips+=tmp;
							 cas=22;
					 } else { 
							 x=0; // number of elements in 0-th rectangle not appearing in 1st
							 y=0; // number of elements in 0-th rectangle
							 j=0;
							 k=0;
							 for(i=0;i<n;i++) { 
								 j=0; k=0;
								 if((l[i]>=L[0])&&(t[i]>=T[0])&&(r[i]<=R[0])&&(b[i]<=B[0])) {j=1;}
								 if((l[i]>=L[1])&&(t[i]>=T[1])&&(r[i]<=R[1])&&(b[i]<=B[1])) {k=1;}
								 y+=j;
								 if((j==1)&&(k==0)) {x++;}
							 }
							 if (x==0) { //0-th is part of 1st
										 tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
										 numflips+=tmp;
										 tmp=0;
										 for(i=0;i<numflips;i++) {
											 tmp+=allflips(1,i,numflips+tmp); //flip around second (larger) rectangle
										 }
										 numflips+=tmp;
										 cas=23;
							 } else if (x==y) { //0-th and 1st are separate
										 tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
										 numflips+=tmp;
										 tmp=0;
										 for(i=0;i<numflips;i++) {
											 tmp+=allflips(1,i,numflips+tmp); //flip around second (larger) rectangle
										 }
										 numflips+=tmp;
										 cas=24;
							
							 } else { // two subrectangles, neither separate, nor one a part of the other - can not be processed!
										 cas=940; 
							 }
					 }
				
				
				 } else if (numsub==3) {
						// 0-1 neighbors
					 if ((L[0]==L[1])&&(R[0]==R[1])&&((T[0]==T[1])||(B[0]==B[1]))) { //0-th is extended to the top or bottom
								tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
								numflips+=tmp;
								tmp=0;
							 for(i=0;i<numflips;i++) {
								 tmp+=tbmirr(1,i,numflips+tmp); //mirror around second (larger) rectangle
							 }
							 numflips+=tmp;
							 cas=301;
					 } else if ((T[0]==T[1])&&(B[0]==B[1])&&((L[0]==L[1])||(R[0]==R[1]))) { //0-th is extended to the left or right
								tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
								numflips+=tmp;
								tmp=0;
							 for(i=0;i<numflips;i++) {
								 tmp+=lrmirr(1,i,numflips+tmp); //mirror around second (larger) rectangle
							 }
							 numflips+=tmp;
							 cas=301;
					 }
					
					 if (cas==301) { 
					 if ((L[1]==L[2])&&(R[1]==R[2])&&((T[1]==T[2])||(B[1]==B[2]))) { //1st is extended to the top or bottom
							 tmp=0;
							 for(i=0;i<numflips;i++) {
								 tmp+=tbmirr(2,i,numflips+tmp); //mirror around second (larger) rectangle
							 }
							 numflips+=tmp;
							 cas=322;
					 } else if ((T[1]==T[2])&&(B[1]==B[2])&&((L[1]==L[2])||(R[1]==R[2]))) { //1st is extended to the left or right
								tmp=0;
							 for(i=0;i<numflips;i++) {
								 tmp+=lrmirr(2,i,numflips+tmp); //mirror around second (larger) rectangle
							 }
							 numflips+=tmp;
							 cas=322;
					 } else {
							 x=0; // number of elements in 1st rectangle not appearing in 2nd
							 y=0; // number of elements in 1st rectangle
							 j=0;
							 k=0;
							 for(i=0;i<n;i++) { 
								 j=0; k=0;
								 if((l[i]>=L[1])&&(t[i]>=T[1])&&(r[i]<=R[1])&&(b[i]<=B[1])) {j=1;}
								 if((l[i]>=L[2])&&(t[i]>=T[2])&&(r[i]<=R[2])&&(b[i]<=B[2])) {k=1;}
								 y+=j;
								 if((j==1)&&(k==0)) {x++;}
							 }
							 if (x==0) { //1st is part of 2nd
										 tmp=0;
										 for(i=0;i<numflips;i++) {
											 tmp+=allflips(2,i,numflips+tmp); //flip around second (larger) rectangle
										 }
										 numflips+=tmp;
										 cas=305;
							 } else if (x==y) { //1st and 2nd are separate
										 tmp=0;
										 for(i=0;i<numflips;i++) {
											 tmp+=allflips(2,i,numflips+tmp); //flip around second (larger) rectangle
										 }
										 numflips+=tmp;
										 cas=306;
							
							 } else { // three subrectangles(0,1,2) - 0 and 1 are neighbors, but 1 and 2 are neither separate, nor one a part of the other - can not be processed!
										 cas=940; 
							 }
					 }
					}
					
					 // 0 and 2 neighbors
					 if ((L[0]==L[2])&&(R[0]==R[2])&&((T[0]==T[2])||(B[0]==B[2]))) { //0-th is extended to the top or bottom
								tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
								numflips+=tmp;
								tmp=0;
							 for(i=0;i<numflips;i++) {
								 tmp+=tbmirr(2,i,numflips+tmp); //mirror around second (larger) rectangle
							 }
							 numflips+=tmp;
							 cas=3021;
												
							 x=0; // number of elements in 1st rectangle not appearing in 2nd
							 y=0; // number of elements in 1st rectangle
							 j=0;
							 k=0;
							 for(i=0;i<n;i++) { 
								 j=0; k=0;
								 if((l[i]>=L[1])&&(t[i]>=T[1])&&(r[i]<=R[1])&&(b[i]<=B[1])) {j=1;}
								 if((l[i]>=L[2])&&(t[i]>=T[2])&&(r[i]<=R[2])&&(b[i]<=B[2])) {k=1;}
								 y+=j;
								 if((j==1)&&(k==0)) {x++;}
							 }
							 if ((x==y)||x==0) { //1st and 2nd are separate or a part of each other
										 tmp=0;
										 for(i=0;i<numflips;i++) {
											 tmp+=allflips(1,i,numflips+tmp); //flip around 1st (separate) rectangle
										 }
										 numflips+=tmp;
										cas=3001;
							 } 

					 } else if ((T[0]==T[2])&&(B[0]==B[2])&&((L[0]==L[2])||(R[0]==R[2]))) { //0-th is extended to the left or right
								tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
								numflips+=tmp;
								tmp=0;
							 for(i=0;i<numflips;i++) {
								 tmp+=lrmirr(2,i,numflips+tmp); //mirror around second (larger) rectangle
							 }
							 numflips+=tmp;
							 cas=3021;
							
							 x=0; // number of elements in 1st rectangle not appearing in 2nd
							 y=0; // number of elements in 1st rectangle
							 j=0;
							 k=0;
							 for(i=0;i<n;i++) { 
								 j=0; k=0;
								 if((l[i]>=L[1])&&(t[i]>=T[1])&&(r[i]<=R[1])&&(b[i]<=B[1])) {j=1;}
								 if((l[i]>=L[2])&&(t[i]>=T[2])&&(r[i]<=R[2])&&(b[i]<=B[2])) {k=1;}
								 y+=j;
								 if((j==1)&&(k==0)) {x++;}
							 }
							 
							 if ((x==y)||(x==0)) { //1st and 2nd are separate
										 tmp=0;
										 for(i=0;i<numflips;i++) {
											 tmp+=allflips(1,i,numflips+tmp); //flip around 1st (separate) rectangle
										 }
										 numflips+=tmp;
										cas=3002;
							 }
							
					 }
					 if (cas==3021) {// three subrectangles(0,1,2) - 0 and 2 are neighbors, but 1 and 2 are neither separate, nor one a part of the other - can not be processed!
							cas=940;
					 }
					
				
				 } else if (numsub==4) {
						if ((L[0]==L[1])&&(R[0]==R[1])&&((T[0]==T[1])||(B[0]==B[1]))) {
							if ((T[1]==T[2])&&(B[1]==B[2])&&((L[1]==L[2])||(R[1]==R[2]))) {
								if ((L[2]==L[3])&&(R[2]==R[3])&&((T[2]==T[3])||(B[2]==B[3]))) {
									tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
									numflips+=tmp;
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=tbmirr(1,i,numflips+tmp); 
									}
									numflips+=tmp;

									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=lrmirr(2,i,numflips+tmp); 
									}
									numflips+=tmp;

									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=tbmirr(3,i,numflips+tmp); 
									}
									numflips+=tmp;
									
									cas=401;
								} else {
									//zähle schnittmenge
									x=0; // number of elements in 2nd rectangle not appearing in 3rd
									y=0; // number of elements in 2nd rectangle
									j=0;
									k=0;
									for(i=0;i<n;i++) { 
										j=0; k=0;
										if((l[i]>=L[2])&&(t[i]>=T[2])&&(r[i]<=R[2])&&(b[i]<=B[2])) {j=1;}
										if((l[i]>=L[3])&&(t[i]>=T[3])&&(r[i]<=R[3])&&(b[i]<=B[3])) {k=1;}
										y+=j;
										if((j==1)&&(k==0)) {x++;}
									}

									if((x==0)||(x==y)) {
									cas=403;
									tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
									numflips+=tmp;
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=tbmirr(1,i,numflips+tmp); 
									}
									numflips+=tmp;

									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=lrmirr(2,i,numflips+tmp); 
									}
									numflips+=tmp;
									
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=allflips(3,i,numflips+tmp); 
									}
									numflips+=tmp;
									}
								}
							}
						}
						if ((T[0]==T[1])&&(B[0]==B[1])&&((L[0]==L[1])||(R[0]==R[1]))) {
							if ((L[1]==L[2])&&(R[1]==R[2])&&((T[1]==T[2])||(B[1]==B[2]))) {
								if ((T[2]==T[3])&&(B[2]==B[3])&&((L[2]==L[3])||(R[2]==R[3]))) {
									tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
									numflips+=tmp;
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=lrmirr(1,i,numflips+tmp); 
									}
									numflips+=tmp;

									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=tbmirr(2,i,numflips+tmp); 
									}
									numflips+=tmp;

									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=lrmirr(3,i,numflips+tmp); 
									}
									numflips+=tmp;
									cas=402;
								} else {
									//zähle schnittmenge
									x=0; // number of elements in 2nd rectangle not appearing in 3rd
									y=0; // number of elements in 2nd rectangle
									j=0;
									k=0;
									for(i=0;i<n;i++) { 
										j=0; k=0;
										if((l[i]>=L[2])&&(t[i]>=T[2])&&(r[i]<=R[2])&&(b[i]<=B[2])) {j=1;}
										if((l[i]>=L[3])&&(t[i]>=T[3])&&(r[i]<=R[3])&&(b[i]<=B[3])) {k=1;}
										y+=j;
										if((j==1)&&(k==0)) {x++;}
									}

									if((x==0)||(x==y)) {
									cas=404;
									tmp=allflips(0,0,numflips); //flip around first (smaller) rectangle
									numflips+=tmp;
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=lrmirr(1,i,numflips+tmp); 
									}
									numflips+=tmp;

									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=tbmirr(2,i,numflips+tmp); 
									}
									numflips+=tmp;
									
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=allflips(3,i,numflips+tmp); 
									}
									numflips+=tmp;
									}
								}
							}
						}
						
						//case 4001-4004: 48 isomers per class, but hidden (numsub=4)		
						if((cas!=401)||(cas!=402)||(cas!=403)||(cas!=404)) {
						x=0;
						for(i=0;i<n;i++) {
							j=0; k=0;
							if((l[i]>=L[2])&&(t[i]>=T[2])&&(r[i]<=R[2])&&(b[i]<=B[2])) {j=1;}
							if((l[i]>=L[3])&&(t[i]>=T[3])&&(r[i]<=R[3])&&(b[i]<=B[3])) {k=1;}
							if(j+k==1) {x++;}
						}
						if(x==n) {
						if ((T[0]==T[2])&&(B[0]==B[2])&&((L[0]==L[2])||(R[0]==R[2]))) {
							if ((T[1]==T[3])&&(B[1]==B[3])&&((L[1]==L[3])||(R[1]==R[3]))) {
							 cas=4001;
							}
						}
						if ((T[0]==T[3])&&(B[0]==B[3])&&((L[0]==L[3])||(R[0]==R[3]))) {
							if ((T[1]==T[2])&&(B[1]==B[2])&&((L[1]==L[2])||(R[1]==R[2]))) {
							 cas=4002;
							}
						}
						if ((L[0]==L[2])&&(R[0]==R[2])&&((T[0]==T[2])||(B[0]==B[2]))) {
							if ((L[1]==L[3])&&(R[1]==R[3])&&((T[1]==T[3])||(B[1]==B[3]))) {
							 cas=4003;
							}
						}
						if ((L[0]==L[3])&&(R[0]==R[3])&&((T[0]==T[3])||(B[0]==B[3]))) {
							if ((L[1]==L[2])&&(R[1]==R[2])&&((T[1]==T[2])||(B[1]==B[2]))) {
							 cas=4004;
							}
						}
						}		
						}
								
						//case 940: other situations with 4 subrects.
				 } else if (numsub==5) {
						//case R<N^4: 5001 or 5002
						if ((neighbor(0,1)>=1)&&(neighbor(1,2)>=1)&&(neighbor(2,3)>=1)&&(neighbor(3,4)>=1)) {
							if (neighbor(0,1)==1) { cas=5001; 
							
									tmp=allflips(0,0,numflips); //flip around first (smallest) rectangle
									numflips+=tmp;
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=lrmirr(1,i,numflips+tmp); 
									}
									numflips+=tmp;

									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=tbmirr(2,i,numflips+tmp); 
									}
									numflips+=tmp;
									
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=lrmirr(3,i,numflips+tmp); 
									}
									numflips+=tmp;
							
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=tbmirr(4,i,numflips+tmp); 
									}
									numflips+=tmp;
							
							} else { cas=5002;
							
									tmp=allflips(0,0,numflips); //flip around first (smallest) rectangle
									numflips+=tmp;
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=tbmirr(1,i,numflips+tmp); 
									}
									numflips+=tmp;

									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=lrmirr(2,i,numflips+tmp); 
									}
									numflips+=tmp;
									
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=tbmirr(3,i,numflips+tmp); 
									}
									numflips+=tmp;
							
									tmp=0;
									for(i=0;i<numflips;i++) {
										tmp+=lrmirr(4,i,numflips+tmp); 
									}
									numflips+=tmp;
							
							}
						}
				 } else if (numsub==6) {
						//case 6001-6002: 48 isomers per class
						if ((T[0]==T[3])&&(B[0]==B[3])&&((L[0]==L[3])||(R[0]==R[3]))) {
							if ((T[1]==T[5])&&(B[1]==B[5])&&((L[1]==L[5])||(R[1]==R[5]))) {
								if ((L[0]==L[4])&&(R[0]==R[4])&&((T[0]==T[4])||(B[0]==B[4]))) {
									if ((L[1]==L[2])&&(R[1]==R[2])&&((T[1]==T[2])||(B[1]==B[2]))) {
									 cas=6001;
									}
								}
							}
						}
						if ((T[0]==T[3])&&(B[0]==B[3])&&((L[0]==L[3])||(R[0]==R[3]))) {
							if ((T[1]==T[4])&&(B[1]==B[4])&&((L[1]==L[4])||(R[1]==R[4]))) {
								if ((L[0]==L[5])&&(R[0]==R[5])&&((T[0]==T[5])||(B[0]==B[5]))) {
									if ((L[1]==L[2])&&(R[1]==R[2])&&((T[1]==T[2])||(B[1]==B[2]))) {
									 cas=6002;
									}
								}
							}
						}
						if ((T[0]==T[2])&&(B[0]==B[2])&&((L[0]==L[2])||(R[0]==R[2]))) {
							if ((T[1]==T[5])&&(B[1]==B[5])&&((L[1]==L[5])||(R[1]==R[5]))) {
								if ((L[0]==L[4])&&(R[0]==R[4])&&((T[0]==T[4])||(B[0]==B[4]))) {
									if ((L[1]==L[3])&&(R[1]==R[3])&&((T[1]==T[3])||(B[1]==B[3]))) {
									 cas=6003;
									}
								}
							}
						}
						if ((T[0]==T[2])&&(B[0]==B[2])&&((L[0]==L[2])||(R[0]==R[2]))) {
							if ((T[1]==T[4])&&(B[1]==B[4])&&((L[1]==L[4])||(R[1]==R[4]))) {
								if ((L[0]==L[5])&&(R[0]==R[5])&&((T[0]==T[5])||(B[0]==B[5]))) {
									if ((L[1]==L[3])&&(R[1]==R[3])&&((T[1]==T[3])||(B[1]==B[3]))) {
									 cas=6004;
									}
								}
							}
						}
						if ((T[1]==T[3])&&(B[1]==B[3])&&((L[1]==L[3])||(R[1]==R[3]))) {
							if ((T[0]==T[5])&&(B[0]==B[5])&&((L[0]==L[5])||(R[0]==R[5]))) {
								if ((L[1]==L[4])&&(R[1]==R[4])&&((T[1]==T[4])||(B[1]==B[4]))) {
									if ((L[0]==L[2])&&(R[0]==R[2])&&((T[0]==T[2])||(B[0]==B[2]))) {
									 cas=6005;
									}
								}
							}
						}
						if ((T[1]==T[3])&&(B[1]==B[3])&&((L[1]==L[3])||(R[1]==R[3]))) {
							if ((T[0]==T[4])&&(B[0]==B[4])&&((L[0]==L[4])||(R[0]==R[4]))) {
								if ((L[1]==L[5])&&(R[1]==R[5])&&((T[1]==T[5])||(B[1]==B[5]))) {
									if ((L[0]==L[2])&&(R[0]==R[2])&&((T[0]==T[2])||(B[0]==B[2]))) {
									 cas=6006;
									}
								}
							}
						}
						if ((T[1]==T[2])&&(B[1]==B[2])&&((L[1]==L[2])||(R[1]==R[2]))) {
							if ((T[0]==T[5])&&(B[0]==B[5])&&((L[0]==L[5])||(R[0]==R[5]))) {
								if ((L[1]==L[4])&&(R[1]==R[4])&&((T[1]==T[4])||(B[1]==B[4]))) {
									if ((L[0]==L[3])&&(R[0]==R[3])&&((T[0]==T[3])||(B[0]==B[3]))) {
									 cas=6007;
									}
								}
							}
						}
						if ((T[1]==T[2])&&(B[1]==B[2])&&((L[1]==L[2])||(R[1]==R[2]))) {
							if ((T[0]==T[4])&&(B[0]==B[4])&&((L[0]==L[4])||(R[0]==R[4]))) {
								if ((L[1]==L[5])&&(R[1]==R[5])&&((T[1]==T[5])||(B[1]==B[5]))) {
									if ((L[0]==L[3])&&(R[0]==R[3])&&((T[0]==T[3])||(B[0]==B[3]))) {
									 cas=6008;
									}
								}
							}
						}
						
						//case 940: other situations		
				 } else { //5 or more than 7 subrectangles
					 cas=940;
				 }
				
				if((cas==4001)||(cas==4002)||(cas==4003)||(cas==4004)||(cas==6001)||(cas==6002)||(cas==6003)||(cas==6004)||(cas==6005)||(cas==6006)||(cas==6007)||(cas==6008)) {
					//48 isomers
					tmp=allflips(0,0,numflips); //flip around first small rectangle
					numflips+=tmp;
					tmp=0;
					for(i=0;i<numflips;i++) {
						tmp+=allflips(1,i,numflips+tmp); //flip around second small rectangle
					}
					numflips+=tmp;
					tmp=0;
					for(i=0;i<numflips;i++) {
					 if((cas==4001)||(cas==4002)||(cas==6003)||(cas==6004)||(cas==6007)||(cas==6008)) {
						 tmp+=lrmirr(2,i,numflips+tmp);
					 }
					 if((cas==4003)||(cas==4004)||(cas==6001)||(cas==6002)||(cas==6005)||(cas==6006)) {
						 tmp+=tbmirr(2,i,numflips+tmp);
					 }
					}
					for(i=0;i<numflips;i++) {
						if((cas==6001)||(cas==6002)||(cas==6005)||(cas==6006)) {
							tmp+=lrmirr(3,i,numflips+tmp);
						} else if((cas==6003)||(cas==6004)||(cas==6007)||(cas==6008)) {
							tmp+=tbmirr(3,i,numflips+tmp);
						} else {
							if (cas==4003) { L[numsub+1]=0; T[numsub+1]=T[1]; R[numsub+1]=w;B[numsub+1]=B[1]; }
							if (cas==4004) { L[numsub+1]=0; T[numsub+1]=T[0]; R[numsub+1]=w;B[numsub+1]=B[0]; }
							if (cas==4001) { L[numsub+1]=L[1]; T[numsub+1]=0; R[numsub+1]=R[1];B[numsub+1]=h; }
							if (cas==4002) { L[numsub+1]=L[0]; T[numsub+1]=0; R[numsub+1]=R[0];B[numsub+1]=h; }
							
							for(i=16;i<32;i++) {
								if((cas==4003)||(cas==4004)) { tmp +=lrmirr(numsub+1,i,numflips+tmp); }
								if((cas==4002)||(cas==4001)) { tmp +=tbmirr(numsub+1,i,numflips+tmp); }
							}
						}
					}
					numflips+=tmp;
					
					//printf("%s: %d\n",id,cas);
				}
				
				if(numsub==0) {cas=0;} //simple, not compound.
				
				// printf("cas=%d\n",cas);
				// printf("numflips=%d\n",numflips);
				// printf("numsub=%d\n",numsub);
				
				
				
				 //flip the whole dissection
				 tmpp=0;
				 for(i=0;i<numflips;i++) { 
					 tmp=allflips(numsub,i,numflips+tmpp);
					 tmpp+=tmp; 
				 }
				 numflips += tmpp;
				
				 //first find all tablecodes
				 for(z=0;z<numflips;z++) {
					for(x=0;x<n;x++) {
						i=w*h*2;
						k=0;
						for(j=0;j<n;j++) {
							if (ft[z][j]*w+fl[z][j]<i) {
								i=ft[z][j]*w+fl[z][j];
								k=j;
							}
						}
						tc[z][x]=fb[z][k]-ft[z][k];
						ft[z][k]+=h; 
					}
				 }
				 //then find maximum tablecode (standard)
				 i=0;
				 for(j=1;j<numflips;j++) { //check j-th tablecode
					i=bigger(i,j);      
				 }
				 if((i>0)&&(cas!=940)){noncanon++;}
				 //the i-th isomer is the canonical now
				 //then sort the tablecodes descending
				
				 
				
				 if(cas!=940) {
					 fprintf(outfile,"%d %d %d",n,w,h);
					 for(j=0;j<n;j++) { 
						 fprintf(outfile," %d",tc[i][j]);
					 }
					 fprintf(outfile,"%s # %d.%d\n",info,ind,i+1);
					 summe+=numflips;
				 } else {
					fprintf(outfilebad,"%d %d %d",n,w,h);
					for(j=0;j<n;j++) { 
					 fprintf(outfilebad," %d",tc[0][j]);
					}
					fprintf(outfilebad,"%s # %d : numsub=%d : couldn't be analyzed.\n",info,ind,numsub);
					bad++;
				 }			
			} // while(fscanf(file,"%d",&n) != EOF)
			if (feof(file)) {
				printf("End of file %s reached after %.3f seconds.\n",argv[1],(clock()-tm)/1000);
				printf("%d lines of tablecode analyzed.\n",ind);
				printf("%d could be processed and were saved to %s.\n",ind-bad,outfilename);
				printf("%d of those saved to %s haven't been canonical before.\n",noncanon,outfilename);
				printf("%d could not be processed and were saved to %s.\n",bad,outfilenamebad);
			} else { printf("End-of-File was not reached.\n"); }
			fclose(outfile);
			fclose(outfilebad);
			fclose(file);
    }
    return 0;
	}
}

