// author Stuart Errol Anderson;
// March 6, 2013
// stuart.errol.anderson@gmail.com
//  tc2bkp
//  tablecode to bouwkampcode converter
#include <vector>
#include <iterator>
#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <iomanip>
#include <algorithm>
#include <cmath>
#include <cstring>
#include <cstdlib>
#include <exception>
#include <sys/time.h>
double get_time(){
	    struct timeval t;
	    gettimeofday(&t, NULL);
	    double d = t.tv_sec + (double) t.tv_usec/1000000;
	    return d;
	}
int main (int argc, char* argv[]){
	//create an ifstream infile
	double time_start = get_time();
	std::ifstream infile;
	//open ifstream infile
	infile.open(argv[1]);
	if(infile.fail())
 	{
		if (argc == 1) {
			std::cout<<"tc2bkp changes tablecodes into bouwkampcodes."<<std::endl;
			std::cout<<"The format for running the program is;"<<std::endl;
			std::cout<<"usage: tc2bkp filename  "<<std::endl;
			std::cout<<"output is ;  filename+'.bkp'"<<std::endl;
			std::cout<<"Author; Stuart Anderson ; email: stuart.errol.anderson@gmail.com"<<std::endl;
			std::cout<<"This version; March 6, 2013"<<std::endl;		
			exit(0);
		}
		else {
            std::cout<<"error; file "<<argv[1]<<" failed to load"<<std::endl;
	       	exit(0);
		}
	}
	std::cout<<"Processing tablecode into bouwkampcode ..."<<std::endl;
	//create a stringstream, strings for lines and values
	std::istringstream stream;
	std::istringstream ss;
	std::stringstream oss;
	std::string line;
	std::string lineend;
	std::string value;
	std::ofstream bkp_file;	// create ofstream  bouwkampcode file
	std::vector<int> Top ;
	std::vector<int> Bottom ;
	std::vector<int> Left;
	std::vector<int> Right ;
	std::vector<int> Size ;
	std::vector<int> Boundary ;
	int j=1;
	int Order = 0;
	int BoundaryWidth = 0;
	int RectWidth = 0;
	int RectHeight = 0;	
	int MaxInt = 1000000000;
	int element = 0;
	int v = -1 ; 
   int bkpcount = 0;
  std::string bkpcode = "";
	while ( std::getline(infile, line, '\n' ) &&(line.length()>1)) { // extract lines
		 std::istringstream ins; // Declare an input string stream.
  		 size_t found;
  		 std::string linebk;
  		 lineend ="";
  		 found=line.find("*");
  		 if (found != std::string::npos) {
              linebk = line.substr(0,found-1); // separate the bouwkampcode from the extended fields if they exist
              lineend = line.substr(found+1);
         } else {
        	  linebk = line;
        }
		v = 0;
		bool startrow = true;
		int s = 0;
		int startx = 0 ;
		int starty = 0 ;
		stream.clear();
		stream.str(linebk); 
		while ( stream >> value  ) 	{ // get values in columns
			if ((s <= 2)&&(j == 1)) {
				if (s == 0) { 
					std::istringstream ss(value);
					ss >> Order ;//1st value is order
					ss.str("");
					int bksize = Order + 4;
		 			Top.reserve(bksize) ;
		 			Bottom.reserve(bksize) ;
		 			Left.reserve(bksize);
		 			Right.reserve(bksize) ;
		 			Size.reserve(bksize) ;
		 			Boundary.reserve(bksize) ;
		 			Size.push_back(Order);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
				}
	  			if (s == 1) {
		  			std::istringstream	ss(value);
		  			ss >> RectWidth ;//2nd value is width
		  			BoundaryWidth = RectWidth;
		  			Size.push_back(RectWidth);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
		  			ss.str("");
	  			}
				if (s == 2) {
					std::istringstream	ss(value);
					ss >> RectHeight ;//3rd value is height
	  				Size.push_back(RectHeight);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
					ss.str("");
				}
			} else {
				std::istringstream ss(value);
				 ss >> element;
				 ss.str("");
				Size.push_back(element);
			}
			s++;
		}

		// Place the squares ;  starting at top left, position successive squares from left to right in rows
		// the first row is the top edge of the tiling, successive rows descend in order of height.
		// If 2 (or more) rows have the same height, the leftmost one(s) come first.
		int l = 0; int n = 0;  
		oss << Order;
		bkpcode = oss.str();	
		oss.str("");
	    oss << RectWidth;	
		bkpcode = bkpcode + " " + oss.str();
		oss.str("");
	    oss << RectHeight;	
		bkpcode = bkpcode + " " + oss.str() + " ";	
		oss.str("");
	    for (unsigned int j = 3; j <  Size.size(); j++){	
			if (startrow == true) {		
			    bkpcode += "(";	
				Left.push_back(startx);		
				startrow = false;	
			} else {
			    bkpcode += ",";
				Left.push_back(Left.at(j-1) + Size.at(j-1));
			}
			Right.push_back(Left[j] + Size[j]);
			Top.push_back(starty);
			Bottom.push_back(Top[j] + Size[j]);
			Boundary.push_back(j);
            oss << Size[j];
			bkpcode = bkpcode + oss.str();	
			oss.str("");		
			for (unsigned int k = 0; k < j; k++) { // remove (make negative) old bottom square(s) from boundary list when covered by new one
			    l=Boundary[k];
				if (l>0){  
					if ((Top[j] == Bottom[l])&&(Left[j]<=Left[l])&&(Left[l]<=Right[j])) {
						BoundaryWidth = BoundaryWidth+Size[k];
						Boundary.at(k) = -Boundary[k];
					}
				}
			}
			if ((Right.at(j)-startx-BoundaryWidth) == 0){
			    bkpcode = bkpcode+")";
				startrow = true;
				v++;
				BoundaryWidth = 0;
				startx=MaxInt; //start 
  				starty=MaxInt;
				for (unsigned int m=3; m <= j; m++){ // find minimum Boundary Bottom (starty) and Left (startx)
					n = Boundary[m];
					if ((n>0)&&(Bottom[n] < starty)){
						starty = Bottom[n];
						startx = Left[n];
					} else if ((n > 0)&&(Bottom[n] == starty)){
						if (startx > Left[n]){
							startx = Left[n];	
						}
					}
				}
			} else {
				startrow = false;	
			}
		} 

 		Size.push_back(Size.at(1));
 		Top.push_back(0);
 		Left.push_back(0);
 		Right.push_back(Size.at(1));
 		Bottom.push_back(Size.at(1));
		Top.clear() ;
		Bottom.clear() ;
		Left.clear();
		Right.clear() ;
		Size.clear() ;
		Boundary.clear() ;
		std::ostringstream ous;
		ous <<argv[1]<<".bkp";
		bkp_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
		if (!bkp_file) // check it opened ok
		{
			std::cerr << "Cannot open file " << ous.str() << " for output.\n"; 
		}
		if (lineend.length()>0) {
			bkp_file << bkpcode <<" *"<<lineend<< std::endl;
		} else {
			bkp_file << bkpcode << std::endl;;
		}
		bkpcode = "";
		bkp_file.close();	
		bkpcount++;		
	}  infile.close();   
	std::cout<<bkpcount<<" tablecodes from "<<argv[1]<<" processed;"<<std::endl;
	if (bkpcount != 0) std::cout<<bkpcount<<" bouwkampcodes saved to "<<argv[1]<<".bkp"<<std::endl;
	double time_end = get_time();
	std::cout.precision(5);
	std::cout<<"This program has run for: "<< time_end - time_start<< " seconds."<<std::endl;
  return 0;
}// end function
