// author Stuart Errol Anderson;
// March 4, 2012
// stuart.errol.anderson@gmail.com
//  bk2x
//  bouwkampcode cross detection and save
#include <vector>
#include <iterator>
#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <iomanip>
#include <utility>
#include <algorithm>
#include <cmath>
#include <cstring>
#include <cstdlib>
#include <exception>
#include <sys/time.h>
double get_time(){
	    struct timeval t;
	    gettimeofday(&t, NULL);
	    double d = t.tv_sec + (double) t.tv_usec/1000000;
	    return d;
	}
int main (int argc, char* argv[]){
	//create an ifstream infile
	double time_start = get_time();
	std::ifstream infile;
	//open ifstream infile
	infile.open(argv[1]);
	if(infile.fail())
 	{
		if (argc == 1) {
			std::cout<<" bk2x (bouwkampcode to cross) is an application"<<std::endl;
			std::cout<<" designed to detect crosses in a bouwkampcode file."<<std::endl;
			std::cout<<" usage; bk2x filename"<<std::endl;
			std::cout<<" author Stuart Errol Anderson;"<<std::endl;
			std::cout<<" March 4, 2012"<<std::endl;
			std::cout<<" stuart.errol.anderson@gmail.com"<<std::endl;
		}
		else {
            std::cout<<" error; file "<<argv[1]<<" failed to load"<<std::endl;
	       	exit(0);
		}
		exit(0);
	}
	std::cout<<" Processing bouwkampcode for crosses..."<<std::endl;
	//create a stringstream, strings for lines and values
	std::istringstream stream;
	std::istringstream ss;
	std::string line;
	std::string value;
	std::ofstream bkx_file;	// create ofstream crossed tiling bouwkampcode output file
	std::vector<int> Top ;
	std::vector<int> Bottom ;
	std::vector<int> Left;
	std::vector<int> Right ;
	std::vector<int> Size ;
	std::vector<int> Boundary ;
	int j=1;
	int counter = 0;
	int Order = 0;
	int BoundaryWidth = 0;
	int RectWidth = 0;
	int RectHeight = 0;	
	int MaxInt = 1000000000;
	int element = 0;
   	int linecount = 0;
	while (( std::getline(infile, line, '\n' ) ) &&(line.length()>1)){ // extract lines
  		 size_t found;
  		 std::string linebk;
  		 std::string lineend;
  		 found=line.find("*");
  		 if (found != std::string::npos) {
              linebk = line.substr(0,found-1); // separate the bouwkampcode from the extended fields if they exist
              lineend = line.substr(found+1);
         } else {
        	  linebk = line;
        }
  		//if bouwkampcode convert to tablecode by deleting parentheses and commas and replacing with whitespace
		replace( linebk.begin(), linebk.end(), ',', ' ' );
		replace( linebk.begin(), linebk.end(), '(', ' ' );
		replace( linebk.begin(), linebk.end(), ')', ' ' );
		std::string newline;
  		newline += linebk;
		stream.clear();
		stream.str(newline); 
		linecount ++;
		bool startrow = true;
		int s = 0;
		int startx = 0 ;
		int starty = 0 ;
		while ( stream >> value  ) 	{ // get values in columns
			if ((s <= 2)&&(j == 1)) {
				if (s == 0) { 
					std::istringstream ss(value);
					ss >> Order ;//1st value is order
					ss.str("");
					int bksize = Order + 4;
		 			Top.reserve(bksize) ;
		 			Bottom.reserve(bksize) ;
		 			Left.reserve(bksize);
		 			Right.reserve(bksize) ;
		 			Size.reserve(bksize) ;
		 			Boundary.reserve(bksize) ;
		 			Size.push_back(Order);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
				}
	  			if (s == 1) {
		  			std::istringstream	ss(value);
		  			ss >> RectWidth ;//2nd value is width
		  			BoundaryWidth = RectWidth;
		  			Size.push_back(RectWidth);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
		  			ss.str("");
	  			}
				if (s == 2) {
					std::istringstream	ss(value);
					ss >> RectHeight ;//3rd value is height
	  				Size.push_back(RectHeight);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
					ss.str("");
				} //line 118
			} else {
				std::istringstream ss(value);
				 ss >> element;
				 ss.str("");
				Size.push_back(element);
			} //line 131
			s++;
		} //line 80
		// Place the squares ;  starting at top left, position successive squares from left to right in rows
		// the first row is the top edge of the tiling, successive rows descend in order of height.
		// If 2 (or more) rows have the same height, the leftmost one(s) come first.
		int l = 0; int n = 0;  
	    for (unsigned int j = 3; j <  Size.size(); j++){	
			if (startrow == true) {							
				Left.push_back(startx);			
				startrow = false;	
			} else {
				Left.push_back(Left.at(j-1) + Size.at(j-1));
			}
			Right.push_back(Left[j] + Size[j]);
			Top.push_back(starty);
			Bottom.push_back(Top[j] + Size[j]);
			Boundary.push_back(j);
			for (unsigned int k = 0; k < j; k++) { // remove (make negative) old bottom square(s) from boundary list when covered by new one
			    l=Boundary[k];
				if (l>0){  
					if ((Top[j] == Bottom[l])&&(Left[j]<=Left[l])&&(Left[l]<=Right[j])) {
						BoundaryWidth = BoundaryWidth+Size[k];
						Boundary.at(k) = -Boundary[k];
					}
				}
			}
			if ((Right.at(j)-startx-BoundaryWidth) == 0){
				startrow = true;
				BoundaryWidth = 0;
				startx=MaxInt; //start 
  				starty=MaxInt;
				for (unsigned int m=3; m <= j; m++){ // find minimum Boundary Bottom (starty) and Left (startx)
					n = Boundary[m];
					if ((n>0)&&(Bottom[n] < starty)){
						starty = Bottom[n];
						startx = Left[n];
					} else if ((n > 0)&&(Bottom[n] == starty)){
						if (startx > Left[n]){
							startx = Left[n];	
						}
					}
				}
			} else {
				startrow = false;	
			}
		} 
 		Size.push_back(Size.at(1));
 		Top.push_back(0);
 		Left.push_back(0);
 		Right.push_back(Size.at(1));
 		Bottom.push_back(Size.at(1));
 		  std::vector <std::pair <int,int> > corners;
 		  std::vector <std::pair <int,int> > uniq_corners;
 		  for (unsigned int j = 3; j < Size.size(); j++){	
 		  		// top left corner
 		  		corners.push_back(std::make_pair(Top[j],Left[j]));
 		  		// top right corner
 		  		corners.push_back(std::make_pair(Top[j], Right[j]));
 		  		// bottom right corner
 		  		corners.push_back(std::make_pair(Bottom[j], Left[j]));
 		  		// bottom left corner
 		  		corners.push_back(std::make_pair(Bottom[j], Right[j]));
 		  }
 		std::vector <std::pair <int,int> >::iterator it;
 		std::sort (corners.begin(), corners.end());
  		std::unique_copy(corners.begin(), corners.end(), std::back_inserter( uniq_corners )) ;
		bool bkx = false;
		// count the number of duplicate corners, if 4, 4 corners meet at a point, ie a cross exists
 		for (unsigned int j = 0; j < uniq_corners.size(); j++){	
 				if ( (int) count (corners.begin(), corners.end(), uniq_corners[j]) == 4 ) 	bkx = true;
 		}
 		if (bkx == true ) {
 				std::ostringstream ous;
				ous <<argv[1]<<".bkx";
				bkx_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
				if (!bkx_file) // check it opened ok
				{
						std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
				}
				bkx_file << line << std::endl;
				std::cout<<" crossed "<<line<<std::endl;
				counter++;
				bkx_file.close();
				ous.clear();
		}
		 Top.clear() ;
		 Bottom.clear() ;
		 Left.clear();
		 Right.clear() ;
		 Size.clear() ;
		 Boundary.clear() ;
	} 
	 infile.close();  
	double time_end = get_time();
	std::cout.precision(5);
	if (linecount > 0) std::cout<<" "<<linecount <<" bouwkampcode(s from file "<<argv[1]<<" processed."<<std::endl;
	if (counter > 0) {
		std::cout<<" "<<counter<<" tilings with cross(es) saved to "<<argv[1]<<".bkx"<<std::endl;
	} else {
		std::cout<<" no tilings with cross(es) found in file "<<argv[1]<<std::endl;;
	}
	std::cout<<" This program has run for: "<< time_end - time_start<< " seconds."<<std::endl;
  return 0;
}// end function
