// bk2sss
// bouwkampcode  to squared squares squared
// c++ code Stuart Errol Anderson;
// postscript code sqile.ps by Stijn van Dongen.
// http://micans.org/stijn/ps/index.html#sqile"
// March 4, 2012
// stuart.errol.anderson@gmail.com
#include <vector>
#include <iterator>
#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <iomanip>
#include <algorithm>
#include <cmath>
#include <cstring>
#include <cstdlib>
#include <exception>
#include <sys/time.h>
double get_time(){
	    struct timeval t;
	    gettimeofday(&t, NULL);
	    double d = t.tv_sec + (double) t.tv_usec/1000000;
	    return d;
	}
int main (int argc, char* argv[]){
	//create an ifstream infile

	double time_start = get_time();
	std::ifstream infile;
	//open ifstream infile
	infile.open(argv[1]);
	if(infile.fail())
 	{
		if (argc == 1) {
			std::cout<<" bk2sss (bouwkampcode to squared squares squared) is an application"<<std::endl;
			std::cout<<" designed to take a squared square bouwkampcode file and produce "<<std::endl;
			std::cout<<" 'fractal' squared squares using Stijn van Dongen's sqile.ps as the"<<std::endl;
			std::cout<<" postscript engine."<<std::endl;
			std::cout<<" http://micans.org/stijn/ps/index.html#sqile"<<std::endl;
			std::cout<<" usage; bk2sss filename"<<std::endl;
			std::cout<<" author Stuart Errol Anderson;"<<std::endl;
			std::cout<<" March 4, 2012"<<std::endl;
			std::cout<<" stuart.errol.anderson@gmail.com"<<std::endl;
			
		}
		else {
            std::cout<<" error; file "<<argv[1]<<" failed to load"<<std::endl;
	       	exit(0);
		}
		exit(0);
	}
	std::cout<<" Processing bouwkampcode for squared squares squared ..."<<std::endl;
	//create a stringstream, strings for lines and values
	std::istringstream stream;
	std::istringstream ss;
	std::string line;
	std::string value;
	std::ofstream ps_file;	// create ofstream postscript bouwkampcode
	std::vector<int> Top ;
	std::vector<int> Bottom ;
	std::vector<int> Left;
	std::vector<int> Right ;
	std::vector<int> Size ;
	std::vector<int> Boundary ;

	int j=1;
	int Order = 0;
	int BoundaryWidth = 0;
	int RectWidth = 0;
	int RectHeight = 0;	
	int MaxInt = 1000000000;
	int element = 0;
    int linecount = 0;
	while (( std::getline(infile, line, '\n' ) ) &&(line.length()>1)){ // extract lines
  		 size_t found;
  		 std::string linebk;
  		 std::string lineend;
  		 found=line.find("*");
  		 if (found != std::string::npos) {
              linebk = line.substr(0,found-1); // separate the bouwkampcode from the extended fields if they exist
              lineend = line.substr(found+1);
         } else {
        	  linebk = line;
        }
  		//if bouwkampcode convert to tablecode by deleting parentheses and commas and replacing with whitespace
		replace( linebk.begin(), linebk.end(), ',', ' ' );
		replace( linebk.begin(), linebk.end(), '(', ' ' );
		replace( linebk.begin(), linebk.end(), ')', ' ' );
		std::string newline;
  		newline += linebk;
		stream.clear();
		stream.str(newline); 
		linecount ++;
		bool startrow = true;
		int s = 0;
		int startx = 0 ;
		int starty = 0 ;	
		while ( stream >> value  ) 	{ // get values in columns
			if ((s <= 2)&&(j == 1)) {
				if (s == 0) { 
					std::istringstream ss(value);
					ss >> Order ;//1st value is order
					ss.str("");
					int bksize = Order + 4;
		 			Top.reserve(bksize) ;
		 			Bottom.reserve(bksize) ;
		 			Left.reserve(bksize);
		 			Right.reserve(bksize) ;
		 			Size.reserve(bksize) ;
		 			Boundary.reserve(bksize) ;
		 			Size.push_back(Order);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
				}
	  			if (s == 1) {
		  			std::istringstream	ss(value);
		  			ss >> RectWidth ;//2nd value is width
		  			BoundaryWidth = RectWidth;
		  			Size.push_back(RectWidth);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
		  			ss.str("");
	  			}
				if (s == 2) {
					std::istringstream	ss(value);
					ss >> RectHeight ;//3rd value is height
	  				Size.push_back(RectHeight);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
					ss.str("");
				} 
			} else {
				std::istringstream ss(value);
				 ss >> element;
				 ss.str("");
				Size.push_back(element);
			} 
			s++;
		} 
	
		// Place the squares ;  starting at top left, position successive squares from left to right in rows
		// the first row is the top edge of the tiling, successive rows descend in order of height.
		// If 2 (or more) rows have the same height, the leftmost one(s) come first.
		
		int l = 0; int n = 0;  
	    for (unsigned int j = 3; j <  Size.size(); j++){	
			if (startrow == true) {							
				Left.push_back(startx);			
				startrow = false;	
			} else {
				Left.push_back(Left.at(j-1) + Size.at(j-1));
			}
			Right.push_back(Left[j] + Size[j]);
			Top.push_back(starty);
			Bottom.push_back(Top[j] + Size[j]);
			Boundary.push_back(j);
			for (unsigned int k = 0; k < j; k++) { // remove (make negative) old bottom square(s) from boundary list when covered by new one
			    l=Boundary[k];
				if (l>0){  
					if ((Top[j] == Bottom[l])&&(Left[j]<=Left[l])&&(Left[l]<=Right[j])) {
						BoundaryWidth = BoundaryWidth+Size[k];
						Boundary.at(k) = -Boundary[k];
					}
				}
			}
			if ((Right.at(j)-startx-BoundaryWidth) == 0){
				startrow = true;
				BoundaryWidth = 0;
				startx=MaxInt; //start 
  				starty=MaxInt;
				for (unsigned int m=3; m <= j; m++){ // find minimum Boundary Bottom (starty) and Left (startx)
					n = Boundary[m];
					if ((n>0)&&(Bottom[n] < starty)){
						starty = Bottom[n];
						startx = Left[n];
					} else if ((n > 0)&&(Bottom[n] == starty)){
						if (startx > Left[n]){
							startx = Left[n];	
						}
					}
				}
			} else {
				startrow = false;	
			}
		} 
 		
 		Size.push_back(Size.at(1));
 		Top.push_back(0);
 		Left.push_back(0);
 		Right.push_back(Size.at(1));
 		Bottom.push_back(Size.at(1));
		std::string psheader;
		std::string psfooter;
		psheader = "%!PS-3.0\n";
		psheader += "% postscript code from sqile.ps by Stijn van Dongen.\n";
		psheader += "% http://micans.org/stijn/ps/index.html#sqile\n";
		psheader += "% bouwkampcodes by Stuart Anderson,\n";
		psheader += "% http://www.squaring.net\n";
		psheader += "%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
		psheader += "% options\n";
		psheader += "/depth   2      def    % set to 0, 1, 2, 3, 4.\n";
		psheader += "/rvideo  0       def    % set to 1 or 0 (bool)\n";
		psheader += "/angle   0      def\n";
		psheader += "/gray    10      def    % set to 0, 1, .. 100.\n";
		psheader += "%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
		psheader += "/thre    2       def  \n";
		psheader += "rvideo 0 eq { /rv false def\n";
		psheader += "} { /rv true def\n";
		psheader += "} ifelse\n";
		psheader += "/graytone gray 100.0 div def\n";
		psheader += "%     ctrx ctry radius\n";
		psheader += "/sq\n";
		psheader += "{  /rad exch def\n";
		psheader += "   gsave\n";
		psheader += "   translate\n";
		psheader += "   newpath\n";
		psheader += "   rad -1 mul rad -1 mul moveto\n";
		psheader += "   rad 2 mul 0 rlineto\n";
		psheader += "   0 rad 2 mul rlineto\n";
		psheader += "   rad -2 mul 0 rlineto\n";
		psheader += "   closepath\n";
		psheader += "   dostroke { stroke } { fill } ifelse\n";
		psheader += "   grestore\n";
		psheader += "} def\n";
		psheader += "30 30 translate\n";		
 	    std::ostringstream ous;
 	    ous<<"/size "<<Size.at(1)<<" def\n";
 	    ous<<"262 size div dup scale\n";
		ous<<"/squares [\n";
	     for (unsigned int j = 3; j < Size.size()-1; ++j){	
			Left.at(j) = -2*Left.at(j) - Size.at(j) + Size.at(1);
			Top.at(j) = -2*(Size.at(2)-Top.at(j))  + Size.at(j) + Size.at(2);
			ous<<"["<< Left.at(j) <<" "<< Top.at(j) <<" "<< Size.at(j)<<"]"<<std::endl;
	    }
		psheader+= ous.str();
		psfooter = "		] def\n";
		psfooter += "/cmtx matrix def\n";
		psfooter += "/str 20 string def\n";
		psfooter += "/k    0      def\n";
		psfooter += "/Palatino-Roman findfont\n";
		psfooter += "8 scalefont\n";
		psfooter += "setfont\n";
		psfooter += "/tile       % expects (3) depth (2) radius (1) ctrx (0) ctry\n";
		psfooter += "{  gsave\n";
		psfooter += "   translate               %  depth radius\n";
		psfooter += "   dup                     %  depth radius radius\n";
		psfooter += "   size div dup             %  depth radius fac fac\n";
		psfooter += "   scale                   %  depth radius\n";
		psfooter += "  % k 90 mul rotate\n";
		psfooter += "   %/k k 1 add def\n";
		psfooter += "   %-1 1 scale\n";
		psfooter += "   0.1 setlinewidth \n";
		psfooter += "   exch                    %  radius depth\n";
		psfooter += "   dup 1 sub               %  radius depth depth'\n";
		psfooter += "   squares { aload pop sq } forall\n";
		psfooter += "   exch 0 gt               %  radius depth' bool\n";
		psfooter += "   3 -1 roll               %  depth' bool radius\n";
		psfooter += "   % cmtx currentmatrix\n";
		psfooter += "   % 0 get                   %  depth' bool radius scale\n";
		psfooter += "   0 mul                   %  depth' bool 0\n";
		psfooter += "   thre  le                %  depth' bool bool\n";
		psfooter += "   and                     %  depth'\n";
		psfooter += "   {\n";
		psfooter += "      squares {\n";
		psfooter += "         aload pop         %  depth' ctrx ctry radius\n";
		psfooter += "         4 -1 roll dup     %  ctrx ctry radius depth' depth'\n";
		psfooter += "         5 2 roll          %  depth' depth' ctrx ctry radius\n";
		psfooter += "         3 1 roll          %  depth' depth' radius ctrx ctry\n";
		psfooter += "         tile              %  depth'\n";
		psfooter += "      } forall\n";
		psfooter += "   } if\n";
		psfooter += "   pop                     %  == this pops the extra depth'\n";
		psfooter += "   grestore\n";
		psfooter += "} def\n";
		psfooter += "graytone setgray\n";
		psfooter += "rv {\n";
		psfooter += "   /dostroke false def\n";
		psfooter += "   size size size sq  \n";
		psfooter += "   1.0 setgray\n";
		psfooter += "} if\n";
		psfooter += "/dostroke true def\n";
		psfooter += "depth size size size tile  \n";
		psfooter += "showpage\n";
		ous.clear();
		ous.str("");	
    	ous <<argv[1]<<Size.at(0)<<"-"<<Size.at(1)<<"-"<<linecount<<".ps";
		ps_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
		if (!ps_file) // check it opened ok
		{
				std::cerr << "Cannot open file " << ous.str() << " for output.\n"; 
		}
		ous.clear();ous.str("");	
        ous<<psheader+psfooter;
        ps_file<<ous.str();
		ps_file.close();
		ous.clear();
		ous.str("");	
		Top.clear() ;
		Bottom.clear() ;
		Left.clear();
		Right.clear() ;
		Size.clear() ;
		Boundary.clear() ;
	} 
	 infile.close();  
	double time_end = get_time();
	std::cout.precision(5);
	if (linecount > 0) std::cout<<" "<<linecount <<" bouwkampcode(s) from file "<<argv[1]<<" processed."<<std::endl;
	std::cout<<" This program has run for: "<< time_end - time_start<< " seconds."<<std::endl;
  return 0;
}// end function
