// bk2ps  - Bouwkamp to postscript- by Stuart Anderson, stuart.errol.anderson@gmail.com 
// bk2ps produces postscript images of squared squares and squared rectangles from bouwkampcode and tablecode
// this version of bk2ps, 31st March 2013
// latest version www.squaring.net/downloads.html
#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <cstdlib>
#include <cmath>
#include <limits>
#include <iomanip>
#include <map>
#include <algorithm>
#include <ctime>

	using namespace std;
	using std::replace;

int main (int argc, char* argv[]) {
		time_t t = time(0);   // get time now
		struct tm * now = localtime( & t );
		ostringstream timeous; // Declare an output string stream.
		timeous <<  now->tm_mday << '-'<<  (now->tm_mon + 1)<<'-'<<  (now->tm_year + 1900) << endl;
		string psheader;
		psheader = "%!PS-Adobe-3.0\n";
		psheader += "%%Creator: Bouwkamp postscript by Stuart Anderson, stuart.errol.anderson@gmail.com ; mergedstring by Don Lancaster\n";
		psheader += "%%CreationDate: "+timeous.str() ;
		psheader +="%%Title: Squared Rectangles, Squared Squares";
		string pagetotal = "%%Pages: "; 
	
		string psprolog;

		psprolog = "% Bouwkampcode; a notation for squared rectangle and squared square tilings invented by C.J. Bouwkamp\n";
		psprolog += "% BouwkampRender; squared rectangle, squared square postscript rendering code by Stuart Anderson\n";
		psprolog += "% order(sum(n)) width height element1 element2 .... element n\n";
		psprolog += "% Title; For rectangles; order width height.  \n";
		psprolog += "% Title; For squared squares; identifier order width height discoverer year\n";

		psprolog += "%%BeginProlog\n";
		psprolog += "/pagebegin {\n";
		psprolog += "gsave\n";
		psprolog += "0 setgray\n";
		psprolog += ".1 setlinewidth\n";
		psprolog += "/str 30 string def\n";
		psprolog += "/tmpstr 30 string def\n";
		psprolog += "/textscalefactor { 30 } def\n";
		psprolog += "/mergestr {2 copy length exch length add string dup dup\n";
		psprolog += "4 3 roll 4 index length exch putinterval 3 1 roll exch\n";
		psprolog += "0 exch putinterval} def \n";
		psprolog += "/BouwkampRender {\n";
		psprolog += "/BouwkampTitle exch def\n";
		psprolog += "/BouwkampString exch def\n";
		psprolog += "/xpos exch def\n";
		psprolog += "/ypos exch def\n";
		psprolog += "/scaling exch def\n";
		psprolog += "/linethick exch def\n";
		psprolog += "/order {BouwkampTitle 0 get cvi} def\n";
		psprolog += "/Size order 1 add array def \n"; 
		psprolog += "/Left order 1 add array def \n";
		psprolog += "/Right order 1 add array def  \n";
		psprolog += "/Top order 1 add array def \n";
		psprolog += "/Bottom order 1 add array def \n";
		psprolog += "/Boundary order 1 add array def \n";
		psprolog += "/j 1 def \n";
		psprolog += "/startx 0 def \n";
		psprolog += "/starty 0 def \n";
		psprolog += "/ch () def \n";
		psprolog += "/s () def \n";
		psprolog += "/startrow true def \n";
		psprolog += "/sum 0 def \n";
		psprolog += "/BoundaryWidth 0 def \n";
		psprolog += "/l 0 def /m 0 def /t 0 def /n 0 def \n";
		psprolog += "/k 0 def \n";
		psprolog += "/BouwkampString BouwkampString ( ) mergestr def \n";
		psprolog += "0 1 BouwkampString length 1 sub { \n";
		psprolog += "	/i exch def \n";
		psprolog += "	/ch BouwkampString i get def \n";
		psprolog += "	ch 48 ge ch 57 le and {  \n";
		psprolog += "    /char (0) def\n";
		psprolog += "    char 0 ch put\n";
		psprolog += "		/s s char mergestr def \n";
		psprolog += "	} { \n";
		psprolog += "		k 2 le j 1 eq and { \n";
		psprolog += "			k 0 eq {	\n";  
		psprolog += "				/order s cvi def 	\n";
		psprolog += "			} if      \n"; 
		psprolog += "			k 1 eq { \n";
		psprolog += "				/RectWidth s cvi def \n";
		psprolog += "				/BoundaryWidth RectWidth def \n";
		psprolog += "			} if    \n"; 
		psprolog += "			k 2 eq { \n";
		psprolog += "				/RectHeight s cvi def \n";
		psprolog += "				Left 0 0 put \n";
		psprolog += "				Bottom 0 0 put \n";
		psprolog += "				/starty RectHeight def	\n";
		psprolog += "			} if             \n";			
		psprolog += "				/s s 0 0 getinterval 	def	 	\n";
		psprolog += "				/k k 1 add def\n";
		psprolog += "	 	} {      \n";
		psprolog += "	 	Size j s cvi put   \n";
		psprolog += "	 	/s s 0 0 getinterval 	def	 	\n";
		psprolog += "		startrow true eq { \n";
		psprolog += "			Left j startx put \n";
		psprolog += "		} { \n";
		psprolog += "			Left j Left j 1 sub get Size j 1 sub get add put \n";
		psprolog += "		} ifelse 					\n";		
		psprolog += "		/startrow false def \n";
		psprolog += "		Right j Left j get Size j get add put \n";
		psprolog += "		Top j starty put \n";
		psprolog += "		Bottom j Top j get Size j get sub put \n";
		psprolog += "		Boundary j j put	  \n";
		psprolog += "		/t Boundary j get def \n";
		psprolog += "		/j j 1 add def \n";
		psprolog += "		1   1  t 1 sub  { \n";
		psprolog += "			/k exch def\n";
		psprolog += "			/l Boundary k get def \n";
		psprolog += "			Boundary k get 0 gt { \n";
		psprolog += "				Top t get Bottom l get eq Left t get Right l get lt and Left l get Right t get lt and  { \n";
		psprolog += "					/BoundaryWidth BoundaryWidth Size k get add def \n";
		psprolog += "					Boundary k Boundary k get neg put \n";
		psprolog += "				} if 	\n";
		psprolog += "			} if					\n";
		psprolog += "		} for		\n";
		psprolog += "		Right t get startx BoundaryWidth add sub 0 eq { \n";
		psprolog += "			/startrow true def\n";
		psprolog += "			/BoundaryWidth 0 def \n";
		psprolog += "			1  1   t {\n";
		psprolog += "				/m exch def\n";
		psprolog += "				/n Boundary m get def \n";
		psprolog += "        m 1 eq {/starty 0 def} if\n";
		psprolog += "        /bm Bottom m get def\n";
		psprolog += "				bm starty gt n 0 gt and { \n";
		psprolog += "					/starty Bottom m get def \n";
		psprolog += "					/startx Left m get def \n";
		psprolog += "				} if     n 0 gt bm starty eq and {  \n";
		psprolog += "					startx Left m get gt {\n";
		psprolog += "				 /startx Left m get def \n";
		psprolog += "					} if \n";
		psprolog += "				} if \n";
		psprolog += "			} for \n";
		psprolog += "		}  		 	\n";
		psprolog += "		{ /startrow false def } ifelse \n";
		psprolog += "  	} ifelse \n";
		psprolog += "	} ifelse \n";
		psprolog += "} for \n";
		psprolog += "   \n";
		psprolog += "/square {\n";
		psprolog += "		/side exch def\n";
		psprolog += "		/ytop exch def\n";
		psprolog += "		/xleft exch def\n";
		psprolog += "		/sizeoffont 14 side log ceiling sub def\n";
		psprolog += "		/scaletext { /Times-Roman findfont sizeoffont scalefont setfont\n";
		psprolog += "			 side textscalefactor div\n";
		psprolog += "			 side textscalefactor div scale} def\n";
		psprolog += "		/showsize {side str cvs show } def\n";
		psprolog += "		/adj side 1 add log ceiling side mul sizeoffont side log ceiling 4 add mul 4.5 div div def\n";
		psprolog += "		newpath\n";
		psprolog += "		 xleft  ytop  moveto\n";
		psprolog += "		4{side 0 rlineto\n";
		psprolog += "		-90 rotate} repeat\n";
		psprolog += " 		closepath\n";
		psprolog += " 		\n";
		psprolog += " 		side 2.5 div adj sub side 1.6 div neg rmoveto\n";
		psprolog += "		%RectHeight side div 30 scaling mul le\n";
		psprolog += "		gsave scaletext showsize grestore %if\n";
		psprolog += "    \n";
		psprolog += " 		stroke\n";
		psprolog += "} def\n";
		psprolog += "/Times-Roman findfont 24 scalefont setfont % default Times-Bold\n";
		psprolog += "\n";

		string renderTitle1 ="";
		renderTitle1 += "/RenderTitle { scaling dup scale\n";
		renderTitle1 += "%	/str 255 string def\n";
		renderTitle1 += "%/tmpstr 255 string def\n";
		renderTitle1 += "BouwkampTitle length 1 sub   1 neg   0 {\n";
		renderTitle1 += "		/token exch def\n";
		renderTitle1 += "		/tmpstr BouwkampTitle token get str cvs tmpstr mergestr def\n";
		renderTitle1 += "   /tmpstr ( ) str cvs tmpstr mergestr def\n";
		renderTitle1 += "	} for\n";
		renderTitle1 += "	280 tmpstr length 2.1 mul sub 270 moveto\n";
		renderTitle1 += "	tmpstr show\n";
		renderTitle1 += "} def\n";
		renderTitle1 += "RenderTitle\n";
		renderTitle1 += "\n";

		string renderTitle6 ="";
		renderTitle6 += "/RenderTitle { scaling dup scale\n";
		renderTitle6 += "/str 255 string def\n";
		renderTitle6 += "/tmpstr 255 string def\n";
		renderTitle6 += "    BouwkampTitle length 1 sub   1 neg   0 {\n";
		renderTitle6 += "	/token exch def\n";
		renderTitle6 += "	/tmpstr BouwkampTitle token get str cvs tmpstr mergestr def\n";
		renderTitle6 += "    /tmpstr ( ) str cvs tmpstr mergestr def\n";
		renderTitle6 += "	} for\n";
		renderTitle6 += "	800 tmpstr length 2.1 mul sub 80 moveto\n";
		renderTitle6 += "	tmpstr show\n";
		renderTitle6 += "} def\n";
		renderTitle6 += "RenderTitle\n";
		renderTitle6 += "\n";

		string renderTitle12 ="";
		renderTitle12 += "/RenderTitle { scaling dup scale\n";
		renderTitle12 += "/str 255 string def\n";
		renderTitle12 += "/tmpstr 255 string def\n";
		renderTitle12 += "BouwkampTitle length 1 sub   1 neg   0 {\n";
		renderTitle12 += "		/token exch def\n";
		renderTitle12 += "		/tmpstr BouwkampTitle token get str cvs tmpstr mergestr def\n";
		renderTitle12 += "   /tmpstr ( ) str cvs tmpstr mergestr def\n";
		renderTitle12 += "	} for\n";
		renderTitle12 += "	800 tmpstr length 2.1 mul sub 100 moveto\n";
		renderTitle12 += "	tmpstr show\n";
		renderTitle12 += "} def\n";
		renderTitle12 += "RenderTitle\n";
		renderTitle12 += "\n";

		string renderTitle20 ="";
		renderTitle20 += "/RenderTitle { scaling dup scale\n";
		renderTitle20 += "/Times-Roman findfont 36 scalefont setfont % default Times-Bold\n";
		renderTitle20 += "/str 255 string def\n";
		renderTitle20 += "/tmpstr 255 string def\n";
		renderTitle20 += "BouwkampTitle length 1 sub   1 neg   0 {\n";
		renderTitle20 += "		/token exch def\n";
		renderTitle20 += "		/tmpstr BouwkampTitle token get str cvs tmpstr mergestr def\n";
		renderTitle20 += "   /tmpstr ( ) str cvs tmpstr mergestr def\n";
		renderTitle20 += "	} for\n";
		renderTitle20 += "	750 tmpstr length 2.2 mul sub 80 moveto\n";
		renderTitle20 += "	tmpstr show\n";
		renderTitle20 += "} def\n";
		renderTitle20 += "RenderTitle\n";
		renderTitle20 += "\n";

		string psprolog2 = "";
		psprolog2 += "xpos ypos translate \n";
		psprolog2 += "440 RectWidth div dup scale\n";
		psprolog2 += "5.5 RectWidth ln exp RectWidth div linethick mul setlinewidth\n";
		psprolog2 += "1 1 Size length 1 sub { \n";
		psprolog2 += "	/x exch def\n";
		psprolog2 += "	Left x get Top x get Size x get square\n";
		psprolog2 += "} for \n";
		psprolog2 += "\n";
		psprolog2 += "} def % pagebegin\n";
		psprolog2 += "/page-end {\n";
		psprolog2 += "grestore\n";
		psprolog2 += "showpage\n";
		psprolog2 += "} def\n";
		psprolog2 += "} def % BouwkampRender\n";
		psprolog2 += "%%EndProlog\n";

		string pagenumber = "%%Page: ";

		string page_part1_single =  "pagebegin\n /SingleBk [\n";

		string page_part2_single ; 
		page_part2_single += "] def\n";//
		page_part2_single += "	/THIStitle SingleBk 0 get def\n";
		page_part2_single += "	/THISarray SingleBk 1 get def\n";
		page_part2_single += "	.02 1 320 75 THISarray THIStitle BouwkampRender\n";
		page_part2_single += "page-end\n";


		string page_part1_six_to_a_page = "pagebegin\n /SixBk [\n";

		string page_part2_six_to_a_page;
		page_part2_six_to_a_page += "] def\n";
		page_part2_six_to_a_page += "/inc 0 def\n";
		page_part2_six_to_a_page += "-260 510 translate\n";
		page_part2_six_to_a_page += "100 1000 moveto\n";
		page_part2_six_to_a_page += "3{\n";
		page_part2_six_to_a_page += "  2 {\n";
		page_part2_six_to_a_page += "	270 0 translate\n";
		page_part2_six_to_a_page += "	gsave\n";
		page_part2_six_to_a_page += " /THIStitle SixBk inc get def\n";
		page_part2_six_to_a_page += "	/THISarray SixBk inc 1 add get def\n";
		page_part2_six_to_a_page += "	.02 0.47 144 72 THISarray THIStitle BouwkampRender\n";
		page_part2_six_to_a_page += "	/inc inc 2 add def\n";
		page_part2_six_to_a_page += " 	grestore\n";
		page_part2_six_to_a_page += "  } repeat\n";
		page_part2_six_to_a_page += " -540 -270 translate\n";
		page_part2_six_to_a_page += "} repeat\n";
		page_part2_six_to_a_page += "page-end\n";

		string page_part1_twelve_to_a_page = "pagebegin\n /TwelveBk [\n";

		string page_part2_twelve_to_a_page ; 
		page_part2_twelve_to_a_page += "] def\n";
		page_part2_twelve_to_a_page += "/inc 0 def\n";
		page_part2_twelve_to_a_page += "-190 570 translate\n";
		page_part2_twelve_to_a_page += "100 1000 moveto\n";
		page_part2_twelve_to_a_page += "4{\n";
		page_part2_twelve_to_a_page += "  3 {\n";
		page_part2_twelve_to_a_page += "	190 0 translate\n";
		page_part2_twelve_to_a_page += "	gsave\n";
		page_part2_twelve_to_a_page += "	/THIStitle TwelveBk inc get def\n";
		page_part2_twelve_to_a_page += "	/THISarray TwelveBk inc 1 add get def\n";
		page_part2_twelve_to_a_page += "	.02 0.32 144 72 THISarray THIStitle BouwkampRender\n";
		page_part2_twelve_to_a_page += "	/inc inc 2 add def\n";
		page_part2_twelve_to_a_page += " 	grestore\n";
		page_part2_twelve_to_a_page += "  } repeat\n";
		page_part2_twelve_to_a_page += " -570 -190 translate\n";
		page_part2_twelve_to_a_page += "} repeat\n";
		page_part2_twelve_to_a_page += "page-end\n";

		string page_part1_twenty_to_a_page = "pagebegin\n /TwentyBk [\n";

		string page_part2_twenty_to_a_page ; 
		page_part2_twenty_to_a_page += "] def\n";
		page_part2_twenty_to_a_page += "/inc 0 def\n";
		page_part2_twenty_to_a_page += "-132 600 translate\n";
		page_part2_twenty_to_a_page += "100 1000 moveto\n";
		page_part2_twenty_to_a_page += "5{\n";
		page_part2_twenty_to_a_page += "  4 {\n";
		page_part2_twenty_to_a_page += "	140 0 translate\n";
		page_part2_twenty_to_a_page += "	gsave\n";
		page_part2_twenty_to_a_page += "	/THIStitle TwentyBk inc get def\n";
		page_part2_twenty_to_a_page += "	/THISarray TwentyBk inc 1 add get def\n";
		page_part2_twenty_to_a_page += ".02 0.24 144 72 THISarray THIStitle BouwkampRender\n";
		page_part2_twenty_to_a_page += "	/inc inc 2 add def\n";
		page_part2_twenty_to_a_page += " 	grestore\n";
		page_part2_twenty_to_a_page += "  } repeat\n";
		page_part2_twenty_to_a_page += " -560 -140 translate\n";
		page_part2_twenty_to_a_page += "} repeat\n";
		page_part2_twenty_to_a_page += "page-end\n";

		string psfooter = "%%Trailer\n%%EOF\n";
		 //cout<<"//"<<endl;
		 if ( argc == 1 ) {
		 cout<<"/////////////////////////////////////"<<endl;
		 cout<<"/ bouwkampcode to postscript (b2pss) "<<endl;
		 cout<<"/"<<endl;			    
		 cout<<"/ Description:"<<endl;
		 cout<<"/ bk2ps is a C++ program which generates postscript files "<<endl;
		 cout<<"/ of squared rectangles and squared squares from "<<endl;
		 cout<<"/ bouwkampcode, which is a concise notation,  "<<endl;
		 cout<<"/ describing a tiling by squares, of a rectangle, or a square"<<endl;
		 cout<<"/ composed of smaller squares, which may be different" <<endl;
		 cout<<"/ sizes, by listing the sizes of the squares in adjacent rows"<<endl;
		 cout<<"/ from left to right and from top to bottom."<<endl;
		 cout<<"/   "<<endl;
		 cout<<"/ A rectangle can be flipped onto itself in 4 different"<<endl;
		 cout<<"/ ways, a square 8 ways, so there are multiple bouwkampcodes"<<endl;
		 cout<<"/ for a unique tiling. "<<endl;
		 cout<<"/ Canonical bouwkampcode is the particular bouwkampcode,"<<endl;
		 cout<<"/ considered as a string, which is numerically the highest" <<endl;
		 cout<<"/ Input data should be in canonical bouwkampcode order. "<<endl;
		 cout<<"/ Parentheses and commas can be dispensed with. "<<endl;
		 cout<<"/ The columns used in each row of bouwkampcode are;"<<endl;  
		 cout<<"/ order width height e1 e2 e3 ... en * order : identifier author year"<<endl;
		 cout<<"/   "<<endl;
		 cout<<"/ The fields after * are optional, generally used for the titling"<<endl;
		 cout<<"/ of perfect squares."<<endl;
		 cout<<"/ Explanation of columns in bouwkampcode;"<<endl;
		 cout<<"/ ///////////////////////////////////////"<<endl;
		 cout<<"/ -order: number of squares in the tiling, "<<endl;
		 cout<<"/ -e1 ... en: the integer sizes of the squares in the tiling; "<<endl;
		 cout<<"/ -identifier:  eg 112A or 175a (uppercase simples, lowercase compounds)"<<endl;
		 cout<<"/ -(side) - for squared squares, "<<endl;
		 cout<<"/ -(width x height)- for squared rectangles,"<<endl;
		 cout<<"/ -author: author/discoverer's initials; "<<endl;
		 cout<<"/ -year: year of discovery; "<<endl;
		 cout<<"/ "<<endl;
		 cout<<"/ The output is a numbered postscript document."<<endl;
		 cout<<"/"<<endl;                  
		 cout<<"/ this version: 31st March 2013"<<endl;
		 cout<<"/ author      : Stuart Anderson"<<endl;
		 cout<<"/ email       : stuart.errol.anderson@gmail.com"<<endl;
		 cout<<""<<endl;
		 cout<<"/ Instructions on input data;"<<endl;
		 cout<<"/ Enter enter the code letter for the number of tilings per page;"<<endl;
		 cout<<"/ o (one), or s (six) or d (dozen) or t (twenty), and an input filename."<<endl;
		 cout<<"/ this version can be used for script and batch processing."<<endl;
		 cout<<"//////////////////////////////////////////////////////////////////////"<<endl;
		 exit(0);
		 }
		int number_per_page = 0;
		string bk_input_file;
		string args;
		if ( argc != 3 ) 
		{
			cout<<" Enter enter the number of tilings per page; o (1), or s (6), or d (12) or t (20), and an input filename."<<endl;
			exit(0);
		}
		else 
		{
			bk_input_file = argv[2];
			args = argv[1];
			for (unsigned int c=0; c<args.length(); c++)//
			{
				if (args.find_first_of("o")!=string::npos) number_per_page = 1;
				if (args.find_first_of("s")!=string::npos) number_per_page = 6;
				if (args.find_first_of("d")!=string::npos) number_per_page = 12;
				if (args.find_first_of("t")!=string::npos) number_per_page = 20;
			}
		}
		if (number_per_page == 0) {
			cout<<" Enter enter the number of tilings per page; o (1), or s (6), or d (12) or t (20), and an input filename."<<endl;
			exit(0);
		}
			ifstream infile;
			ofstream outfile;
			int count = 0;
			string lin;
			int page_inc = 0;
			//////////////////////
			// unsigned int i;
			infile.open(bk_input_file.c_str());//error handling
			if (infile.is_open() ) 	{
				while (! infile.eof() ){
				getline (infile,lin);
				
				if (lin.length() > 1) count++; //count non-empty lines before doing anything else
				}
				infile.clear();// 
				infile.seekg (0, ios::beg); // go back to beginning of file
				//int  order,  width, height; //
				 } else {
			cout << "could not open file " << bk_input_file << endl;
			return 0;
		    }

				string line = "";
				string line1 = "";
				string line2 = "";
				string title = "";
				string outname = "";
				string sdoc = "";
				string outtitle = "";
				cout << "// Processing "<< bk_input_file <<endl;
				for (int row = 1; row <= count; row++)
				{
					istringstream ins; // Declare an input string stream.
					ostringstream ous; // Declare an output string stream.
			  		getline (infile,line);
			  		 size_t found;
			  		 string linebk;
			  		 string lineend;
			  		 found=line.find("*");
			  		 if (found != string::npos) {
                          linebk = line.substr(0,found-1); // separate the bouwkampcode from the extended fields if they exist
                          lineend = line.substr(found);
                     } else {
                    	  linebk = line;
                    }
			  		//if bouwkampcode convert to tablecode by deleting parentheses and commas and replacing with whitespace
		  			replace( linebk.begin(), linebk.end(), ',', ' ' );
		  			replace( linebk.begin(), linebk.end(), '(', ' ' );
		  			replace( linebk.begin(), linebk.end(), ')', ' ' );
		  			replace( linebk.begin(), linebk.end(), '(', ' ' );
		  			replace( linebk.begin(), linebk.end(), '	', ' ' );

			  		string newline;
			  		newline += linebk;
			  		newline += " ";
			  		newline += lineend;
			  		ins.str(newline); // Specify string to read.
			  		string order, size1, size2;  //
			  		ins >> order >> size1 >> size2 ;
					ous <<"[("<< order <<") (:) ("<<size1 <<") (x) ("<< size2 <<") " ;
					line1 = ous.str();
					line2 += "(";
					stringstream os(newline);  // a standard stringstream which parses 'newline'
					string temp;                 // a temporary string
				    bool flag1 = true;
				    bool flag2 = true;
					while (os >> temp)    {  // the stringstream makes temp a token
						if (temp !="*") {          // flip to extended bouwkampcode on asterisk 
                             if (flag2 == true) {
								line2 += temp;
								line2 += " ";
							}
							if (flag1 == false) {	
									line1 += temp;
		  							line1 += ") (";
						} 
					} else {
							line1 = "[(";
							flag1 = false;
							flag2 = false;
						}
			        }
					// erase last space and add close parentheses and newline on line2
					string::iterator it;
				    it=line2.end()-1;
				    line2.erase (it);
				    line2 += ")\n";
				    // erase last space, (or parenthesis if extended fields used) and add close bracket and newline on line1
				    it=line1.end()-1;
				    line1.erase (it);
				    line1 += "]\n";
				    
				    sdoc += line1;
				    sdoc += line2;
				    
					line = "";
					line1 = "";
					line2 = "";
				}
				
				stringstream sinfile ;
				sinfile << sdoc;
				sinfile.seekg (0, ios::beg);
				int inc = number_per_page ;
				int pages = 0;
				pages = count/inc; 
				//count *= 2;
				page_inc = 0;
				stringstream ss_pages;
				string document = "";
				int lastpagecount = 0;
				bk_input_file.erase(bk_input_file.find(".txt"),4);
				if (number_per_page == 1)
			 	{
					document += psheader;
					document += '\n';
					document += pagetotal;

					ss_pages <<" "<< pages << endl;
					document += ss_pages.str();
					ss_pages.str("");
					document += psprolog;
					document += renderTitle1;
					document += psprolog2;
					for (int row = 1; row < 2*count; row+=2){
						document += pagenumber;
						page_inc++;
						ss_pages <<" "<< page_inc << " " << page_inc << endl;
						document += ss_pages.str();
						ss_pages.str("");
						document += page_part1_single;
						getline (sinfile,line1);
						document += line1;
						document += '\n';
						getline (sinfile,line2);
						document += line2;
						//document.erase(document.length(), document.length());//slice last eol character off
						document += page_part2_single;//
						line1 = "";
						line2 = "";
					}
					document += psfooter;
					bk_input_file += "_1pp.ps";
					cout <<endl<<"// Output file; "<< bk_input_file << endl;
					outfile.open (bk_input_file.c_str());
					outfile << document ;
					outfile.close();
					document = ""; //singles only
	
				}else if (number_per_page == 6)
				{
					document += psheader;
					document += '\n';
					document += pagetotal;
					ss_pages <<" "<< pages << endl;
					document += ss_pages.str();
					ss_pages.str("");
					document += psprolog;
					document += renderTitle6;
					document += psprolog2;
					for (int c6 = 1; c6 <= count/6 ; c6++){
						document += pagenumber;
						page_inc++;
						ss_pages <<" "<< page_inc << " " << page_inc << endl;
						document += ss_pages.str();
						ss_pages.str("");
						document += page_part1_six_to_a_page;
						for (int sixes = 1; (sixes < 7); sixes++){
							getline (sinfile,line1);
							document += line1;
							document += '\n';
							getline (sinfile,line2);
							document += line2;
							document += '\n';
						}
					   document += page_part2_six_to_a_page;
					}//c6
					if (!(count%inc == 0)) {
						document += pagenumber;
						page_inc++;
						ss_pages <<" "<< page_inc << " " << page_inc << endl;
						document += ss_pages.str();
						ss_pages.str("");
						document += page_part1_six_to_a_page;
					}
					string sts = "";
					while (! sinfile.eof() )
					{
						line1 = "";
						line2 = "";
						lastpagecount++;
					    getline (sinfile,line1);
						getline (sinfile,line2);
		                if (line1.length()>1) {
		                document += line1;
						document += '\n';
						}
						if (line2.length()>1){
						document += line2;
						document += '\n';
						}
					}
					if (lastpagecount == 0) lastpagecount = 6;
					for (int endbit = 1; (endbit <= 7-lastpagecount); endbit++){
						document += "[(4) (:) (202)(x)(202)]\n";
						document += "(4 202 202 101 101 101 101)\n";
					}
					if (!(2*count%inc == 0)) {
					document += page_part2_six_to_a_page;
					}
					document += psfooter;
					bk_input_file += "_6pp.ps";
					cout <<endl<<"// Output file; "<< bk_input_file << endl;
					outfile.open (bk_input_file.c_str());
					outfile << document ;
					outfile.close();
				}else if (number_per_page == 12)
				{
					document += psheader;
					document += '\n';
					document += pagetotal;
					ss_pages <<" "<< pages << endl;
					document += ss_pages.str();
					ss_pages.str("");
					document += psprolog;
					document += renderTitle12;
					document += psprolog2;
				    for (int c12 = 1; c12 <= count/12 ; c12++){
						document += pagenumber;
						page_inc++;
						ss_pages <<" "<< page_inc << " " << page_inc << endl;
						document += ss_pages.str();
						ss_pages.str("");
						document += page_part1_twelve_to_a_page;
						for (int twelves = 1; (twelves < 13); twelves++){
							getline (sinfile,line1);
							getline (sinfile,line2);
							document += line1;
							document += '\n';
							document += line2;
							document += '\n';
						}
					    document += page_part2_twelve_to_a_page;
					}//c12
					if (!(count%inc == 0)) {
					//cout << document << endl;
						document += pagenumber;
						page_inc++;
						ss_pages <<" "<< page_inc << " " << page_inc << endl;
						document += ss_pages.str();
						ss_pages.str("");
						document += page_part1_twelve_to_a_page;
					}
					while (! sinfile.eof() )
					{
						line1 = "";
						line2 = "";
						lastpagecount++;
						getline (sinfile,line1);
						getline (sinfile,line2);
				       if (line1.length()>1) {
				         document += line1;
						 document += '\n';}
						if (line2.length()>1){
						  document += line2;
						  document += '\n';}
					}

					if (lastpagecount == 0) lastpagecount = 12;
					for (int endbit = 1; (endbit <= 13-lastpagecount); endbit++){
						document += "[(4) (:) (202)(x)(202)]\n";
						document += "(4 202 202 101 101 101 101)\n";
					}
					if (!(count%inc == 0)) {
					document += page_part2_twelve_to_a_page;
					}
					//cout << document << endl;
					document += psfooter;
					bk_input_file += "_12pp.ps";
					cout <<endl<<"// Output file; "<< bk_input_file << endl;
					outfile.open (bk_input_file.c_str());
					outfile << document ;
					outfile.close();

				}else if (number_per_page == 20)
				{
					document += psheader;
					document += '\n';
					document += pagetotal;
					ss_pages <<" "<< pages << endl;
					document += ss_pages.str();
					ss_pages.str("");
					document += psprolog;
					document += renderTitle20;
					document += psprolog2;
					for (int c20 = 1; c20 <= count/20 ; c20++){
						document += pagenumber;
						page_inc++;
						ss_pages <<" "<< page_inc << " " << page_inc << endl;
						document += ss_pages.str();
						ss_pages.str("");
						document += page_part1_twenty_to_a_page;
						for (int twentys = 1; (twentys < 21); twentys++){
							getline (sinfile,line1);
							document += line1;
							document += '\n';
							getline (sinfile,line2);
							document += line2;
							document += '\n';
						}
						document += page_part2_twenty_to_a_page;
					}//c20
					if (!(count%inc == 0)) {
						document += pagenumber;
						page_inc++;
						ss_pages <<" "<< page_inc << " " << page_inc << endl;
						document += ss_pages.str();
						ss_pages.str("");
						document += page_part1_twenty_to_a_page;
					}
					while (! sinfile.eof() )
					{
						line1 = "";
						line2 = "";
						lastpagecount++;
						getline (sinfile,line1);
						getline (sinfile,line2);
				       if (line1.length()>1) {
				          document += line1;
						  document += '\n';}
						if (line2.length()>1){
						  document += line2;
						  document += '\n';}
					}

				if (lastpagecount == 0) lastpagecount = 20;
				for (int endbit = 1; (endbit <= 21-lastpagecount); endbit++){
					document += "[(4) (:) (202)(x)(202)]\n";
					document += "(4 202 202 101 101 101 101)\n";
				}
				if (!(count%inc == 0)) {
				document += page_part2_twenty_to_a_page;
				}
				//cout << document << endl;
				document += psfooter;
				bk_input_file += "_20pp.ps";
				cout <<endl<<"// Output file; "<< bk_input_file << endl;
				outfile.open (bk_input_file.c_str());
				outfile << document ;
				outfile.close();
			
			}
        infile.close();
		cout << count <<" bouwkamp files in a " <<page_inc<<" page postscript document "<<bk_input_file <<endl<<"with "<<number_per_page<<" tiling(s) per page."<< endl;
		return 0;
}
