// author Stuart Errol Anderson;
// March 4, 2012
// stuart.errol.anderson@gmail.com
//  bk2ism (bouwkampcode to isomers) detection and save. [uses set operations for detection] 
#include <vector>
#include <iterator>
#include <iostream>
#include <fstream>
#include <string>
#include <set>
#include <sstream>
#include <algorithm>
#include <exception>
#include <sys/time.h>
double get_time(){
	    struct timeval t;
	    gettimeofday(&t, NULL);
	    double d = t.tv_sec + (double) t.tv_usec/1000000;
	    return d;
	}
int main (int argc, char* argv[]){
	//create an ifstream infile

	double time_start = get_time();
		std::ifstream infile;
		//open ifstream infile, test open, display info
		infile.open(argv[1]);
		if(infile.fail()) // if infile fails to open
	 	{
			if (argc == 1) {   // if failed to open as no filename was given, provide program info and usage
				std::cout<<"author Stuart Errol Anderson;"<<std::endl;
				std::cout<<"March 4, 2012"<<std::endl;
				std::cout<<"stuart.errol.anderson@gmail.com"<<std::endl;
				std::cout<<"bk2ism (bouwkampcode to isomer) is an application"<<std::endl;
				std::cout<<"designed to detect isomers in a sorted bouwkampcode file."<<std::endl;
				std::cout<<"Isomers are square tilings of the same height and width,"<<std::endl;
				std::cout<<"with all the same sized elements, but arranged differently."<<std::endl;
				std::cout<<"Usage; bk2ism  filename "<<std::endl;
				std::cout<<"Output; filename+'.ism' for isomers, if they exist in the input file."<<std::endl;
				exit(0);
			}
			else {  // if failed to load file for some other reason (wrong filename, non-existent file, ... )
		        std::cout<<"error; file "<<argv[1]<<" failed to load"<<" exiting."<<std::endl;
			   	exit(0);
			}
		}
		std::cout<<"Processing bouwkampcode file "<<argv[1]<<" for isomers ..."<<std::endl;
		//create a stringstream, strings for lines and values
		std::istringstream stream;
		std::istringstream ss;
		std::string line;
		std::string value;
		std::ofstream isomer_file;	// create ofstream isomer bouwkampcode
		int b = 0;
		int counter_i = 0;
		int element = 0;
		bool isomer = false;	
		std::vector<int> temp;
		std::vector<std::vector<int> > Bouwkamp ;
	 	std::ostringstream ous;
		while (( std::getline(infile, line, '\n' ) ) &&(line.length()>1)){ // extract lines
  		 size_t found;
  		 std::string linebk;
  		 std::string lineend;
  		 found=line.find("*");
  		 if (found != std::string::npos) {
              linebk = line.substr(0,found-1); // separate the bouwkampcode from the extended fields if they exist
              lineend = line.substr(found+1);
         } else {
        	  linebk = line;
        }
  		//if bouwkampcode convert to tablecode by deleting parentheses and commas and replacing with whitespace
		replace( linebk.begin(), linebk.end(), ',', ' ' );
		replace( linebk.begin(), linebk.end(), '(', ' ' );
		replace( linebk.begin(), linebk.end(), ')', ' ' );
		std::string newline;
  		newline += linebk;
		stream.clear();
		stream.str(newline); 
		Bouwkamp.push_back(temp);
			while ( stream >> value  ) 	{ // get values in columns
				std::istringstream ss(value);
				ss >> element;
				ss.str("");
				Bouwkamp.at(b).push_back(element);
			} 
			b++;
		}
		std::set<int> s1;
		std::set<int> s2;
		std::set<int> s3;
		std::set<int> s4;
		int lastrow = -1;
		for (unsigned int j = 1; j <  Bouwkamp.size(); j++){	
				for (unsigned int k = 2; k <  Bouwkamp.at(j).size();k++){	
				 	s1.insert(Bouwkamp.at(j-1).at(k));
				 	s2.insert(Bouwkamp.at(j).at(k));
			 	}
				//test for isomers; no difference in the elements; if s1 s2 have the empty set for their symmetric difference, ie  the intersection of  s1 s2  minus the union of  s1 s2  
				// and they are the same size (width(s1)==width(s2) & height(s1)==height(s2)), then they are isomers
				std::set_symmetric_difference(s1.begin(), s1.end(), s2.begin(), s2.end(), std::insert_iterator<std::set<int> >(s4,s4.begin()) );
				if ((s4.size() == 0)&&(Bouwkamp.at(j-1).at(1) == Bouwkamp.at(j).at(1))&&(Bouwkamp.at(j-1).at(2) == Bouwkamp.at(j).at(2)))   {
					isomer = true;
				} else {
					isomer = false;
				}		
				s1.erase(s1.begin(),s1.end());
				s2.erase(s2.begin(),s2.end());
				s3.erase(s3.begin(),s3.end());
				s4.erase(s4.begin(),s4.end());
				std::ostringstream oss;
			 	if (isomer == true) {  	
					ous <<argv[1]<<".ism";
					isomer_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
					if (!isomer_file) // check it opened ok
					{
							std::cerr << "Cannot open isomer file " << ous.str() << " for output.\n"; 
					}
					if ((lastrow + 1.0) != j) { //dont save the previous one if there's more than 2 in a row
						for (unsigned int k = 0; k <  Bouwkamp.at(j-1).size();k++){	 // save the previous bouwkampcode
							if (k ==0) {
								oss<< Bouwkamp.at(j-1).at(k);
							}
							else {
							 	oss<<' '<< Bouwkamp.at(j-1).at(k);
							}
						}
						isomer_file << oss.str() << std::endl;
						std::cout<<" isomer "<<oss.str()<<std::endl;								
						oss.str("");	
						counter_i++;	
					}
					for (unsigned int k = 0; k <  Bouwkamp.at(j).size();k++){	// save the current bouwkampcode
							if (k ==0) {
								oss<< Bouwkamp.at(j).at(k);
							}
							else {
							 	oss<<' '<< Bouwkamp.at(j).at(k);
							}
						}
						isomer_file << oss.str() << std::endl;
						std::cout<<" isomer "<<oss.str()<<std::endl;								
						oss.str("");	
						counter_i++;						
						isomer_file.close();
						ous.clear();	
						ous.str("");		
						lastrow = j;
			}			
		}

		std::cout<< b <<" Bouwkampcodes from "<<argv[1]<<" processed;"<<std::endl;
		if (counter_i != 0)	std::cout<<counter_i<<" isomers saved to "<<argv[1]<<".ism"<<std::endl;
		
		double time_end = get_time();
	std::cout.precision(5);
	std::cout<<"This program has run for: "<< time_end - time_start<< " seconds."<<std::endl;
	  return 0;
}// end function
