// author;
// Stuart Errol Anderson;
// November 16, 2013
// stuart.errol.anderson@gmail.com
// bk2cs
// bouwkampcode to compound or simple; detection and save
#include <vector>
#include <iterator>
#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <iomanip>
#include <algorithm>
#include <cmath>
#include <cstring>
#include <cstdlib>
#include <exception>
#include <ctime>
#include <limits>

int main (int argc, char* argv[]){
	//set start time
	const clock_t begin_time = clock();
	//create an ifstream input filename
	std::ifstream infile;
	//open ifstream infile
	infile.open(argv[1]);
	if(infile.fail())
	{
		if (argc == 1) {
			std::cout<<" ------------------------------------------------------------------------------"<<std::endl;
			std::cout<<" bk2cs (bouwkampcode to compound/simple) is an application designed to classify "<<std::endl;
			std::cout<<" dissections in a bouwkampcode file as simple or compound, then save them."<<std::endl;
			std::cout<<" The format for running the program is;"<<std::endl;
			std::cout<<" bk2cs filename  "<<std::endl;
			std::cout<<" output is 2 files ;"<<std::endl;
			std::cout<<" filename-cmp.txt are compound tablecodes from input file filename."<<std::endl;	
			std::cout<<" filename-smp.txt are simple tablecodes from input file filename."<<std::endl;
			std::cout<<" ------------------------------------------------------------------------------"<<std::endl;
			std::cout<<"  An algorithm which captures all cases can be based on the definition of a compound;"<<std::endl;
			std::cout<<"  A compound squared rectangle or compound squared square contains at least one rectangle"<<std::endl;
			std::cout<<"  and/or dissected square in the dissection, smaller than the entire dissected square or rectangle."<<std::endl;
			std::cout<<"  The algorithm must detect a subrectangle, or dissected subsquare in the bouwkampcode of the "<<std::endl;
			std::cout<<"  squared square or squared rectangle.  An analysis of all possible cases suggests an algorithm"<<std::endl;
			std::cout<<"  based on counting total squares and rectangles in the dissection."<<std::endl;
			std::cout<<"  A squared dissection with no subrectangles, or dissected subsquares is simple, otherwise it is compound."<<std::endl;
			std::cout<<"  If a tiling is a siss, or spss, the number of squares = order + 1, and the number of rectangles = 0,"<<std::endl;
			std::cout<<"  If a tiling is an spsr, or sisr then the number of squares = order, and the number of rectangles = 1."<<std::endl;
			std::cout<<"  In all the above cases the tiling is simple.  If it is not simple then it is compound; ie a ciss, cpss, cisr or cpsr."<<std::endl;
			std::cout<<" ------------------------------------------------------------------------------"<<std::endl;
			std::cout<<" Author; Stuart Anderson ; email: stuart.errol.anderson@gmail.com, "<<std::endl;
			std::cout<<" This version; 29th October 2020"<<std::endl;		
			exit(0);
		}
		else {
			std::cout<<"error; file "<<argv[1]<<" failed to load"<<std::endl;
			exit(0);
		}
	}
	std::cout<<"Analysing Bouwkampcode (or tablecode) file "<<argv[1]<<" into categories compound and/or simple ..."<<std::endl;
	//create a stringstream, strings for lines and values
	std::istringstream stream;
	std::istringstream ins;
	std::istringstream ss;
	std::string line;
	std::string value;
	std::ofstream cmp_file;	// create ofstream compound bouwkampcode
	std::ofstream smp_file;	// create ofstream simple bouwkampcode
	int compcount = 0;
	int simpcount = 0;
	bool comp;
	std::vector<int> Top ;
	std::vector<int> Bottom ;
	std::vector<int> Left;
	std::vector<int> Right ;
	std::vector<int> Size ;
	std::vector<int> Boundary ;
	int element;
	int linecount = 0;
	while ( std::getline(infile, line, '\n' ) &&(line.length()>1)){ // extract lines
		size_t found;
		linecount++;
		std::string linebk;
		std::string lineend;
		found=line.find("*");
		if (found != std::string::npos) {
			linebk = line.substr(0,found-1); // separate the bouwkampcode from the extended fields if they exist
			lineend = line.substr(found+1);
		} else {
			linebk = line;
		}
		//if bouwkampcode convert to tablecode by deleting parentheses and commas and replacing with whitespace
		replace( linebk.begin(), linebk.end(), ',', ' ' );
		replace( linebk.begin(), linebk.end(), '(', ' ' );
		replace( linebk.begin(), linebk.end(), ')', ' ' );
		std::string newline;
		newline += linebk;
		newline += " ";
		newline += lineend;
		ins.str(linebk); // Specify string to read.
		while ( ins >> value  ) 	{ // get values in columns
			std::istringstream ss(value);
			ss >> element;
			ss.str("");
			Size.push_back(element);
		} 
		if (Size[0] != (int)Size.size()-3) {
			std::cout<<"Bouwkampcode/tablecode line "<<linecount<<" is faulty; The order does not match the number of elements in the code, exiting program"<<std::endl;
			exit(0);
		}
		int BoundaryWidth = Size[1];
		for (unsigned int j = 0; j <  3; j++){
			Top.push_back(0);
			Left.push_back(0);
			Right.push_back(0);
			Bottom.push_back(0);
			Boundary.push_back(0);
		}
		bool startrow = true;
		int startx = 0 ;
		int starty = 0 ;
		int MaxInt = std::numeric_limits<int>::max();
		
		int l = 0; int b = 0;
		for (unsigned int j = 3; j <  Size.size(); j++){
			if (startrow == true) {
				Left.push_back(startx);
				startrow = false;
			} else {
				Left.push_back(Left[j-1] + Size[j-1]);
			}
			Right.push_back(Left[j] + Size[j]);
			Top.push_back(starty);
			Bottom.push_back(Top[j] + Size[j]);
			Boundary.push_back(j);
			for (unsigned int k = 0; k < j; k++) { // remove (make negative) old bottom square(s) from boundary list when covered by new one
				l = Boundary[k];
				if (l > 0) {
					if ((Top[j] == Bottom[l]) && (Left[j] <= Left[l]) && (Left[l] <= Right[j])) {
						BoundaryWidth = BoundaryWidth + Size[k];
						Boundary[k] = -Boundary[k];
					}
				}
			}
			if ((Right[j] - startx - BoundaryWidth) == 0){
				startrow = true;
				BoundaryWidth = 0;
				startx = MaxInt; //start 
				starty = MaxInt;
				for (unsigned int m = 3; m <= j; m++){ // find minimum Boundary Bottom (starty) and Left (startx)
					b = Boundary[m];
					if ((b > 0) && (Bottom[b] < starty)){
						starty = Bottom[b];
						startx = Left[b];
					} else if ((b > 0) && (Bottom[b] == starty)){
						if (startx > Left[b]){
							startx = Left[b];
						}
					}
				}
			} else {
				startrow = false;	
			}
		} 
		int top, left, right, bottom, squares, rectangles;
		top = 0;
		left = 0;
		right = 0;
		bottom = 0;
		squares = 0;
		rectangles = 0;
		bool sw = false;
		bool ne = false;
		std::vector<bool> LeftEdge;
		std::vector<bool> TopEdge;
		std::vector<bool> RightEdge;
		std::vector<bool> BottomEdge;
		LeftEdge.assign(Size[2],false);
		TopEdge.assign(Size[1],false);
		RightEdge.assign(Size[2],false);
		BottomEdge.assign(Size[1],false);
		bool LeftExists = true;
		bool TopExists = true;
		bool RightExists = true;
		bool BottomExists = true;
		unsigned int n = Size[0];
		for (unsigned int k = 3; k < n+3; k++){
			top = Top[k];
			left = Left[k]; // set north west corner, 
			for (unsigned int l = 3; l < n+3; l++){
				if ((Right[l] > left) && (Bottom[l] > top)){
					right = Right[l];
					bottom = Bottom[l];  //set south east corner
					for (unsigned int m = 3; m < n+3; m++){	
						if((Left[m] == left) && (Bottom[m] == bottom)){
							//south west corner exists
							sw = true;
						}
						if ((Top[m] == top) && (Right[m] == right)){
							//north east corner exists
							ne = true;
							}
						}
						// if north west, south east, south west, and north east corners exist, found a rectangle/square, 
						if((ne == true) && (sw == true)) {
						// can test if rectangle edges exist once we know the corners exist
						if (k != l) { // if k == l the corners are those of an element (a square), if not, it's not the corners of an element
							for (unsigned int q = 3; q < n+3; q++){
								// assign true to each point on integer lattice of tiling along, left, top, right, bottom edges
								if (left == Left[q]) {
									for ( int qq = Top[q]; qq < Bottom[q]; qq++){
										LeftEdge[qq] = true;
									}
								}
								if (right == Right[q]) {
									for ( int qq = Top[q]; qq < Bottom[q]; qq++){
										RightEdge[qq] = true;
									}
								}
								if (top == Top[q]) {
									for ( int qq = Left[q]; qq < Right[q]; qq++){
										TopEdge[qq] = true;
									}
								}
								if (bottom == Bottom[q]) {
									for ( int qq = Left[q]; qq < Right[q]; qq++){
										BottomEdge[qq] = true;
									}
								}
							}
							// if any of the points on an edge are false, the rectangle edge doesnt exist at that point, and hence the rectangle doesnt either
							for ( int q = left; q < right; q++){
								if (TopEdge[q] == false){
									TopExists = false;
									break;
								}
							}
							for ( int q = top; q < bottom; q++){
								if (RightEdge[q] == false){
									RightExists = false;
									break;
								}			
							}	
							for ( int q = left; q < right; q++){
								if (BottomEdge[q] == false){
									BottomExists = false;
									break;
								}
							}	
							for ( int q = top; q < bottom; q++){
								if (LeftEdge[q] == false){
									LeftExists = false;
									break;
								}
							}
							// if all 4 edges exist it can be counted as a square or rectangular element/container/inclusion of the dissection	
							if ( (TopExists && RightExists) && (BottomExists && LeftExists) ) {	
								if ( (bottom - top) == (right - left) ){
									squares++; // square
								} else {
									rectangles++; // rectangle
								}
							}
							LeftEdge.assign(Size[2],false);
							TopEdge.assign(Size[1],false);
							RightEdge.assign(Size[2],false);
							BottomEdge.assign(Size[1],false);
							LeftExists = true;
							TopExists = true;
							RightExists = true;
							BottomExists = true;
						} else { squares++; } // found the corners of an element (a square), no need to check if the edges are complete
					} // if nw & se corners true
				ne = false;
				sw = false;
				} //
			} //
		} //
		// Test	 if a tiling is a siss, or spss (number of squares = order + 1, 0 rectangles ) or an spsr, or sisr ( number of squares = order, 1 rectangle ) its simple
		// or else its compound; ciss, cpss, cisr, cpsr
		// ((squares == Size[0]) && (rectangles == 1)) if true its a simple squared rectangle
		// ((squares == Size[0]+1) && (rectangles == 0)) if true its a simple squared square 
		// a squared square has an extra square compared to a squared rectangle of the same order - the containing square
		// if its not a simple (squared rectangle or simple squared square) it must be compound
		
		if (((squares == Size[0]) && (rectangles == 1)) || ((squares == Size[0]+1) && (rectangles == 0))){
			simpcount++;
			comp = false;
		} else {
			compcount++;
			comp = true;
		}
		squares = 0;
		rectangles = 0;
		Top.clear();
		Bottom.clear();
		Left.clear();
		Right.clear();
		Size.clear();
		Boundary.clear();
		std::ostringstream ous;
		if (comp)
		{
			ous <<argv[1]<<"-cmp.txt";
			cmp_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!cmp_file) // check it opened ok
			{
				std::cerr << "Cannot open file " << ous.str() << " for output.\n"; 
			}
			cmp_file << line << std::endl;
			cmp_file.close();
		} else {
			ous <<argv[1]<<"-smp.txt";
			smp_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
			if (!smp_file) // check it opened ok
			{
				std::cerr << "Cannot open file " << ous.str() << " for output.\n"; 
			}
			smp_file << line << std::endl;
			smp_file.close();
		}
		ins.clear();// clear the stream to reset, otherwise it will only work for the first line
	}
  	infile.close();
	std::cout<<simpcount+compcount<<" Bouwkampcodes (or tablecodes) from "<<argv[1]<<" processed;"<<std::endl;
	if (simpcount == 0) {
	} else if (simpcount == 1) {
			std::cout<<simpcount<<" Simple saved to "<<argv[1]<<"-smp.txt"<<std::endl;
	} else if (simpcount > 1) {
			std::cout<<simpcount<<" Simples saved to "<<argv[1]<<"-smp.txt"<<std::endl;
	}
	if (compcount == 0) {
	} else if (compcount == 1) {
		std::cout<<compcount<<" Compound saved to "<<argv[1]<<"-cmp.txt"<<std::endl;
	} else if (compcount > 1) {
		std::cout<<compcount<<" Compounds saved to "<<argv[1]<<"-cmp.txt"<<std::endl;
	}
	std::cout.precision(5);
	std::cout<<"This program has run for: "<< float( clock () - begin_time ) /  CLOCKS_PER_SEC<< " seconds."<<std::endl;
	return 0;
}// 
