// author Stuart Errol Anderson;
// March 28 2012
// stuart.errol.anderson@gmail.com
//  bk2cpss
//  bouwkampcode to compound perfect squared squares
#include <vector>
#include <iterator>
#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <algorithm>
#include <sys/time.h>
double get_time(){
    struct timeval t;
    gettimeofday(&t, NULL);
    double d = t.tv_sec + (double) t.tv_usec/1000000;
    return d;
}
int GCD(int x,int y)
{
	if (y==0) 
		return x; 
	else
		return GCD(y,x%y); 
}

int main(int argc, char *argv[])
{
	double time_start = get_time();
	// open bouwkampcode file
	std::ifstream infile;
	infile.open(argv[1]);
	if(infile.fail())
 	{
		if (argc == 1) {
			std::cout<<" bk2cpss (bouwkampcode to compound perfect squared squares) is an application"<<std::endl;
			std::cout<<" designed to substitute a squared square inside each element of another squared"<<std::endl;
			std::cout<<" square to produce compound perfect squared squares (CPSSs). Input is squared"<<std::endl;
			std::cout<<" square bouwkampcode (or tablecode) and output files are tablecode."<<std::endl;
			std::cout<<" usage; bk2cpss filename"<<std::endl;
			std::cout<<" author Stuart Errol Anderson;"<<std::endl;
			std::cout<<" March 28, 2012"<<std::endl;
			std::cout<<" stuart.errol.anderson@gmail.com"<<std::endl;
		}
		else {
            std::cout<<" error; file "<<argv[1]<<" failed to load"<<std::endl;
	       	exit(0);
		}
		exit(0);
	}
	std::cout<<" Processing bouwkampcodes to create compound perfect squared squares (CPSSs) ..."<<std::endl;
	//create a stringstream, strings for lines and values
	std::istringstream stream;
	std::string line;
	// read bouwkampcode strings into vector of vector of ints
	std::vector<int> bkElements;
	std::vector<std::vector<int> > bkCodes;
	int linecount = 0;
	while ( std::getline(infile, line, '\n' ) &&(line.length()>7)) { // extract lines, ignore blank lines, minimum length tablecode is 1 1 1 1, (a single square as a tiling) which is 4 chars + 3 whitespace + 1 line ending character = 8 characters . 
		replace( line.begin(), line.end(), ',', ' ' );  // if bouwkampcode (not tablecode) replace commas with white space
		replace( line.begin(), line.end(), '(', ' ' );  // if bouwkampcode (not tablecode) replace open parenthesis with white space
		replace( line.begin(), line.end(), ')', ' ' ); //  if bouwkampcode (not tablecode) replace close parenthesis with white space
		stream.str("");
		stream.clear();
		stream.str(line);   // Specify string to read.
		int element = 0;
		while ( stream >> element  ) 	{ // get values in columns, use whitespace to separate values
			bkElements.push_back(element);  //store bouwkampcode elements into a vector of integers, within a vector
		}
		bkCodes.push_back(bkElements);
		bkElements.clear();
	}
	std::vector<std::vector<int> >::iterator bkCodes_iterator1;
	std::vector<std::vector<int> >::iterator bkCodes_iterator2;
	std::vector<int>::iterator bkElements_iterator1;
	std::vector<int>::iterator bkElements_iterator2;
	std::vector<int> Top1 ;
	std::vector<int> Top2 ;
	std::vector<int> Top3 ;
	std::vector<int> Bottom1 ;
	std::vector<int> Bottom2 ;
	std::vector<int> Bottom3 ;
	std::vector<int> Left1;
	std::vector<int> Left2;
	std::vector<int> Left3;
	std::vector<int> Right1 ;
	std::vector<int> Right2 ;
	std::vector<int> Right3 ;
	std::vector<int> Size1 ;
	std::vector<int> Size2 ;
	std::vector<int> Size3 ;
	std::vector<int> Boundary1 ;
	std::vector<int> Boundary2 ;
	bool startrow = true;
	int startx = 0 ;
	int starty = 0 ;	
	int BoundaryWidth1 = 0;
	int BoundaryWidth2 = 0;
	int MaxInt = 1000000000;		
	int l = 0; int n = 0;  
	for(bkCodes_iterator1 = bkCodes.begin(); bkCodes_iterator1!=bkCodes.end(); ++bkCodes_iterator1) {  //iterate over the vector (of bouwkampcodes) of vector of ints (bouwkampcode elements)
		for(bkElements_iterator1 = (*bkCodes_iterator1).begin(); bkElements_iterator1!=(*bkCodes_iterator1).end(); ++bkElements_iterator1) {
			Size1.push_back(*bkElements_iterator1);  //create vector of outer square square bouwkampcode elements
		}  
		
	//create outer squared square
		// Place the squares ;  starting at top left, position successive squares from left to right in rows
		// the first row is the top edge of the tiling, successive rows descend in order of height.
		// If 2 (or more) rows have the same height, the leftmost one(s) come first.
		for (unsigned int a = 0; a <  3; a++){	// put dummy zeros in first 3 vector locations of positioning vectors
			Left1.push_back(0);
			Right1.push_back(0);
			Top1.push_back(0);
			Bottom1.push_back(0);
			Boundary1.push_back(0);
		}
		BoundaryWidth1 = Size1.at(1);
		for (unsigned int j = 3; j <  Size1.size(); j++){	
			if (startrow == true) {							
				Left1.push_back(startx);		
				startrow = false;	
			} else {
				Left1.push_back(Left1.at(j-1) + Size1.at(j-1));
			}
			Right1.push_back(Left1[j] + Size1[j]);
			Top1.push_back(starty);
			Bottom1.push_back(Top1[j] + Size1[j]);
			Boundary1.push_back(j);
			for (unsigned int k = 0; k < j; k++) { // remove (make negative) old bottom square(s) from boundary list when covered by new one
				l=Boundary1[k];
				if (l>0){  
					if ((Top1[j] == Bottom1[l])&&(Left1[j]<=Left1[l])&&(Left1[l]<=Right1[j])) {
						BoundaryWidth1 = BoundaryWidth1+Size1[k];
						Boundary1.at(k) = -Boundary1[k];
					}
				}
			}
			if ((Right1.at(j)-startx-BoundaryWidth1) == 0){
				startrow = true;
				BoundaryWidth1 = 0;
				startx=MaxInt; //start 
				starty=MaxInt;
				for (unsigned int m=3; m <= j; m++){ // find minimum Boundary Bottom (starty) and Left (startx)
					n = Boundary1[m];
					if ((n>0)&&(Bottom1[n] < starty)){
						starty = Bottom1[n];
						startx = Left1[n];
					} else if ((n > 0)&&(Bottom1[n] == starty)){
						if (startx > Left1[n]){
							startx = Left1[n];	
						}
					}
				}
			} else {
				startrow = false;	
			}
		} 			
		for(bkCodes_iterator2 = bkCodes.begin(); bkCodes_iterator2!=bkCodes.end(); ++bkCodes_iterator2) {
			for(bkElements_iterator2 = (*bkCodes_iterator2).begin(); bkElements_iterator2!=(*bkCodes_iterator2).end(); ++bkElements_iterator2) {
				Size2.push_back(*bkElements_iterator2);
			}  
		//create inner squared square, same algorithm as lines 100-151
			l = 0; n = 0;
			startrow = true;
			startx = 0 ;
			starty = 0 ;	
			for (unsigned int b = 0; b <  3; b++){		
				Left2.push_back(0);
				Right2.push_back(0);
				Top2.push_back(0);
				Bottom2.push_back(0);
				Boundary2.push_back(0);
			}
			BoundaryWidth2 = Size2.at(1);
			for (unsigned int h = 3; h <  Size2.size(); h++){	
				if (startrow == true) {							
					Left2.push_back(startx);		
					startrow = false;	
				} else {
					Left2.push_back(Left2.at(h-1) + Size2.at(h-1));
				}
				Right2.push_back(Left2[h] + Size2[h]);
				Top2.push_back(starty);
				Bottom2.push_back(Top2[h] + Size2[h]);
				Boundary2.push_back(h);
				for (unsigned int i = 0; i < h; i++) { 
					l=Boundary2[i];
					if (l>0){  
						if ((Top2[h] == Bottom2[l])&&(Left2[h]<=Left2[l])&&(Left2[l]<=Right2[h])) {
							BoundaryWidth2 = BoundaryWidth2+Size2[i];
							Boundary2.at(i) = -Boundary2[i];
						}
					}
				}
				if ((Right2.at(h)-startx-BoundaryWidth2) == 0){
					startrow = true;
					BoundaryWidth2 = 0;
					startx=MaxInt; 
					starty=MaxInt;
					for (unsigned int g=3; g <= h; g++){ 
						n = Boundary2[g];
						if ((n>0)&&(Bottom2[n] < starty)){
							starty = Bottom2[n];
							startx = Left2[n];
						} else if ((n > 0)&&(Bottom2[n] == starty)){
							if (startx > Left2[n]){
								startx = Left2[n];	
							}
						}
					}
				} else {
					startrow = false;	
				}
			} 
			for (unsigned int c=3; c < Size1.size(); c++){ // iterate over outer squared square elements, each outer element will contain the inner squared square
			    int gcd = GCD(Size1.at(c),Size2.at(1));
			    //Size2.at(1)/gcd is outer scale factor for outer squared square
			    //Size1.at(c)/gcd is inner scale factor for inner squared square
				for (unsigned int d = 0; d <  3; d++){	// put dummy zeros in first 3 vector locations of positioning vectors
					Left3.push_back(0);
					Right3.push_back(0);
					Top3.push_back(0);
					Bottom3.push_back(0);
				}
				Size3.push_back(Size1.size()+Size2.size()-7);  // add orders , less 1 for the substituted square, less 6 for o,w,h (1) and o,w,h (2)
				Size3.push_back(Size1.at(1)*Size2.at(1)/gcd); // multiply outer square square elements by outer scale factor
				Size3.push_back(Size1.at(1)*Size2.at(1)/gcd);
				int positionX = 0;
				int positionY = 0;
				for (unsigned int e=3; e < Size1.size(); e++){  //scale outer squared square
					if (e !=c) {  // must not add element which is being substituted into, but must know its position to do translation of inner square elements
						Size3.push_back(Size1.at(e)*Size2.at(1)/gcd);
						Left3.push_back(Left1.at(e)*Size2.at(1)/gcd);
						Right3.push_back(Right1.at(e)*Size2.at(1)/gcd);
						Top3.push_back(Top1.at(e)*Size2.at(1)/gcd);
						Bottom3.push_back(Bottom1.at(e)*Size2.at(1)/gcd);		
					}	
					else {  //position translation coordinates of inner squared square
						positionX = Left1.at(e)*Size2.at(1)/gcd;
						positionY = Top1.at(e)*Size2.at(1)/gcd;
					}		
				}
				for (unsigned int f=3; f < Size2.size(); f++){  //scale and translate inner squared square into outer squared square
					Size3.push_back(Size2.at(f)*Size1.at(c)/gcd);
					Left3.push_back((Left2.at(f)*Size1.at(c)/gcd)+positionX);
					Right3.push_back((Right2.at(f)*Size1.at(c)/gcd)+positionX);
					Top3.push_back((Top2.at(f)*Size1.at(c)/gcd)+positionY);
					Bottom3.push_back((Bottom2.at(f)*Size1.at(c)/gcd)+positionY);					
				}
				std::vector<int> sortedTop(Top3); //copy Top3 vector to sortedTop vector using constructor
				std::vector<int> sortedLeft(Left3);// "      Left3     "      "  sortedLeft  "          "           "
				std::sort(sortedTop.begin(), sortedTop.end()); // sort sortedTop vector in ascending order
				std::sort(sortedLeft.begin(), sortedLeft.end());//   "    sortedLeft   "       "      "               "
				sortedTop.erase( std::unique( sortedTop.begin(),sortedTop.end() ), sortedTop.end() ); // unique sortedTop vector in ascending order
				sortedLeft.erase( std::unique( sortedLeft.begin(),sortedLeft.end() ), sortedLeft.end() );//   "         sortedLeft   "       "      "               "				
				std::vector<int> compBkcode; //create combined bouwkampcode for the compound squared square
				compBkcode.push_back(Size3.at(0));  // Order of squared square
				compBkcode.push_back(Size3.at(1));  // Width  "      "             "
				compBkcode.push_back(Size3.at(2));  // Height (= Width) 
				for (unsigned int p=0; p < sortedTop.size(); p++){
					for (unsigned int q=0; q < sortedLeft.size(); q++){
						for (unsigned int r=3; r < Size3.size(); r++){
							if((sortedTop.at(p)==Top3.at(r))&&(sortedLeft.at(q)==Left3.at(r))){
								compBkcode.push_back(Size3.at(r));
							}
						}
					}
				}
        		// perfection / imperfection test
        		std::vector<int> perfectionTest(compBkcode);
        		perfectionTest.erase (perfectionTest.begin(),perfectionTest.begin()+3);
        	 	std::sort(perfectionTest.begin(),perfectionTest.end());
			 	perfectionTest.erase( std::unique( perfectionTest.begin(),perfectionTest.end() ), perfectionTest.end() );//
			 	if ( perfectionTest.size() == compBkcode.size()-3) { // if all the elements are unique , tiling squares are all different sizes ,ie 'perfect'			 	  		
				 	// save perfect compound bouwkampcode to file	
					std::ostringstream startbk;
					std::ostringstream ous;
					ous <<"cpss-"<<argv[1];
					std::ofstream cpss_file;	// create ofstream  tiling CPSS bouwkampcode output file
					cpss_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
					if (!cpss_file) // check it opened ok
					{
							std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
					}
					std::string line1 = startbk.str();
					 for (unsigned int s = 0; s <  compBkcode.size(); s++){	//copy compBKcode vector elements to compound bouwkampcode string 
							startbk.clear();
							startbk.str("");
							startbk << compBkcode.at(s) << " ";
						    line1 += startbk.str();
					}
					line1 += "\n";
					cpss_file << line1 ;  //output compound bouwkampcode string to open output text file; cpss_file
					 linecount++;
					startbk.clear();  // clear all variables, arrays
					startbk.str("");	
				}
				Size3.clear();  // clear all , etc
				Left3.clear();
				Right3.clear();
				Top3.clear();
				Bottom3.clear();
				sortedTop.clear();
				sortedLeft.clear();
				compBkcode.clear();
				perfectionTest.clear();
			}	
			Size2.clear();		
			Left2.clear();
			Right2.clear();
			Top2.clear();
			Bottom2.clear();
			Boundary2.clear();
		}
		Size1.clear();
		Left1.clear();
		Right1.clear();
		Top1.clear();
		Bottom1.clear();
		Boundary1.clear();
	}
 	double time_end = get_time();
	std::cout.precision(5);
	if (linecount > 0) std::cout<<" "<<bkCodes.size() <<" bouwkampcodes from file "<<argv[1]<<" processed."<<std::endl;
	std::cout<<" "<<linecount<<" bouwkampcodes saved to cpss-"<<argv[1]<<std::endl;
	std::cout<<" This program has run for: "<< time_end - time_start<< " seconds."<<std::endl;
	return 0;
}
