// author Stuart Errol Anderson;
// April 29 2013
// stuart.errol.anderson@gmail.com
//  bk2allw
//  bouwkampcode to all bouwkampcodes
#include <vector>
#include <iterator>
#include <iostream>
#include <fstream>
#include <string>
#include <sstream>
#include <iomanip>
#include <utility>
#include <algorithm>
#include <cmath>
#include <cstring>
#include <cstdlib>
#include <exception>
#include <time.h>

long i = 6000000L;
clock_t start, finish;
double duration;

int main (int argc, char* argv[]){
	start = clock();
	std::ifstream infile;
	//open ifstream infile
	infile.open(argv[1]);
	if(infile.fail()) {
		if (argc == 1) {
			std::cout<<" bk2allw (bouwkampcode to all (bkcodes)) is an application"<<std::endl;
			std::cout<<" designed to read a single bouwkampcode of a squared rectangle"<<std::endl;
			std::cout<<" or squared square and produce all the rotations and reflections."<<std::endl;
			std::cout<<" of that tiling, also in bouwkampcode"<<std::endl;
			std::cout<<" usage; bk2allw filename"<<std::endl;
			std::cout<<" author Stuart Errol Anderson;"<<std::endl;
			std::cout<<" April 29, 2013"<<std::endl;
			std::cout<<" stuart.errol.anderson@gmail.com"<<std::endl;
			
		}
		else {
            std::cout<<" error; file "<<argv[1]<<" failed to load"<<std::endl;
	       	exit(0);
		}
		exit(0);
	}
	std::cout<<" Processing bouwkampcodes..."<<std::endl;
	//create a stringstream, strings for lines and values
	std::istringstream stream;
	std::istringstream ss;
	std::string line;
	std::string value;
	std::ofstream bkall_file;	// create ofstream  tiling bouwkampcode output file
   	std::ostringstream ous;
	ous <<"bkall-"<<argv[1];
	std::vector<int> Top ;
	std::vector<int> Bottom ;
	std::vector<int> Left;
	std::vector<int> Right ;
	std::vector<int> Size ;
	std::vector<int> Boundary ;
	std::vector<std::vector<int> > bkCodes;
	int counter = 0;
	int Order = 0;
	int BoundaryWidth = 0;
	int RectWidth = 0;
	int RectHeight = 0;	
	int MaxInt = 1000000000;
	int element = 0;
   	int linecount = 0;

	while ( std::getline(infile, line, '\n' ) &&(line.length()>1)) { // extract lines
		 std::istringstream ins; // Declare an input string stream.
  		 size_t found;
  		 std::string linebk;
  		 std::string lineend;
  		 found=line.find("*");
  		 if (found != std::string::npos) {
              linebk = line.substr(0,found-1); // separate the bouwkampcode from the extended fields if they exist
              lineend = line.substr(found+1);
         } else {
        	  linebk = line;
        }
  		//if bouwkampcode convert to tablecode by deleting parentheses and commas and replacing with whitespace
		replace( linebk.begin(), linebk.end(), ',', ' ' );
		replace( linebk.begin(), linebk.end(), '(', ' ' );
		replace( linebk.begin(), linebk.end(), ')', ' ' );
		std::string newline;
  		newline += linebk;
  		newline += lineend;
  		ins.str(newline);        // Specify string to read.
		linecount ++;
		bool startrow = true;
		int s = 0;
		int startx = 0 ;
		int starty = 0 ;
		stream.clear();
		stream.str(linebk); 
		while ( stream >> value  ) 	{ // get values in columns
			if (s <= 2) {
				if (s == 0) { 
					std::istringstream ss(value);
					ss >> Order ;//1st value is order
					ss.str("");
					int bksize = Order + 4;
		 			Top.reserve(bksize) ;
		 			Bottom.reserve(bksize) ;
		 			Left.reserve(bksize);
		 			Right.reserve(bksize) ;
		 			Size.reserve(bksize) ;
		 			Boundary.reserve(bksize) ;
		 			Size.push_back(Order);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
				}
	  			if (s == 1) {
		  			std::istringstream	ss(value);
		  			ss >> RectWidth ;//2nd value is width
		  			BoundaryWidth = RectWidth;
		  			Size.push_back(RectWidth);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
		  			ss.str("");
	  			}
				if (s == 2) {
					std::istringstream	ss(value);
					ss >> RectHeight ;//3rd value is height
	  				Size.push_back(RectHeight);
		  			Top.push_back(0);
		  		    Left.push_back(0);
		  			Right.push_back(0);
	  				Bottom.push_back(0);
	  				Boundary.push_back(0);
					ss.str("");
				} //
			} else {
				std::istringstream ss(value);
				 ss >> element;
				 ss.str("");
				Size.push_back(element);
			} //
			s++;
		} //
		// Place the squares ;  starting at top left, position successive squares from left to right in rows
		// the first row is the top edge of the tiling, successive rows descend in order of height.
		// If 2 (or more) rows have the same height, the leftmost one(s) come first.
		int l = 0; int n = 0;  
	    for (unsigned int j = 3; j <  Size.size(); j++){	
			if (startrow == true) {							
				Left.push_back(startx);		
				startrow = false;	
			} else {
			    
				Left.push_back(Left.at(j-1) + Size.at(j-1));
			}
			Right.push_back(Left[j] + Size[j]);
			Top.push_back(starty);
			Bottom.push_back(Top[j] + Size[j]);
			Boundary.push_back(j);
			for (unsigned int k = 0; k < j; k++) { // remove (make negative) old bottom square(s) from boundary list when covered by new one
			    l=Boundary[k];
				if (l>0){  
					if ((Top[j] == Bottom[l])&&(Left[j]<=Left[l])&&(Left[l]<=Right[j])) {
						BoundaryWidth = BoundaryWidth+Size[k];
						Boundary.at(k) = -Boundary[k];
					}
				}
			}
			if ((Right.at(j)-startx-BoundaryWidth) == 0){
				startrow = true;
				//v++;
				BoundaryWidth = 0;
				startx=MaxInt; //start 
  				starty=MaxInt;
				for (unsigned int m=3; m <= j; m++){ // find minimum Boundary Bottom (starty) and Left (startx)
					n = Boundary[m];
					if ((n>0)&&(Bottom[n] < starty)){
						starty = Bottom[n];
						startx = Left[n];
					} else if ((n > 0)&&(Bottom[n] == starty)){
						if (startx > Left[n]){
							startx = Left[n];	
						}
					}
				}
			} else {
				startrow = false;	
			}
		} 
		//copy element position vectors
		std::vector<int> sortedTop(Top); //copy Top vector to sortedTop vector using constructor
		std::vector<int> sortedLeft(Left);// "      Left     "      "  sortedLeft  "          "           "
		std::vector<int> sortedRight(Right); //    copy Right vector to sortedRight vector using constructor
		std::vector<int> sortedBottom(Bottom);// "      Bottom "      "  sortedBottom  "          "           "		
		
		//eliminate 1st 3 values (zeroed order, width, height) from copied element position vectors
        sortedTop.erase (sortedTop.begin(),sortedTop.begin()+3);
        sortedLeft.erase (sortedLeft.begin(),sortedLeft.begin()+3);
        sortedRight.erase (sortedRight.begin(),sortedRight.begin()+3);
        sortedBottom.erase (sortedBottom.begin(),sortedBottom.begin()+3);
        
		//sort copied element position vectors
		std::sort(sortedTop.begin(), sortedTop.end()); // sort sortedTop vector in ascending order
		std::sort(sortedLeft.begin(), sortedLeft.end());//   "    sortedLeft   "       "      "               "
		std::sort(sortedRight.begin(), sortedRight.end()); //       sort sortedRight vector in ascending order
		std::sort(sortedBottom.begin(), sortedBottom.end());//   "    sortedBottom   "       "      "               "			
		
		//eliminate duplicate values to get unique sorted element position vectors
		sortedTop.erase( std::unique( sortedTop.begin(),sortedTop.end() ), sortedTop.end() ); // unique sortedTop vector in ascending order
		sortedLeft.erase( std::unique( sortedLeft.begin(),sortedLeft.end() ), sortedLeft.end() );//   "         sortedLeft   "       "      "               "			
		sortedRight.erase( std::unique( sortedRight.begin(),sortedRight.end() ), sortedRight.end() ); //                unique sortedTop vector in ascending order
		sortedBottom.erase( std::unique( sortedBottom.begin(),sortedBottom.end() ), sortedBottom.end() );//       "       sortedBottom   "   "      "               "		
							
		std::vector<int> compBkcode; 
		
		//1. create bouwkampcode Top Left -> Bottom Right; Top down
		compBkcode.push_back(Size.at(0));  // Order of squared square
		compBkcode.push_back(Size.at(1));  // Width  "      "             "
		compBkcode.push_back(Size.at(2));  // Height "     "             "
		for (unsigned int p=0; p < sortedTop.size(); p++){
			for (unsigned int q=0; q < sortedLeft.size(); q++){
				for (unsigned int r=3; r < Size.size(); r++){
					if((sortedTop.at(p)==Top.at(r))&&(sortedLeft.at(q)==Left.at(r))){
						compBkcode.push_back(Size.at(r));
					}
				}
			}
		}
		bkCodes.push_back(compBkcode);
		compBkcode.clear();
 
		//2. create bouwkampcode Top Right -> Bottom Left;  Top down
		compBkcode.push_back(Size.at(0));  // Order of squared square
		compBkcode.push_back(Size.at(1));  // Width  "      "             "
		compBkcode.push_back(Size.at(2));  // Height "     "             "
		for (unsigned int p=0; p < sortedTop.size(); p++){
			for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
				for (unsigned int r=3; r < Size.size(); r++){
					if((sortedTop.at(p)==Top.at(r))&&(*qit==Right.at(r))){
						compBkcode.push_back(Size.at(r));
					}
				}
			}
		}
		bkCodes.push_back(compBkcode);
		compBkcode.clear();
	
 		//3. create bouwkampcode Bottom Right -> Top Left ; Bottom up
		compBkcode.push_back(Size.at(0));  // Order of squared square
		compBkcode.push_back(Size.at(1));  // Width  "      "             "
		compBkcode.push_back(Size.at(2));  // Height "     "             "
		for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
			for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
				for (unsigned int r=3; r < Size.size(); r++){
					if((*pit==Bottom.at(r))&&(*qit==Right.at(r))){
						compBkcode.push_back(Size.at(r));
					}
				}
			}
		}
		bkCodes.push_back(compBkcode);
		compBkcode.clear();
 
		//4. create bouwkampcode Bottom Left -> Top Right ; Bottom up
		compBkcode.push_back(Size.at(0));  // Order of squared square
		compBkcode.push_back(Size.at(1));  // Width  "      "             "
		compBkcode.push_back(Size.at(2));  // Height "     "             "
		for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
			for (unsigned int q=0; q < sortedLeft.size(); q++){
				for (unsigned int r=3; r < Size.size(); r++){
					if((*pit==Bottom.at(r))&&(sortedLeft.at(q)==Left.at(r))){
						compBkcode.push_back(Size.at(r));
					}
				}
			}
		}
		bkCodes.push_back(compBkcode);
		compBkcode.clear();
 
 		//5. create bouwkampcode Top Left -> Bottom Right ; Left down
		compBkcode.push_back(Size.at(0));  // Order of squared square
		compBkcode.push_back(Size.at(2));  // Width  "      "             "
		compBkcode.push_back(Size.at(1));  // Height "     "             "
		for (unsigned int q=0; q < sortedLeft.size(); q++){
			for (unsigned int p=0; p < sortedTop.size(); p++){
				for (unsigned int r=3; r < Size.size(); r++){
					if((sortedTop.at(p)==Top.at(r))&&(sortedLeft.at(q)==Left.at(r))){
						compBkcode.push_back(Size.at(r));
					}
				}
			}
		}
		bkCodes.push_back(compBkcode);
		compBkcode.clear();
 
 		//6. create bouwkampcode Top Right -> Bottom Left ; Right up
		compBkcode.push_back(Size.at(0));  // Order of squared square
		compBkcode.push_back(Size.at(2));  // Width  "      "             "
		compBkcode.push_back(Size.at(1));  // Height "     "             "
		for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
			for (unsigned int p=0; p < sortedTop.size(); p++){
				for (unsigned int r=3; r < Size.size(); r++){
					if((sortedTop.at(p)==Top.at(r))&&(*qit==Right.at(r))){
						compBkcode.push_back(Size.at(r));
					}
				}
			}
		}
		bkCodes.push_back(compBkcode);
		compBkcode.clear();
 
 		//7. create bouwkampcode Bottom Right -> Top Left ; Right up
		compBkcode.push_back(Size.at(0));  // Order of squared square
		compBkcode.push_back(Size.at(2));  // Width  "      "             "
		compBkcode.push_back(Size.at(1));  // Height "     "             "
		for ( std::vector<int>::reverse_iterator qit =sortedRight.rbegin() ; qit < sortedRight.rend(); ++qit ) {
			for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
				for (unsigned int r=3; r < Size.size(); r++){
					if((*pit==Bottom.at(r))&&(*qit==Right.at(r))){
						compBkcode.push_back(Size.at(r));
					}
				}
			}
		}
		bkCodes.push_back(compBkcode);
		compBkcode.clear();
 
 		//8. create bouwkampcode Bottom Left -> Top Right ; Left down
		compBkcode.push_back(Size.at(0));  // Order of squared square
		compBkcode.push_back(Size.at(2));  // Width  "      "             "
		compBkcode.push_back(Size.at(1));  // Height "     "             "
		for (unsigned int q=0; q < sortedLeft.size(); q++){
			for ( std::vector<int>::reverse_iterator pit =sortedBottom.rbegin() ; pit < sortedBottom.rend(); ++pit ) {
				for (unsigned int r=3; r < Size.size(); r++){
					if((*pit==Bottom.at(r))&&(sortedLeft.at(q)==Left.at(r))){
						compBkcode.push_back(Size.at(r));
					}
				}
			}
		}
		bkCodes.push_back(compBkcode);
		compBkcode.clear();
		std::ostringstream bk;
		std::vector<std::vector<int> >::iterator bkCodes_iterator1;
		std::vector<int>::iterator bkElements_iterator1;

		std::string line1 = "";
		bkall_file.open (ous.str().c_str(), std::ios::out|std::ios::app);
		if (!bkall_file) // check it opened ok
		{
				std::cerr << " Cannot open file " << ous.str() << " for output.\n"; 
		}
		for(bkCodes_iterator1 = bkCodes.begin(); bkCodes_iterator1!=bkCodes.end(); ++bkCodes_iterator1) {  //iterate over the vector (of bouwkampcodes) of vector of ints (bouwkampcode elements)
			for(bkElements_iterator1 = (*bkCodes_iterator1).begin(); bkElements_iterator1!=(*bkCodes_iterator1).end(); ++bkElements_iterator1) {
				bk<<*bkElements_iterator1<<" ";  
			} 
			bk<< std::endl;
			line1 = bk.str();
			bk.clear();
			bk.str("");
			bkall_file << line1 ;
			std::cout << line1 ;
			counter++;
			line1.clear();
			line1 = "";				
		}
		std::cout << std::endl;
		bkall_file << std::endl;
		bkall_file.close();  
		ous.clear();
		bk.clear();
		bkCodes.clear();
		compBkcode.clear();
		Top.clear() ;
		Bottom.clear() ;
		Left.clear();
		Right.clear() ;
		Size.clear() ;
		Boundary.clear() ;
		sortedTop.clear() ;
		sortedBottom.clear() ;
		sortedLeft.clear();
		sortedRight.clear() ;		
	} 
	infile.close();  
     finish = clock();
    duration = (double)(finish - start) / CLOCKS_PER_SEC;
	if (linecount > 0) std::cout<<" "<<linecount <<" bouwkampcodes from file "<<argv[1]<<" processed."<<std::endl;
	std::cout<<" "<<counter<<" bouwkampcodes saved to bkall-"<<argv[1]<<std::endl;
	std::cout<<" This program has run for: "<< duration<< " seconds."<<std::endl;
  	return 0;
}// end function
